#include <Alert.h>
#include <MenuItem.h>
#include <Menu.h>
#include <MenuBar.h>
#include <stdio.h>
#include "ToolTest.h"
#include "TestWindowBase.h"
#include "utils.h"

#include "Debug.h"

/* TestTool */

TestTool* testTool = new TestTool();

void Error(char* what) {
	BAlert* box = new BAlert("Tool Tester Plugin", what, "Rats");
	box->Go();
}

TestTool::TestTool() {
DEBUGOUT("TestTool:TestTool()\n");

DEBUGOUT("Getting Shirley Open Tools API\n");

	ShirleyOpenToolsAPI* tools = ShirleyOpenToolsAPI::Instance();
	
	if(tools) {
DEBUGOUT("Getting Shirley BMenuBar\n");
		BMenuBar* menu = tools->ShirleyMenuBar();
		
		if(menu) {
DEBUGOUT("Adding the \"Open Tools Test\" menu item\n");
			BMenuItem* help = menu->FindItem("Help");
			BMenu* helpMenu = help->Submenu();
			
			BSeparatorItem* sep = new BSeparatorItem();
			helpMenu->AddItem(sep,0);
			
			BMenuItem* test = new BMenuItem("Open Tools Test", new BMessage(CMD_TOOLTEST));
			helpMenu->AddItem(test,0);
			
			tools->RegisterHandlerPluggin(WIN_MAIN, this);
			if(help) {
			} else {
				Error("Could not find Help menu item");
			}
		} else {
			Error("Could not get Shirley menu bar object");
		}
	} else {
		Error("Could not get Shirley Open Tools API class");
	}
}

bool TestTool::MessageReceived(BMessage* message) {
	if(message->what == CMD_TOOLTEST) {
		ShirleyOpenToolsAPI* tools = ShirleyOpenToolsAPI::Instance();
	
		if(tools) {
			TestWindowBase* win = new TestWindowBase();
			CenterWindow(win);
		
			char buf[128];
			sprintf(buf, win->lString->Text(), tools->ShirleyVersionString());
			win->lString->SetText(buf);
			sprintf(buf, win->lMajor->Text(), tools->ShirleyMajorVersion());
			win->lMajor->SetText(buf);
			sprintf(buf, win->lMinorVersion->Text(), tools->ShirleyMinorVersion());
			win->lMinorVersion->SetText(buf);
			sprintf(buf, win->lBuild->Text(), tools->ShirleyBuild());
			win->lBuild->SetText(buf);
			
			win->Show();
		} else {
			Error("Could not get Shirley Open Tools API class");
		}
	}
	
	return false;
}
