//============================================================================
//
//   SSSS    tt          lll  lll
//  SS  SS   tt           ll   ll
//  SS     tttttt  eeee   ll   ll   aaaa
//   SSSS    tt   ee  ee  ll   ll      aa
//      SS   tt   eeeeee  ll   ll   aaaaa  --  "An Atari 2600 VCS Emulator"
//  SS  SS   tt   ee      ll   ll  aa  aa
//   SSSS     ttt  eeeee llll llll  aaaaa
//
// Copyright (c) 1995-1998 by Bradford W. Mott
//
// See the file "license" for information on usage and redistribution of
// this file, and for a DISCLAIMER OF ALL WARRANTIES.
//
// Lightgun by Mathias Agopian, 2000
//============================================================================

#include <stdio.h>
#include <assert.h>
#include "Event.hxx"
#include "Lightgun.hxx"

// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
Lightgun::Lightgun(Jack jack, const Event& event)
	:	Controller(jack, event),
		fReadCount(0)
{
}

// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
Lightgun::~Lightgun()
{
}

// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
bool Lightgun::read(DigitalPin pin)
{
	unsigned long x,y;

	// Lightgun exists only on the left jack
	if (myJack != Left)
		return true;

	switch(pin)
	{
		case One:
			if (fReadCount)
				fReadCount = 0;
			return (myEvent.get(Event::LightGunZeroFire) == 0);
			
	    case Two:		return false;
		case Three:		return false;
		case Four:		return false;
						
		case Six:
			// For Sentinel, it's 11 reads by line (144x192)
			// 2079 (11*189) reads total
			// On a line 6 is the central point
			fReadCount++;
			x = myEvent.get(Event::LightGunZeroX);
			y = myEvent.get(Event::LightGunZeroY);
			return (fReadCount != (y+5)*11 + (x+6+5)/13); // +5 to center around the mouse cursor

		default:
			return true;
	}
}

// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
Int32 Lightgun::read(AnalogPin p)
{
	return maximumResistance;
}

// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
void Lightgun::write(DigitalPin, bool)
{
}

