--       _________ __                 __
--      /   _____//  |_____________ _/  |______     ____  __ __  ______
--      \_____  \\   __\_  __ \__  \\   __\__  \   / ___\|  |  \/  ___/
--      /        \|  |  |  | \// __ \|  |  / __ \_/ /_/  >  |  /\___ \ 
--     /_______  /|__|  |__|  (____  /__| (____  /\___  /|____//____  >
--             \/                  \/          \//_____/            \/ 
--  ______________________                           ______________________
--			  T H E   W A R   B E G I N S
--	   Stratagus - A free fantasy real time strategy game engine
--
--	units.ccl	-	Define the used human unit-types.
--
--	(c) Copyright 2001,2002 by Lutz Sammer
--
--      This program is free software; you can redistribute it and/or modify
--      it under the terms of the GNU General Public License as published by
--      the Free Software Foundation; either version 2 of the License, or
--      (at your option) any later version.
--  
--      This program is distributed in the hope that it will be useful,
--      but WITHOUT ANY WARRANTY; without even the implied warranty of
--      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--      GNU General Public License for more details.
--  
--      You should have received a copy of the GNU General Public License
--      along with this program; if not, write to the Free Software
--      Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
--
--	$Id: units.lua,v 1.6 2004/02/09 15:54:43 nobody_ Exp $

--=============================================================================
--	Define unit-types.
--
--	NOTE: Save can generate this table.
--

DefineUnitType("unit-footman", { Name = "Footman",
  Files = {"tileset-summer", "human/units/footman.png"},
  Size = {72, 72},
  Animations = "animations-footman", Icon = "icon-footman",
  Costs = {"time", 60, "gold", 600},
  Speed = 10,
  HitPoints = 60,
  DrawLevel = 40,
  TileSize = {1, 1}, BoxSize = {31, 31},
  SightRange = 4, ComputerReactionRange = 6, PersonReactionRange = 4,
  Armor = 2, BasicDamage = 6, PiercingDamage = 3, Missile = "missile-none",
  MaxAttackRange = 1,
  Priority = 60,
  Points = 50,
  Demand = 1,
  Corpse = {"unit-dead-body", 6},
  Type = "land",
  RightMouseAction = "attack",
  CanAttack = true,
  CanTargetLand = true,
  LandUnit = true,
  organic = true,
  SelectableByRectangle = true,
  Sounds = {
    "selected", "footman-selected",
    "acknowledge", "footman-acknowledge",
    "ready", "footman-ready",
    "help", "basic human voices help 1",
    "dead", "basic human voices dead",
    "attack", "footman-attack"} } )

DefineUnitType("unit-peasant", { Name = "Peasant",
  Files = {"tileset-summer", "human/units/peasant.png"},
  Size = {72, 72},
  DrawLevel = 19,
  Animations = "animations-peasant", Icon = "icon-peasant",
  Costs = {"time", 45, "gold", 400},
  Speed = 10,
  HitPoints = 30,
  DrawLevel = 40,
  TileSize = {1, 1}, BoxSize = {31, 31},
  SightRange = 4, ComputerReactionRange = 6, PersonReactionRange = 4,
  BasicDamage = 3, PiercingDamage = 2, Missile = "missile-none",
  MaxAttackRange = 1,
  Priority = 50,
  Points = 30,
  Demand = 1,
  Corpse = {"unit-dead-body", 6},
  Type = "land",
  RightMouseAction = "harvest",
  CanAttack = true, RepairRange = 1,
  CanTargetLand = true,
  LandUnit = true,
  Coward = true,
  CanGatherResources = {
   {"file-when-loaded", "human/units/peasant_with_gold.png",
    "resource-id", "gold",
--    "harvest-from-outside",
    "resource-capacity", 100,
    "wait-at-resource", 150,
    "wait-at-depot", 150},
   {"file-when-loaded", "human/units/peasant_with_wood.png",
    "resource-id", "wood",
    "resource-capacity", 100,
    "resource-step", 2,
    "wait-at-resource", 24,
    "wait-at-depot", 150,
    "lose-resources",
    "terrain-harvester"}},
  organic = true,
  SelectableByRectangle = true,
  Sounds = {
    "selected", "peasant-selected",
    "acknowledge", "peasant-acknowledge",
    "ready", "peasant-ready",
--    "repair", "peasant-attack",
    "harvest", "wood", "tree chopping",
    "help", "basic human voices help 1",
    "dead", "basic human voices dead",
    "attack", "peasant-attack"} } )

DefineUnitType("unit-ballista", { Name = "Ballista",
  Files = {"tileset-summer", "human/units/ballista.png"},
  Size = {64, 64},
  Animations = "animations-ballista", Icon = "icon-ballista",
  Costs = {"time", 250, "gold", 900, "wood", 300},
  Speed = 5,
  HitPoints = 110,
  DrawLevel = 40,
  TileSize = {1, 1}, BoxSize = {63, 63},
  SightRange = 9, ComputerReactionRange = 11, PersonReactionRange = 9,
  BasicDamage = 80, PiercingDamage = 0, Missile = "missile-ballista-bolt",
  MinAttackRange = 2, MaxAttackRange = 8,
  Priority = 70,
  Points = 100,
  Demand = 1,
  ExplodeWhenKilled = "missile-explosion",
  Type = "land",
  RightMouseAction = "attack",
  CanGroundAttack = true,
  CanAttack = true,
  CanTargetLand = true, CanTargetSea = true,
  SelectableByRectangle = true,
  Sounds = {
    "selected", "ballista-selected",
    "acknowledge", "ballista-acknowledge",
    "ready", "ballista-ready",
    "help", "basic human voices help 1",
    "dead", "explosion",
    "attack", "ballista-attack"} } )

DefineUnitType("unit-knight", { Name = "Knight",
  Files = {"tileset-summer", "human/units/knight.png"},
  Size = {72, 72},
  Animations = "animations-knight", Icon = "icon-knight",
  Costs = {"time", 90, "gold", 800, "wood", 100},
  Speed = 13,
  HitPoints = 90,
  DrawLevel = 40,
  TileSize = {1, 1}, BoxSize = {42, 42},
  SightRange = 4, ComputerReactionRange = 6, PersonReactionRange = 4,
  Armor = 4, BasicDamage = 8, PiercingDamage = 4, Missile = "missile-none",
  MaxAttackRange = 1,
  Priority = 63,
  Points = 100,
  Demand = 1,
  Corpse = {"unit-dead-body", 6},
  Type = "land",
  RightMouseAction = "attack",
  CanAttack = true,
  CanTargetLand = true,
  LandUnit = true,
  organic = true,
  SelectableByRectangle = true,
  Sounds = {
    "selected", "knight-selected",
    "acknowledge", "knight-acknowledge",
    "ready", "knight-ready",
    "help", "basic human voices help 1",
    "dead", "basic human voices dead",
    "attack", "knight-attack"} } )

DefineUnitType("unit-archer", { Name = "Archer",
  Files = {"tileset-summer", "human/units/elven_archer.png"},
  Size = {72, 72},
  Animations = "animations-archer", Icon = "icon-archer",
  Costs = {"time", 70, "gold", 500, "wood", 50},
  Speed = 10,
  HitPoints = 40,
  DrawLevel = 40,
  TileSize = {1, 1}, BoxSize = {33, 33},
  SightRange = 5, ComputerReactionRange = 7, PersonReactionRange = 5,
  BasicDamage = 3, PiercingDamage = 6, Missile = "missile-arrow",
  MaxAttackRange = 4,
  Priority = 55,
  Points = 60,
  Demand = 1,
  Corpse = {"unit-dead-body", 6},
  Type = "land",
  RightMouseAction = "attack",
  CanAttack = true,
  CanTargetLand = true, CanTargetSea = true, CanTargetAir = true,
  LandUnit = true,
  organic = true,
  SelectableByRectangle = true,
  Sounds = {
    "selected", "archer-selected",
    "acknowledge", "archer-acknowledge",
    "ready", "archer-ready",
    "help", "basic human voices help 1",
    "dead", "basic human voices dead",
    "attack", "archer-attack"} } )

DefineUnitType("unit-mage", { Name = "Mage",
  Files = {"tileset-summer", "human/units/mage.png"},
  Size = {72, 72},
  Animations = "animations-mage", Icon = "icon-mage",
  Costs = {"time", 120, "gold", 1200},
  Speed = 8,
  HitPoints = 60,
  DrawLevel = 40,
  MaxMana = 255,
  TileSize = {1, 1}, BoxSize = {33, 33},
  SightRange = 9, ComputerReactionRange = 11, PersonReactionRange = 9,
  BasicDamage = 0, PiercingDamage = 9, Missile = "missile-lightning",
  MaxAttackRange = 2,
  Priority = 70,
  Points = 100,
  Demand = 1,
  Type = "land",
  RightMouseAction = "attack",
  CanAttack = true,
  CanTargetLand = true, CanTargetSea = true, CanTargetAir = true,
  CanCastSpell = {
      "spell-fireball",
      "spell-slow",
      "spell-flame-shield",
      "spell-invisibility",
      "spell-polymorph",
      "spell-blizzard"},
  LandUnit = true,
  Coward = true,
  organic = true,
  SelectableByRectangle = true,
  Sounds = {
    "selected", "mage-selected",
    "acknowledge", "mage-acknowledge",
    "ready", "mage-ready",
    "help", "basic human voices help 1",
    "dead", "basic human voices dead",
    "attack", "mage-attack"} } )

DefineUnitType("unit-paladin", { Name = "Paladin",
  Use = "unit-knight",
  Size = {72, 72},
  Animations = "animations-knight", Icon = "icon-paladin",
  Costs = {"time", 90, "gold", 800, "wood", 100},
  Speed = 13,
  HitPoints = 90,
  DrawLevel = 40,
  MaxMana = 255,
  TileSize = {1, 1}, BoxSize = {42, 42},
  SightRange = 5, ComputerReactionRange = 7, PersonReactionRange = 5,
  Armor = 4, BasicDamage = 8, PiercingDamage = 4, Missile = "missile-none",
  MaxAttackRange = 1,
  Priority = 65,
  Points = 110,
  Demand = 1,
  Corpse = {"unit-dead-body", 6},
  Type = "land",
  RightMouseAction = "attack",
  CanAttack = true,
  CanTargetLand = true,
  CanCastSpell = {"spell-holy-vision", "spell-healing", "spell-exorcism"},
  LandUnit = true,
  organic = true,
  SelectableByRectangle = true,
  Sounds = {
    "selected", "paladin-selected",
    "acknowledge", "paladin-acknowledge",
    "ready", "paladin-ready",
    "help", "basic human voices help 1",
    "dead", "basic human voices dead",
    "attack", "paladin-attack"} } )

DefineUnitType("unit-dwarves", { Name = "Dwarves",
  Files = {"tileset-summer", "human/units/dwarven_demolition_squad.png"},
  Size = {56, 56},
  Animations = "animations-dwarves", Icon = "icon-dwarves",
  Costs = {"time", 200, "gold", 700, "wood", 250},
  Speed = 11,
  HitPoints = 40,
  DrawLevel = 40,
  TileSize = {1, 1}, BoxSize = {32, 32},
  SightRange = 4, ComputerReactionRange = 4, PersonReactionRange = 2,
  BasicDamage = 4, PiercingDamage = 2, Missile = "missile-none",
  MaxAttackRange = 1,
  Priority = 55,
  Points = 100,
  Demand = 1,
  Type = "land",
  RightMouseAction = "spell-cast",
  CanCastSpell = {"spell-suicide-bomber"},
  CanAttack = true,
  CanTargetLand = true,
  LandUnit = true,
  volatile = true,
  organic = true,
  SelectableByRectangle = true,
  Sounds = {
    "selected", "dwarves-selected",
    "acknowledge", "dwarves-acknowledge",
    "ready", "dwarves-ready",
    "help", "basic human voices help 1",
    "dead", "explosion",
    "attack", "dwarves-attack"} } )

DefineUnitType("unit-ranger", { Name = "Ranger",
  Use = "unit-archer",
  Size = {72, 72},
  Animations = "animations-archer", Icon = "icon-ranger",
  Costs = {"time", 70, "gold", 500, "wood", 50},
  Speed = 10,
  HitPoints = 50,
  DrawLevel = 40,
  TileSize = {1, 1}, BoxSize = {33, 33},
  SightRange = 6, ComputerReactionRange = 9, PersonReactionRange = 6,
  BasicDamage = 3, PiercingDamage = 6, Missile = "missile-arrow",
  MaxAttackRange = 4,
  Priority = 57,
  Points = 70,
  Demand = 1,
  Corpse = {"unit-dead-body", 6},
  Type = "land",
  RightMouseAction = "attack",
  CanAttack = true,
  CanTargetLand = true, CanTargetSea = true, CanTargetAir = true,
  LandUnit = true,
  organic = true,
  SelectableByRectangle = true,
  Sounds = {
    "selected", "ranger-selected",
    "acknowledge", "ranger-acknowledge",
    "ready", "ranger-ready",
    "help", "basic human voices help 1",
    "dead", "basic human voices dead",
    "attack", "ranger-attack"} } )

DefineUnitType("unit-female-hero", { Name = "Alleria",
  Use = "unit-archer",
  Size = {72, 72},
  Animations = "animations-archer", Icon = "icon-female-hero",
  Costs = {"time", 70, "gold", 500, "wood", 50},
  Speed = 10,
  HitPoints = 120,
  DrawLevel = 40,
  TileSize = {1, 1}, BoxSize = {33, 33},
  SightRange = 9, ComputerReactionRange = 7, PersonReactionRange = 5,
  Armor = 5, BasicDamage = 10, PiercingDamage = 18, Missile = "missile-arrow",
  MaxAttackRange = 7,
  Priority = 55,
  Points = 60,
  Demand = 1,
  Corpse = {"unit-dead-body", 6},
  Type = "land",
  RightMouseAction = "attack",
  CanAttack = true,
  CanTargetLand = true, CanTargetSea = true, CanTargetAir = true,
  LandUnit = true,
  organic = true,
  SelectableByRectangle = true,
  Sounds = {
    "selected", "alleria-selected",
    "acknowledge", "alleria-acknowledge",
    "ready", "alleria-ready",
    "help", "basic human voices help 1",
    "dead", "basic human voices dead",
    "attack", "alleria-attack"} } )

DefineUnitType("unit-flying-angle", { Name = "Kurdan and Sky'ree",
  Files = {"tileset-summer", "human/units/gryphon_rider.png"},
  Size = {80, 80},
  DrawLevel = 45,
  Animations = "animations-kurdan-and-sky-ree", Icon = "icon-flying-angle",
  Costs = {"time", 250, "gold", 2500},
  Speed = 14,
  HitPoints = 250,
  DrawLevel = 60,
  TileSize = {1, 1}, BoxSize = {63, 63},
  SightRange = 9, ComputerReactionRange = 8, PersonReactionRange = 6,
  Armor = 6, BasicDamage = 0, PiercingDamage = 25, Missile = "missile-griffon-hammer",
  MaxAttackRange = 5,
  Priority = 65,
  Points = 150,
  Demand = 1,
  Type = "fly",
  RightMouseAction = "attack",
  CanAttack = true,
  CanTargetLand = true, CanTargetSea = true, CanTargetAir = true,
  AirUnit = true,
  DetectCloak = true,
  organic = true,
  SelectableByRectangle = true,
  Sounds = {
    "selected", "kurdan-and-sky-ree-selected",
    "acknowledge", "kurdan-and-sky-ree-acknowledge",
    "ready", "kurdan-and-sky-ree-ready",
    "help", "basic human voices help 1",
    "dead", "basic human voices dead",
    "attack", "kurdan-and-sky-ree-attack"} } )

DefineUnitType("unit-white-mage", { Name = "Khadgar",
  Use = "unit-mage",
  Size = {72, 72},
  Animations = "animations-mage", Icon = "icon-white-mage",
  Costs = {"time", 120, "gold", 1200},
  Speed = 8,
  HitPoints = 120,
  DrawLevel = 40,
  MaxMana = 255,
  TileSize = {1, 1}, BoxSize = {33, 33},
  SightRange = 9, ComputerReactionRange = 11, PersonReactionRange = 9,
  Armor = 3, BasicDamage = 0, PiercingDamage = 16, Missile = "missile-lightning",
  MaxAttackRange = 6,
  Priority = 70,
  Points = 100,
  Demand = 1,
  Type = "land",
  RightMouseAction = "attack",
  CanAttack = true,
  CanTargetLand = true, CanTargetSea = true, CanTargetAir = true,
  CanCastSpell = {
      "spell-fireball",
      "spell-slow",
      "spell-flame-shield",
      "spell-invisibility",
      "spell-polymorph",
      "spell-blizzard"},
  LandUnit = true,
  Coward = true,
  organic = true,
  SelectableByRectangle = true,
  Sounds = {
    "selected", "khadgar-selected",
    "acknowledge", "khadgar-acknowledge",
    "ready", "khadgar-ready",
    "help", "basic human voices help 1",
    "dead", "basic human voices dead",
    "attack", "khadgar-attack"} } )

DefineUnitType("unit-human-oil-tanker", { Name = "Oil tanker",
  Files = {"tileset-summer", "human/units/oil_tanker_empty.png"},
  Size = {72, 72},
  Animations = "animations-human-oil-tanker", Icon = "icon-human-oil-tanker",
  Costs = {"time", 50, "gold", 400, "wood", 200},
  Speed = 10,
  HitPoints = 90,
  DrawLevel = 40,
  TileSize = {1, 1}, BoxSize = {63, 63},
  SightRange = 4,
  Armor = 10, BasicDamage = 0, PiercingDamage = 0, Missile = "missile-none",
  MaxAttackRange = 1,
  Priority = 50, AnnoyComputerFactor = 10,
  Points = 40,
  Demand = 1,
  Corpse = {"unit-dead-body", 12},
  Type = "naval",
  RightMouseAction = "harvest",
  SeaUnit = true, Coward = true,
  CanGatherResources = {
   {"file-when-empty", "human/units/oil_tanker_empty.png",
    "file-when-loaded", "human/units/oil_tanker_full.png",
    "resource-id", "oil",
    "resource-capacity", 100,
    "wait-at-resource", 100,
    "wait-at-depot", 100}},
  SelectableByRectangle = true,
  Sounds = {
    "selected", "human-oil-tanker-selected",
    "acknowledge", "human-oil-tanker-acknowledge",
    "ready", "human-oil-tanker-ready",
    "help", "basic human voices help 1",
    "dead", "ship sinking",
    "attack", "human-oil-tanker-attack"} } )

DefineUnitType("unit-human-transport", { Name = "Transport",
  Files = {"tileset-summer", "human/units/transport.png"},
  Size = {72, 72},
  Animations = "animations-human-transport", Icon = "icon-human-transport",
  Costs = {"time", 70, "gold", 600, "wood", 200, "oil", 500},
  RepairHp = 4,
  RepairCosts = {"gold", 1, "wood", 1, "oil", 1},
  Speed = 10,
  HitPoints = 150,
  DrawLevel = 40,
  MaxOnBoard = 6,
  TileSize = {1, 1}, BoxSize = {63, 63},
  SightRange = 4,
  BasicDamage = 0, PiercingDamage = 0, Missile = "missile-none",
  MaxAttackRange = 1,
  Priority = 70, AnnoyComputerFactor = 15,
  Points = 50,
  Demand = 1,
  Corpse = {"unit-dead-body", 12},
  Type = "naval",
  RightMouseAction = "sail",
  SeaUnit = true,
  Transporter = true,
  SelectableByRectangle = true,
  Sounds = {
    "selected", "human-transport-selected",
    "acknowledge", "human-transport-acknowledge",
    "ready", "human-transport-ready",
    "help", "basic human voices help 1",
    "dead", "ship sinking",
    "attack", "human-transport-attack"} } )

DefineUnitType("unit-human-destroyer", { Name = "Elven Destroyer",
  Files = {"tileset-summer", "human/units/elven_destroyer.png"},
  Size = {80, 88},
  Animations = "animations-elven-destroyer", Icon = "icon-human-destroyer",
  Costs = {"time", 90, "gold", 700, "wood", 350, "oil", 700},
  Speed = 10,
  HitPoints = 100,
  DrawLevel = 40,
  TileSize = {1, 1}, BoxSize = {63, 63},
  SightRange = 8, ComputerReactionRange = 10, PersonReactionRange = 8,
  Armor = 10, BasicDamage = 35, PiercingDamage = 0, Missile = "missile-small-cannon",
  MaxAttackRange = 4,
  Priority = 65, AnnoyComputerFactor = 20,
  Points = 150,
  Demand = 1,
  Corpse = {"unit-dead-body", 12},
  Type = "naval",
  RightMouseAction = "attack",
  CanAttack = true,
  CanTargetLand = true, CanTargetSea = true, CanTargetAir = true,
  SeaUnit = true,
  SelectableByRectangle = true,
  Sounds = {
    "selected", "elven-destroyer-selected",
    "acknowledge", "elven-destroyer-acknowledge",
    "ready", "elven-destroyer-ready",
    "help", "basic human voices help 1",
    "dead", "ship sinking",
    "attack", "elven-destroyer-attack"} } )

DefineUnitType("unit-battleship", { Name = "Battleship",
  Files = {"tileset-summer", "human/units/battleship.png"},
  Size = {88, 88},
  Animations = "animations-battleship", Icon = "icon-battleship",
  Costs = {"time", 140, "gold", 1000, "wood", 500, "oil", 1000},
  Speed = 6,
  HitPoints = 150,
  DrawLevel = 40,
  TileSize = {1, 1}, BoxSize = {70, 70},
  SightRange = 8, ComputerReactionRange = 10, PersonReactionRange = 8,
  Armor = 15, BasicDamage = 130, PiercingDamage = 0, Missile = "missile-big-cannon",
  MaxAttackRange = 6,
  Priority = 63, AnnoyComputerFactor = 25,
  Points = 300,
  Demand = 1,
  Corpse = {"unit-dead-body", 12},
  Type = "naval",
  RightMouseAction = "attack",
  CanGroundAttack = true,
  CanAttack = true,
  CanTargetLand = true, CanTargetSea = true,
  SeaUnit = true,
  SelectableByRectangle = true,
  Sounds = {
    "selected", "battleship-selected",
    "acknowledge", "battleship-acknowledge",
    "ready", "battleship-ready",
    "help", "basic human voices help 1",
    "dead", "ship sinking",
    "attack", "battleship-attack"} } )

DefineUnitType("unit-human-submarine", { Name = "Gnomish Submarine",
  Files = {"tileset-summer", "human/units/gnomish_submarine.png",
    "tileset-wasteland", "tilesets/wasteland/human/units/gnomish_submarine.png",
    "tileset-swamp", "tilesets/swamp/human/units/gnomish_submarine.png"},
  Size = {72, 72},
  Animations = "animations-gnomish-submarine", Icon = "icon-gnomish-submarine",
  Costs = {"time", 100, "gold", 800, "wood", 150, "oil", 900},
  Speed = 7,
  HitPoints = 60,
  DrawLevel = 35,
  TileSize = {1, 1}, BoxSize = {63, 63},
  SightRange = 5, ComputerReactionRange = 7, PersonReactionRange = 5,
  BasicDamage = 50, PiercingDamage = 0, Missile = "missile-submarine-missile",
  MaxAttackRange = 4,
  Priority = 60, AnnoyComputerFactor = 20,
  Points = 120,
  Demand = 1,
  Corpse = {"unit-dead-body", 12},
  Type = "naval",
  RightMouseAction = "attack",
  CanAttack = true,
  CanTargetSea = true,
  SeaUnit = true,
  PermanentCloak = true,
  DetectCloak = true,
  SelectableByRectangle = true,
  Sounds = {
    "selected", "gnomish-submarine-selected",
    "acknowledge", "gnomish-submarine-acknowledge",
    "ready", "gnomish-submarine-ready",
    "help", "basic human voices help 1",
    "dead", "ship sinking",
    "attack", "gnomish-submarine-attack"} } )

DefineUnitType("unit-balloon", { Name = "Gnomish Flying Machine",
  Files = {"tileset-summer", "human/units/gnomish_flying_machine.png"},
  Size = {80, 80},
  Animations = "animations-gnomish-flying-machine", Icon = "icon-gnomish-flying-machine",
  Costs = {"time", 65, "gold", 500, "wood", 100},
  Speed = 17,
  HitPoints = 150,
  DrawLevel = 60,
  TileSize = {1, 1}, BoxSize = {63, 63},
  SightRange = 9, ComputerReactionRange = 19, PersonReactionRange = 15,
  Armor = 2, BasicDamage = 0, PiercingDamage = 0, Missile = "missile-none",
  MaxAttackRange = 1,
  Priority = 40,
  Points = 40,
  Demand = 1,
  Type = "fly",
  RightMouseAction = "move",
  AirUnit = true, Coward = true,
  DetectCloak = true,
  SelectableByRectangle = true,
  Sounds = {
    "selected", "gnomish-flying-machine-selected",
    "acknowledge", "gnomish-flying-machine-acknowledge",
    "ready", "gnomish-flying-machine-ready",
    "help", "basic human voices help 1",
    "dead", "explosion",
    "attack", "gnomish-flying-machine-attack"} } )

DefineUnitType("unit-gryphon-rider", { Name = "Gryphon Rider",
  Use = "unit-flying-angle",
  Size = {80, 80},
  DrawLevel = 45,
  Animations = "animations-kurdan-and-sky-ree", Icon = "icon-gryphon-rider",
  Costs = {"time", 250, "gold", 2500},
  Speed = 14,
  HitPoints = 100,
  DrawLevel = 60,
  TileSize = {1, 1}, BoxSize = {63, 63},
  SightRange = 6, ComputerReactionRange = 8, PersonReactionRange = 6,
  Armor = 5, BasicDamage = 0, PiercingDamage = 16, Missile = "missile-griffon-hammer",
  MaxAttackRange = 4,
  Priority = 65,
  Points = 150,
  Demand = 1,
  Type = "fly",
  RightMouseAction = "attack",
  CanAttack = true,
  CanTargetLand = true, CanTargetSea = true, CanTargetAir = true,
  AirUnit = true,
  DetectCloak = true,
  organic = true,
  SelectableByRectangle = true,
  Sounds = {
    "selected", "gryphon-rider-selected",
    "acknowledge", "gryphon-rider-acknowledge",
    "ready", "gryphon-rider-ready",
    "help", "basic human voices help 1",
    "dead", "basic human voices dead",
    "attack", "gryphon-rider-attack"} } )

DefineUnitType("unit-knight-rider", { Name = "Turalyon",
  Use = "unit-knight",
  Size = {72, 72},
  Animations = "animations-knight", Icon = "icon-knight-rider",
  Costs = {"time", 90, "gold", 800, "wood", 100},
  Speed = 13,
  HitPoints = 180,
  DrawLevel = 40,
  MaxMana = 255,
  TileSize = {1, 1}, BoxSize = {42, 42},
  SightRange = 6, ComputerReactionRange = 7, PersonReactionRange = 5,
  Armor = 10, BasicDamage = 14, PiercingDamage = 5, Missile = "missile-none",
  MaxAttackRange = 1,
  Priority = 65,
  Points = 110,
  Demand = 1,
  Corpse = {"unit-dead-body", 6},
  Type = "land",
  RightMouseAction = "attack",
  CanAttack = true,
  CanTargetLand = true,
  CanCastSpell = {"spell-holy-vision", "spell-healing", "spell-exorcism"},
  LandUnit = true,
  organic = true,
  SelectableByRectangle = true,
  Sounds = {
    "selected", "turalyon-selected",
    "acknowledge", "turalyon-acknowledge",
    "ready", "turalyon-ready",
    "help", "basic human voices help 1",
    "dead", "basic human voices dead",
    "attack", "turalyon-attack"} } )

DefineUnitType("unit-arthor-literios", { Name = "Danath",
  Use = "unit-footman",
  Size = {72, 72},
  Animations = "animations-footman", Icon = "icon-ugly-guy",
  Costs = {"time", 60, "gold", 600},
  Speed = 10,
  HitPoints = 220,
  DrawLevel = 40,
  TileSize = {1, 1}, BoxSize = {31, 31},
  SightRange = 6, ComputerReactionRange = 6, PersonReactionRange = 4,
  Armor = 8, BasicDamage = 15, PiercingDamage = 8, Missile = "missile-none",
  MaxAttackRange = 1,
  Priority = 60,
  Points = 50,
  Demand = 1,
  Corpse = {"unit-dead-body", 6},
  Type = "land",
  RightMouseAction = "attack",
  CanAttack = true,
  CanTargetLand = true,
  LandUnit = true,
  organic = true,
  SelectableByRectangle = true,
  Sounds = {
    "selected", "danath-selected",
    "acknowledge", "danath-acknowledge",
    "ready", "danath-ready",
    "help", "basic human voices help 1",
    "dead", "basic human voices dead",
    "attack", "danath-attack"} } )

DefineUnitType("unit-wise-man", { Name = "Lothar",
  Use = "unit-knight",
  Size = {72, 72},
  Animations = "animations-knight", Icon = "icon-wise-man",
  Costs = {"time", 100, "gold", 900, "wood", 100},
  Speed = 13,
  HitPoints = 90,
  DrawLevel = 40,
  MaxMana = 255,
  TileSize = {1, 1}, BoxSize = {42, 42},
  SightRange = 5, ComputerReactionRange = 7, PersonReactionRange = 5,
  Armor = 4, BasicDamage = 8, PiercingDamage = 4, Missile = "missile-none",
  MaxAttackRange = 1,
  Priority = 65,
  Points = 120,
  Demand = 1,
  Corpse = {"unit-dead-body", 6},
  Type = "land",
  RightMouseAction = "attack",
  CanAttack = true,
  CanTargetLand = true,
  LandUnit = true,
  CanCastSpell = {"spell-holy-vision", "spell-healing", "spell-exorcism"},
  hero = true,
  organic = true,
  SelectableByRectangle = true,
  Sounds = {
    "selected", "lothar-selected",
    "acknowledge", "lothar-acknowledge",
    "ready", "lothar-ready",
    "help", "basic human voices help 1",
    "dead", "basic human voices dead",
    "attack", "lothar-attack"} } )

DefineUnitType("unit-man-of-light", { Name = "Uther Lightbringer",
  Use = "unit-knight",
  Size = {72, 72},
  Animations = "animations-knight", Icon = "icon-man-of-light",
  Costs = {"time", 100, "gold", 900, "wood", 100},
  Speed = 13,
  HitPoints = 90,
  DrawLevel = 40,
  MaxMana = 255,
  TileSize = {1, 1}, BoxSize = {42, 42},
  SightRange = 5, ComputerReactionRange = 7, PersonReactionRange = 5,
  Armor = 4, BasicDamage = 8, PiercingDamage = 4, Missile = "missile-none",
  MaxAttackRange = 1,
  Priority = 65,
  Points = 120,
  Demand = 1,
  Corpse = {"unit-dead-body", 6},
  Type = "land",
  RightMouseAction = "attack",
  CanAttack = true,
  CanTargetLand = true,
  CanCastSpell = {"spell-holy-vision", "spell-healing", "spell-exorcism"},
  LandUnit = true,
  hero = true,
  organic = true,
  SelectableByRectangle = true,
  Sounds = {
    "selected", "uther-lightbringer-selected",
    "acknowledge", "uther-lightbringer-acknowledge",
    "ready", "uther-lightbringer-ready",
    "help", "basic human voices help 1",
    "dead", "basic human voices dead",
    "attack", "uther-lightbringer-attack"} } )

DefineUnitType("unit-farm", { Name = "Farm",
  Files = {"tileset-summer", "tilesets/summer/human/buildings/farm.png",
    "tileset-winter", "tilesets/winter/human/buildings/farm.png",
    "tileset-wasteland", "tilesets/wasteland/human/buildings/farm.png",
    "tileset-swamp", "tilesets/swamp/human/buildings/farm.png"},
  Size = {64, 64},
  Animations = "animations-building", Icon = "icon-farm",
  Costs = {"time", 100, "gold", 500, "wood", 250},
  RepairHp = 4,
  RepairCosts = {"gold", 1, "wood", 1},
  Construction = "construction-land",
  Speed = 0,
  HitPoints = 400,
  DrawLevel = 20,
  TileSize = {2, 2}, BoxSize = {63, 63},
  SightRange = 1,
  Armor = 20, BasicDamage = 0, PiercingDamage = 0, Missile = "missile-none",
  Priority = 20, AnnoyComputerFactor = 45,
  Points = 100,
  Supply = 4,
  Corpse = {"unit-destroyed-2x2-place", 0},
  ExplodeWhenKilled = "missile-explosion",
  Type = "land",
  Building = true, VisibleUnderFog = true, 
  Sounds = {
    "selected", "farm-selected",
    "acknowledge", "farm-acknowledge",
    "ready", "farm-ready",
    "help", "basic human voices help 2",
    "dead", "building destroyed",
    "attack", "farm-attack"} } )

DefineUnitType("unit-human-barracks", { Name = "Barracks",
  Files = {"tileset-summer", "tilesets/summer/human/buildings/barracks.png",
    "tileset-winter", "tilesets/winter/human/buildings/barracks.png",
    "tileset-swamp", "tilesets/swamp/human/buildings/barracks.png"},
  Size = {96, 96},
  Animations = "animations-building", Icon = "icon-human-barracks",
  Costs = {"time", 200, "gold", 700, "wood", 450},
  RepairHp = 4,
  RepairCosts = {"gold", 1, "wood", 1},
  Construction = "construction-land",
  Speed = 0,
  HitPoints = 800,
  DrawLevel = 20,
  TileSize = {3, 3}, BoxSize = {95, 95},
  SightRange = 1,
  Armor = 20, BasicDamage = 0, PiercingDamage = 0, Missile = "missile-none",
  Priority = 30, AnnoyComputerFactor = 35,
  Points = 160,
  Corpse = {"unit-destroyed-3x3-place", 0},
  ExplodeWhenKilled = "missile-explosion",
  Type = "land",
  Building = true, VisibleUnderFog = true, 
  Sounds = {
    "selected", "human-barracks-selected",
    "acknowledge", "human-barracks-acknowledge",
    "ready", "human-barracks-ready",
    "help", "basic human voices help 2",
    "dead", "building destroyed",
    "attack", "human-barracks-attack"} } )

DefineUnitType("unit-church", { Name = "Church",
  Files = {"tileset-summer", "tilesets/summer/human/buildings/church.png",
    "tileset-winter", "tilesets/winter/human/buildings/church.png",
    "tileset-swamp", "tilesets/swamp/human/buildings/church.png"},
  Size = {96, 96},
  Animations = "animations-building", Icon = "icon-church",
  Costs = {"time", 175, "gold", 900, "wood", 500},
  RepairHp = 4,
  RepairCosts = {"gold", 1, "wood", 1},
  Construction = "construction-land",
  Speed = 0,
  HitPoints = 700,
  DrawLevel = 20,
  TileSize = {3, 3}, BoxSize = {95, 95},
  SightRange = 1,
  Armor = 20, BasicDamage = 0, PiercingDamage = 0, Missile = "missile-none",
  Priority = 15, AnnoyComputerFactor = 35,
  Points = 240,
  Corpse = {"unit-destroyed-3x3-place", 0},
  ExplodeWhenKilled = "missile-explosion",
  Type = "land",
  Building = true, VisibleUnderFog = true, 
  Sounds = {
    "selected", "church-selected",
    "acknowledge", "church-acknowledge",
    "ready", "church-ready",
    "help", "basic human voices help 2",
    "dead", "building destroyed",
    "attack", "church-attack"} } )

DefineUnitType("unit-human-watch-tower", { Name = "Scout Tower",
  Files = {"tileset-summer", "tilesets/summer/human/buildings/scout_tower.png",
    "tileset-winter", "tilesets/winter/human/buildings/scout_tower.png",
    "tileset-swamp", "tilesets/swamp/human/buildings/scout_tower.png"},
  Size = {64, 64},
  Animations = "animations-building", Icon = "icon-human-watch-tower",
  Costs = {"time", 60, "gold", 550, "wood", 200},
  RepairHp = 4,
  RepairCosts = {"gold", 1, "wood", 1},
  Construction = "construction-land",
  Speed = 0,
  HitPoints = 100,
  DrawLevel = 20,
  TileSize = {2, 2}, BoxSize = {63, 63},
  SightRange = 9,
  Armor = 20, BasicDamage = 0, PiercingDamage = 0, Missile = "missile-none",
  Priority = 55, AnnoyComputerFactor = 50,
  Points = 95,
  Corpse = {"unit-destroyed-2x2-place", 0},
  ExplodeWhenKilled = "missile-explosion",
  Type = "land",
  CanTargetLand = true, CanTargetSea = true, CanTargetAir = true,
  Building = true, VisibleUnderFog = true, 
  DetectCloak = true,
  Sounds = {
    "selected", "human-watch-tower-selected",
    "acknowledge", "human-watch-tower-acknowledge",
    "ready", "human-watch-tower-ready",
    "help", "basic human voices help 2",
    "dead", "building destroyed",
    "attack", "human-watch-tower-attack"} } )

DefineUnitType("unit-stables", { Name = "Stables",
  Files = {"tileset-summer", "tilesets/summer/human/buildings/stables.png",
    "tileset-winter", "tilesets/winter/human/buildings/stables.png",
    "tileset-swamp", "tilesets/swamp/human/buildings/stables.png"},
  Size = {96, 96},
  Animations = "animations-building", Icon = "icon-stables",
  Costs = {"time", 150, "gold", 1000, "wood", 300},
  RepairHp = 4,
  RepairCosts = {"gold", 1, "wood", 1},
  Construction = "construction-land",
  Speed = 0,
  HitPoints = 500,
  DrawLevel = 20,
  TileSize = {3, 3}, BoxSize = {95, 95},
  SightRange = 1,
  Armor = 20, BasicDamage = 0, PiercingDamage = 0, Missile = "missile-none",
  Priority = 15, AnnoyComputerFactor = 15,
  Points = 210,
  Corpse = {"unit-destroyed-3x3-place", 0},
  ExplodeWhenKilled = "missile-explosion",
  Type = "land",
  Building = true, VisibleUnderFog = true, 
  Sounds = {
    "selected", "stables-selected",
    "acknowledge", "stables-acknowledge",
    "ready", "stables-ready",
    "help", "basic human voices help 2",
    "dead", "building destroyed",
    "attack", "stables-attack"} } )

DefineUnitType("unit-inventor", { Name = "Gnomish Inventor",
  Files = {"tileset-summer", "tilesets/summer/human/buildings/gnomish_inventor.png",
    "tileset-winter", "tilesets/winter/human/buildings/gnomish_inventor.png",
    "tileset-swamp", "tilesets/swamp/human/buildings/gnomish_inventor.png"},
  Size = {96, 96},
  Animations = "animations-building", Icon = "icon-gnomish-inventor",
  Costs = {"time", 150, "gold", 1000, "wood", 400},
  RepairHp = 4,
  RepairCosts = {"gold", 1, "wood", 1},
  Construction = "construction-land",
  Speed = 0,
  HitPoints = 500,
  DrawLevel = 20,
  TileSize = {3, 3}, BoxSize = {95, 95},
  SightRange = 1,
  Armor = 20, BasicDamage = 0, PiercingDamage = 0, Missile = "missile-none",
  Priority = 15, AnnoyComputerFactor = 20,
  Points = 230,
  Corpse = {"unit-destroyed-3x3-place", 0},
  ExplodeWhenKilled = "missile-explosion",
  Type = "land",
  Building = true, VisibleUnderFog = true, 
  Sounds = {
    "selected", "gnomish-inventor-selected",
    "acknowledge", "gnomish-inventor-acknowledge",
    "ready", "gnomish-inventor-ready",
    "help", "basic human voices help 2",
    "dead", "building destroyed",
    "attack", "gnomish-inventor-attack"} } )

DefineUnitType("unit-gryphon-aviary", { Name = "Gryphon Aviary",
  Files = {"tileset-summer", "tilesets/summer/human/buildings/gryphon_aviary.png",
    "tileset-winter", "tilesets/winter/human/buildings/gryphon_aviary.png",
    "tileset-swamp", "tilesets/swamp/human/buildings/gryphon_aviary.png"},
  Size = {96, 96},
  Animations = "animations-building", Icon = "icon-gryphon-aviary",
  Costs = {"time", 150, "gold", 1000, "wood", 400},
  RepairHp = 4,
  RepairCosts = {"gold", 1, "wood", 1},
  Construction = "construction-land",
  Speed = 0,
  HitPoints = 500,
  DrawLevel = 20,
  TileSize = {3, 3}, BoxSize = {95, 95},
  SightRange = 1,
  Armor = 20, BasicDamage = 0, PiercingDamage = 0, Missile = "missile-none",
  Priority = 15, AnnoyComputerFactor = 20,
  Points = 280,
  Corpse = {"unit-destroyed-3x3-place", 0},
  ExplodeWhenKilled = "missile-explosion",
  Type = "land",
  Building = true, VisibleUnderFog = true, 
  Sounds = {
    "selected", "gryphon-aviary-selected",
    "acknowledge", "gryphon-aviary-acknowledge",
    "ready", "gryphon-aviary-ready",
    "help", "basic human voices help 2",
    "dead", "building destroyed",
    "attack", "gryphon-aviary-attack"} } )

DefineUnitType("unit-human-shipyard", { Name = "Shipyard",
  Files = {"tileset-summer", "tilesets/summer/human/buildings/shipyard.png",
    "tileset-winter", "tilesets/winter/human/buildings/shipyard.png",
    "tileset-swamp", "tilesets/swamp/human/buildings/shipyard.png"},
  Size = {96, 96},
  Animations = "animations-building", Icon = "icon-human-shipyard",
  Costs = {"time", 200, "gold", 800, "wood", 450},
  RepairHp = 4,
  RepairCosts = {"gold", 1, "wood", 1},
  Construction = "construction-human-shipyard",
  Speed = 0,
  HitPoints = 1100,
  DrawLevel = 20,
  TileSize = {3, 3}, BoxSize = {95, 95},
  SightRange = 1,
  Armor = 20, BasicDamage = 0, PiercingDamage = 0, Missile = "missile-none",
  Priority = 30, AnnoyComputerFactor = 20,
  Points = 170,
  Corpse = {"unit-destroyed-3x3-place", 3},
  ExplodeWhenKilled = "missile-explosion",
  Type = "land",
  Building = true, VisibleUnderFog = true, 
  ShoreBuilding = true,
  CanStore = {"oil"},
  Sounds = {
    "selected", "human-shipyard-selected",
    "acknowledge", "human-shipyard-acknowledge",
    "ready", "human-shipyard-ready",
    "help", "basic human voices help 2",
    "dead", "building destroyed",
    "attack", "human-shipyard-attack"} } )

DefineUnitType("unit-elven-lumber-mill", { Name = "Elven Lumber Mill",
  Files = {"tileset-summer", "tilesets/summer/human/buildings/elven_lumber_mill.png",
    "tileset-winter", "tilesets/winter/human/buildings/elven_lumber_mill.png",
    "tileset-wasteland", "tilesets/wasteland/human/buildings/elven_lumber_mill.png",
    "tileset-swamp", "tilesets/swamp/human/buildings/elven_lumber_mill.png"},
  Size = {96, 96},
  Animations = "animations-building", Icon = "icon-elven-lumber-mill",
  Costs = {"time", 150, "gold", 600, "wood", 450},
  RepairHp = 4,
  RepairCosts = {"gold", 1, "wood", 1},
  ImproveProduction = {"wood", 25},
  Construction = "construction-land",
  Speed = 0,
  HitPoints = 600,
  DrawLevel = 20,
  TileSize = {3, 3}, BoxSize = {95, 95},
  SightRange = 1,
  Armor = 20, BasicDamage = 0, PiercingDamage = 0, Missile = "missile-none",
  Priority = 25, AnnoyComputerFactor = 15,
  Points = 150,
  Corpse = {"unit-destroyed-3x3-place", 0},
  ExplodeWhenKilled = "missile-explosion",
  Type = "land",
  Building = true, VisibleUnderFog = true, 
  CanStore = {"wood"},
  Sounds = {
    "selected", "elven-lumber-mill-selected",
    "acknowledge", "elven-lumber-mill-acknowledge",
    "ready", "elven-lumber-mill-ready",
    "help", "basic human voices help 2",
    "dead", "building destroyed",
    "attack", "elven-lumber-mill-attack"} } )

DefineUnitType("unit-human-foundry", { Name = "Foundry",
  Files = {"tileset-summer", "tilesets/summer/human/buildings/foundry.png",
    "tileset-winter", "tilesets/winter/human/buildings/foundry.png",
    "tileset-swamp", "tilesets/swamp/human/buildings/foundry.png"},
  Size = {96, 96},
  Animations = "animations-building", Icon = "icon-human-foundry",
  Costs = {"time", 175, "gold", 700, "wood", 400, "oil", 400},
  RepairHp = 4,
  RepairCosts = {"gold", 1, "wood", 1, "oil", 1},
  Construction = "construction-human-foundry",
  Speed = 0,
  HitPoints = 750,
  DrawLevel = 20,
  TileSize = {3, 3}, BoxSize = {95, 95},
  SightRange = 1,
  Armor = 20, BasicDamage = 0, PiercingDamage = 0, Missile = "missile-none",
  Priority = 15, AnnoyComputerFactor = 20,
  Points = 200,
  Corpse = {"unit-destroyed-3x3-place", 3},
  ExplodeWhenKilled = "missile-explosion",
  Type = "land",
  Building = true, VisibleUnderFog = true, 
  ShoreBuilding = true,
  Sounds = {
    "selected", "human-foundry-selected",
    "acknowledge", "human-foundry-acknowledge",
    "ready", "human-foundry-ready",
    "help", "basic human voices help 2",
    "dead", "building destroyed",
    "attack", "human-foundry-attack"} } )

DefineUnitType("unit-town-hall", { Name = "Town Hall",
  Files = {"tileset-summer", "tilesets/summer/human/buildings/town_hall.png",
    "tileset-winter", "tilesets/winter/human/buildings/town_hall.png",
    "tileset-swamp", "tilesets/swamp/human/buildings/town_hall.png"},
  Size = {128, 128},
  Animations = "animations-building", Icon = "icon-town-hall",
  Costs = {"time", 255, "gold", 1200, "wood", 800},
  RepairHp = 4,
  RepairCosts = {"gold", 1, "wood", 1},
  Construction = "construction-land",
  Speed = 0,
  HitPoints = 1200,
  DrawLevel = 20,
  TileSize = {4, 4}, BoxSize = {126, 126},
  SightRange = 1,
  Armor = 20, BasicDamage = 0, PiercingDamage = 0, Missile = "missile-none",
  Priority = 35, AnnoyComputerFactor = 45,
  Points = 200,
  Supply = 1,
  Corpse = {"unit-destroyed-4x4-place", 0},
  ExplodeWhenKilled = "missile-explosion",
  Type = "land",
  Building = true, VisibleUnderFog = true, 
  CanStore = {"wood", "gold"},
  Sounds = {
    "selected", "town-hall-selected",
    "acknowledge", "town-hall-acknowledge",
    "ready", "town-hall-ready",
    "help", "basic human voices help 2",
    "dead", "building destroyed",
    "attack", "town-hall-attack"} } )

DefineUnitType("unit-mage-tower", { Name = "Mage Tower",
  Files = {"tileset-summer", "tilesets/summer/human/buildings/mage_tower.png",
    "tileset-winter", "tilesets/winter/human/buildings/mage_tower.png",
    "tileset-swamp", "tilesets/swamp/human/buildings/mage_tower.png"},
  Size = {96, 96},
  Animations = "animations-building", Icon = "icon-mage-tower",
  Costs = {"time", 125, "gold", 1000, "wood", 200},
  RepairHp = 4,
  RepairCosts = {"gold", 1, "wood", 1},
  Construction = "construction-land",
  Speed = 0,
  HitPoints = 500,
  DrawLevel = 20,
  TileSize = {3, 3}, BoxSize = {95, 95},
  SightRange = 1,
  Armor = 20, BasicDamage = 0, PiercingDamage = 0, Missile = "missile-none",
  Priority = 35, AnnoyComputerFactor = 20,
  Points = 240,
  Corpse = {"unit-destroyed-3x3-place", 0},
  ExplodeWhenKilled = "missile-explosion",
  Type = "land",
  Building = true, VisibleUnderFog = true, 
  Sounds = {
    "selected", "mage-tower-selected",
    "acknowledge", "mage-tower-acknowledge",
    "ready", "mage-tower-ready",
    "help", "basic human voices help 2",
    "dead", "building destroyed",
    "attack", "mage-tower-attack"} } )

DefineUnitType("unit-human-blacksmith", { Name = "Blacksmith",
  Files = {"tileset-summer", "tilesets/summer/human/buildings/blacksmith.png",
    "tileset-winter", "tilesets/winter/human/buildings/blacksmith.png",
    "tileset-swamp", "tilesets/swamp/human/buildings/blacksmith.png"},
  Size = {96, 96},
  Animations = "animations-building", Icon = "icon-human-blacksmith",
  Costs = {"time", 200, "gold", 800, "wood", 450, "oil", 100},
  RepairHp = 4,
  RepairCosts = {"gold", 1, "wood", 1, "oil", 1},
  Construction = "construction-land",
  Speed = 0,
  HitPoints = 775,
  DrawLevel = 20,
  TileSize = {3, 3}, BoxSize = {95, 95},
  SightRange = 1,
  Armor = 20, BasicDamage = 0, PiercingDamage = 0, Missile = "missile-none",
  Priority = 15, AnnoyComputerFactor = 20,
  Points = 170,
  Corpse = {"unit-destroyed-3x3-place", 0},
  ExplodeWhenKilled = "missile-explosion",
  Type = "land",
  Building = true, VisibleUnderFog = true, 
  Sounds = {
    "selected", "human-blacksmith-selected",
    "acknowledge", "human-blacksmith-acknowledge",
    "ready", "human-blacksmith-ready",
    "help", "basic human voices help 2",
    "dead", "building destroyed",
    "attack", "human-blacksmith-attack"} } )

DefineUnitType("unit-human-refinery", { Name = "Refinery",
  Files = {"tileset-summer", "tilesets/summer/human/buildings/refinery.png",
    "tileset-winter", "tilesets/winter/human/buildings/refinery.png",
    "tileset-swamp", "tilesets/swamp/human/buildings/refinery.png"},
  Size = {96, 96},
  Animations = "animations-building", Icon = "icon-human-refinery",
  Costs = {"time", 225, "gold", 800, "wood", 350, "oil", 200},
  RepairHp = 4,
  RepairCosts = {"gold", 1, "wood", 1, "oil", 1},
  ImproveProduction = {"oil", 25},
  Construction = "construction-human-refinery",
  Speed = 0,
  HitPoints = 600,
  DrawLevel = 20,
  TileSize = {3, 3}, BoxSize = {95, 95},
  SightRange = 1,
  Armor = 20, BasicDamage = 0, PiercingDamage = 0, Missile = "missile-none",
  Priority = 25, AnnoyComputerFactor = 20,
  Points = 200,
  Corpse = {"unit-destroyed-3x3-place", 3},
  ExplodeWhenKilled = "missile-explosion",
  Type = "land",
  Building = true, VisibleUnderFog = true,
  ShoreBuilding = true,
  CanStore = {"oil"},
  Sounds = {
    "selected", "human-refinery-selected",
    "acknowledge", "human-refinery-acknowledge",
    "ready", "human-refinery-ready",
    "help", "basic human voices help 2",
    "dead", "building destroyed",
    "attack", "human-refinery-attack"} } )

DefineUnitType("unit-human-oil-platform", { Name = "Oil Platform",
  Files = {"tileset-summer", "tilesets/summer/human/buildings/oil_platform.png",
    "tileset-winter", "tilesets/winter/human/buildings/oil_platform.png",
    "tileset-wasteland", "tilesets/wasteland/human/buildings/oil_platform.png",
    "tileset-swamp", "tilesets/swamp/human/buildings/oil_platform.png"},
  Size = {96, 96},
  Animations = "animations-building", Icon = "icon-human-oil-platform",
  Costs = {"time", 200, "gold", 700, "wood", 450},
  Construction = "construction-human-oil-well",
  Speed = 0,
  HitPoints = 650,
  DrawLevel = 20,
  TileSize = {3, 3}, BoxSize = {95, 95},
  SightRange = 1,
  Armor = 20, BasicDamage = 0, PiercingDamage = 0, Missile = "missile-none",
  Priority = 20, AnnoyComputerFactor = 20,
  Points = 160,
  Corpse = {"unit-destroyed-3x3-place", 3},
  ExplodeWhenKilled = "missile-explosion",
  Type = "naval",
  Building = true, VisibleUnderFog = true, 
  MustBuildOnTop = "unit-oil-patch",
  GivesResource = "oil", CanHarvest = true,
  Sounds = {
    "selected", "human-oil-platform-selected",
    "acknowledge", "human-oil-platform-acknowledge",
    "ready", "human-oil-platform-ready",
    "help", "basic human voices help 2",
    "dead", "building destroyed",
    "attack", "human-oil-platform-attack"} } )

DefineUnitType("unit-keep", { Name = "Keep",
  Files = {"tileset-summer", "tilesets/summer/human/buildings/keep.png",
    "tileset-winter", "tilesets/winter/human/buildings/keep.png",
    "tileset-swamp", "tilesets/swamp/human/buildings/keep.png"},
  Size = {128, 128},
  Animations = "animations-building", Icon = "icon-keep",
  Costs = {"time", 200, "gold", 2000, "wood", 1000, "oil", 200},
  RepairHp = 4,
  RepairCosts = {"gold", 1, "wood", 1, "oil", 1},
  ImproveProduction = {"gold", 10},
  Construction = "construction-land",
  Speed = 0,
  HitPoints = 1400,
  DrawLevel = 20,
  TileSize = {4, 4}, BoxSize = {127, 127},
  SightRange = 3,
  Armor = 20, BasicDamage = 0, PiercingDamage = 0, Missile = "missile-none",
  Priority = 37, AnnoyComputerFactor = 40,
  Points = 600,
  Supply = 1,
  Corpse = {"unit-destroyed-4x4-place", 0},
  ExplodeWhenKilled = "missile-explosion",
  Type = "land",
  Building = true, VisibleUnderFog = true, 
  CanStore = {"gold", "wood"},
  Sounds = {
    "selected", "keep-selected",
    "acknowledge", "keep-acknowledge",
    "ready", "keep-ready",
    "help", "basic human voices help 2",
    "dead", "building destroyed",
    "attack", "keep-attack"} } )

DefineUnitType("unit-castle", { Name = "Castle",
  Files = {"tileset-summer", "tilesets/summer/human/buildings/castle.png",
    "tileset-winter", "tilesets/winter/human/buildings/castle.png",
    "tileset-swamp", "tilesets/swamp/human/buildings/castle.png"},
  Size = {128, 128},
  Animations = "animations-building", Icon = "icon-castle",
  Costs = {"time", 200, "gold", 2500, "wood", 1200, "oil", 500},
  RepairHp = 4,
  RepairCosts = {"gold", 1, "wood", 1, "oil", 1},
  ImproveProduction = {"gold", 20},
  Construction = "construction-land",
  Speed = 0,
  HitPoints = 1600,
  DrawLevel = 20,
  TileSize = {4, 4}, BoxSize = {127, 127},
  SightRange = 6,
  Armor = 20, BasicDamage = 0, PiercingDamage = 0, Missile = "missile-none",
  Priority = 40, AnnoyComputerFactor = 50,
  Points = 1500,
  Supply = 1,
  Corpse = {"unit-destroyed-4x4-place", 0},
  ExplodeWhenKilled = "missile-explosion",
  Type = "land",
  Building = true, VisibleUnderFog = true, 
  CanStore = {"gold", "wood"},
  Sounds = {
    "selected", "castle-selected",
    "acknowledge", "castle-acknowledge",
    "ready", "castle-ready",
    "help", "basic human voices help 2",
    "dead", "building destroyed",
    "attack", "castle-attack"} } )

DefineUnitType("unit-human-start-location", { Name = "Start Location",
  Files = {"tileset-summer", "human/x_startpoint.png"},
  Size = {32, 32},
  Animations = "animations-building", Icon = "icon-cancel",
  NumDirections = 1,
  Speed = 0,
  HitPoints = 0,
  DrawLevel = 0,
  TileSize = {1, 1}, BoxSize = {31, 31},
  SightRange = 0,
  BasicDamage = 0, PiercingDamage = 0, Missile = "missile-none",
  Priority = 0,
  Demand = 0,
  Type = "land",
  Sounds = {
    "selected", "human-start-location-selected",
    "acknowledge", "human-start-location-acknowledge",
    "ready", "human-start-location-ready",
    "help", "basic human voices help 2",
    "dead", "building destroyed",
    "attack", "human-start-location-attack"} } )

DefineUnitType("unit-human-guard-tower", { Name = "Guard Tower",
  Files = {"tileset-summer", "tilesets/summer/human/buildings/guard_tower.png",
    "tileset-winter", "tilesets/winter/human/buildings/guard_tower.png",
    "tileset-swamp", "tilesets/swamp/human/buildings/guard_tower.png"},
  Size = {64, 64},
  Animations = "animations-human-guard-tower", Icon = "icon-human-guard-tower",
  Costs = {"time", 140, "gold", 500, "wood", 150},
  RepairHp = 4,
  RepairCosts = {"gold", 1, "wood", 1},
  Construction = "construction-land",
  Speed = 0,
  HitPoints = 130,
  DrawLevel = 40,
  TileSize = {2, 2}, BoxSize = {63, 63},
  SightRange = 9, ComputerReactionRange = 6, PersonReactionRange = 6,
  Armor = 20, BasicDamage = 4, PiercingDamage = 12, Missile = "missile-arrow",
  MaxAttackRange = 6,
  Priority = 40, AnnoyComputerFactor = 50,
  Points = 200,
  Corpse = {"unit-destroyed-2x2-place", 0},
  ExplodeWhenKilled = "missile-explosion",
  Type = "land",
  CanAttack = true,
  CanTargetLand = true, CanTargetSea = true, CanTargetAir = true,
  Building = true, VisibleUnderFog = true, 
  DetectCloak = true,
  Sounds = {
    "selected", "human-guard-tower-selected",
    "acknowledge", "human-guard-tower-acknowledge",
    "ready", "human-guard-tower-ready",
    "help", "basic human voices help 2",
    "dead", "building destroyed",
    "attack", "human-guard-tower-attack"} } )

DefineUnitType("unit-human-cannon-tower", { Name = "Cannon Tower",
  Files = {"tileset-summer", "tilesets/summer/human/buildings/cannon_tower.png",
    "tileset-winter", "tilesets/winter/human/buildings/cannon_tower.png",
    "tileset-swamp", "tilesets/swamp/human/buildings/cannon_tower.png"},
  Size = {64, 64},
  Animations = "animations-human-cannon-tower", Icon = "icon-human-cannon-tower",
  Costs = {"time", 190, "gold", 1000, "wood", 300},
  RepairHp = 4,
  RepairCosts = {"gold", 1, "wood", 1},
  Construction = "construction-land",
  Speed = 0,
  HitPoints = 160,
  DrawLevel = 40,
  TileSize = {2, 2}, BoxSize = {63, 63},
  SightRange = 9, ComputerReactionRange = 7, PersonReactionRange = 7,
  Armor = 20, BasicDamage = 50, PiercingDamage = 0, Missile = "missile-small-cannon",
  MinAttackRange = 2, MaxAttackRange = 7,
  Priority = 40, AnnoyComputerFactor = 50,
  Points = 250,
  Corpse = {"unit-destroyed-2x2-place", 0},
  ExplodeWhenKilled = "missile-explosion",
  Type = "land",
  CanAttack = true,
  CanTargetLand = true, CanTargetSea = true,
  Building = true, VisibleUnderFog = true, 
  DetectCloak = true,
  Sounds = {
    "selected", "human-cannon-tower-selected",
    "acknowledge", "human-cannon-tower-acknowledge",
    "ready", "human-cannon-tower-ready",
    "help", "basic human voices help 2",
    "dead", "building destroyed",
    "attack", "human-cannon-tower-attack"} } )

DefineUnitType("unit-human-wall", { Name = "Wall",
  Files = {"tileset-summer", "tilesets/summer/neutral/buildings/wall.png",
    "tileset-winter", "tilesets/winter/neutral/buildings/wall.png",
    "tileset-wasteland", "tilesets/wasteland/neutral/buildings/wall.png"},
  Size = {32, 32},
  Animations = "animations-building", Icon = "icon-human-wall",
  Costs = {"time", 30, "gold", 20, "wood", 10},
  Construction = "construction-wall",
  Speed = 0,
  HitPoints = 40,
  DrawLevel = 39,
  TileSize = {1, 1}, BoxSize = {31, 31},
  SightRange = 1,
  Armor = 20, BasicDamage = 0, PiercingDamage = 0, Missile = "missile-none",
  Priority = 0, AnnoyComputerFactor = 45,
  Points = 1,
  Corpse = {"unit-destroyed-1x1-place", 0},
  ExplodeWhenKilled = "missile-explosion",
  Type = "land",
  Building = true, VisibleUnderFog = true, 
  Sounds = {
    "selected", "human-wall-selected",
    "acknowledge", "human-wall-acknowledge",
    "ready", "human-wall-ready",
    "help", "basic human voices help 2",
    "dead", "building destroyed",
    "attack", "human-wall-attack"} } )


