--       _________ __                 __
--      /   _____//  |_____________ _/  |______     ____  __ __  ______
--      \_____  \\   __\_  __ \__  \\   __\__  \   / ___\|  |  \/  ___/
--      /        \|  |  |  | \// __ \|  |  / __ \_/ /_/  >  |  /\___ \ 
--     /_______  /|__|  |__|  (____  /__| (____  /\___  /|____//____  >
--             \/                  \/          \//_____/            \/ 
--  ______________________                           ______________________
--			  T H E   W A R   B E G I N S
--	   Stratagus - A free fantasy real time strategy game engine
--
--	units.ccl	-	Define the used orc unit-types.
--
--	(c) Copyright 2001,2002 by Lutz Sammer
--
--      This program is free software; you can redistribute it and/or modify
--      it under the terms of the GNU General Public License as published by
--      the Free Software Foundation; either version 2 of the License, or
--      (at your option) any later version.
--  
--      This program is distributed in the hope that it will be useful,
--      but WITHOUT ANY WARRANTY; without even the implied warranty of
--      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--      GNU General Public License for more details.
--  
--      You should have received a copy of the GNU General Public License
--      along with this program; if not, write to the Free Software
--      Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
--
--	$Id: units.lua,v 1.6 2004/02/09 15:54:43 nobody_ Exp $

--=============================================================================
--	Define unit-types.
--
DefineUnitType("unit-grunt", { Name = "Grunt",
  Files = {"tileset-summer", "orc/units/grunt.png"},
  Size = {72, 72},
  Animations = "animations-footman", Icon = "icon-grunt",
  Costs = {"time", 60, "gold", 600},
  Speed = 10,
  HitPoints = 60,
  DrawLevel = 40,
  TileSize = {1, 1}, BoxSize = {31, 31},
  SightRange = 4, ComputerReactionRange = 6, PersonReactionRange = 4,
  Armor = 2, BasicDamage = 6, PiercingDamage = 3, Missile = "missile-none",
  MaxAttackRange = 1,
  Priority = 60,
  Points = 50,
  Demand = 1,
  Corpse = {"unit-dead-body", 0},
  Type = "land",
  RightMouseAction = "attack",
  CanAttack = true,
  CanTargetLand = true,
  LandUnit = true,
  organic = true,
  SelectableByRectangle = true,
  Sounds = {
    "selected", "grunt-selected",
    "acknowledge", "grunt-acknowledge",
    "ready", "grunt-ready",
    "help", "basic orc voices help 1",
    "dead", "basic orc voices dead",
    "attack", "grunt-attack"} } )

DefineUnitType("unit-peon", { Name = "Peon",
  Files = {"tileset-summer", "orc/units/peon.png"},
  Size = {72, 72},
  Animations = "animations-peasant", Icon = "icon-peon",
  Costs = {"time", 45, "gold", 400},
  Speed = 10,
  HitPoints = 30,
  DrawLevel = 40,
  TileSize = {1, 1}, BoxSize = {31, 31},
  SightRange = 4, ComputerReactionRange = 6, PersonReactionRange = 4,
  BasicDamage = 3, PiercingDamage = 2, Missile = "missile-none",
  MaxAttackRange = 1,
  Priority = 50,
  Points = 30,
  Demand = 1,
  Corpse = {"unit-dead-body", 0},
  Type = "land",
  RightMouseAction = "harvest",
  CanAttack = true, RepairRange = 1,
  CanTargetLand = true,
  LandUnit = true,
  Coward = true,
  CanGatherResources = {
   {"file-when-loaded", "orc/units/peon_with_gold.png",
    "resource-id", "gold",
    "resource-capacity", 100,
    "wait-at-resource", 150,
    "wait-at-depot", 150},
   {"file-when-loaded", "orc/units/peon_with_wood.png",
    "resource-id", "wood",
    "resource-capacity", 100,
    "resource-step", 2,
    "wait-at-resource", 24,
    "wait-at-depot", 150,
    "lose-resources",
    "terrain-harvester"}},
  organic = true,
  SelectableByRectangle = true,
  Sounds = {
    "selected", "peon-selected",
    "acknowledge", "peon-acknowledge",
    "ready", "peon-ready",
--    "repair", "peon-attack",
    "harvest", "wood", "tree chopping",
    "help", "basic orc voices help 1",
    "dead", "basic orc voices dead",
    "attack", "peon-attack"} } )

DefineUnitType("unit-catapult", { Name = "Catapult",
  Files = {"tileset-summer", "orc/units/catapult.png"},
  Size = {64, 64},
  Animations = "animations-catapult", Icon = "icon-catapult",
  Costs = {"time", 250, "gold", 900, "wood", 300},
  Speed = 5,
  HitPoints = 110,
  DrawLevel = 40,
  TileSize = {1, 1}, BoxSize = {63, 63},
  SightRange = 9, ComputerReactionRange = 11, PersonReactionRange = 9,
  BasicDamage = 80, PiercingDamage = 0, Missile = "missile-catapult-rock",
  MinAttackRange = 2, MaxAttackRange = 8,
  Priority = 70,
  Points = 100,
  Demand = 1,
  ExplodeWhenKilled = "missile-explosion",
  Type = "land",
  RightMouseAction = "attack",
  CanGroundAttack = true,
  CanAttack = true,
  CanTargetLand = true, CanTargetSea = true,
  SelectableByRectangle = true,
  Sounds = {
    "selected", "catapult-selected",
    "acknowledge", "catapult-acknowledge",
    "ready", "catapult-ready",
    "help", "basic orc voices help 1",
    "dead", "explosion",
    "attack", "catapult-attack"} } )

DefineUnitType("unit-ogre", { Name = "Ogre",
  Files = {"tileset-summer", "orc/units/ogre.png"},
  Size = {72, 72},
  Animations = "animations-ogre", Icon = "icon-ogre",
  Costs = {"time", 90, "gold", 800, "wood", 100},
  Speed = 13,
  HitPoints = 90,
  DrawLevel = 40,
  TileSize = {1, 1}, BoxSize = {42, 42},
  SightRange = 4, ComputerReactionRange = 6, PersonReactionRange = 4,
  Armor = 4, BasicDamage = 8, PiercingDamage = 4, Missile = "missile-none",
  MaxAttackRange = 1,
  Priority = 63,
  Points = 100,
  Demand = 1,
  Corpse = {"unit-dead-body", 0},
  Type = "land",
  RightMouseAction = "attack",
  CanAttack = true,
  CanTargetLand = true,
  LandUnit = true,
  organic = true,
  SelectableByRectangle = true,
  Sounds = {
    "selected", "ogre-selected",
    "acknowledge", "ogre-acknowledge",
    "ready", "ogre-ready",
    "help", "basic orc voices help 1",
    "dead", "basic orc voices dead",
    "attack", "ogre-attack"} } )

DefineUnitType("unit-axethrower", { Name = "Troll Axethrower",
  Files = {"tileset-summer", "orc/units/troll_axethrower.png"},
  Size = {72, 72},
  Animations = "animations-axethrower", Icon = "icon-axethrower",
  Costs = {"time", 70, "gold", 500, "wood", 50},
  Speed = 10,
  HitPoints = 40,
  DrawLevel = 40,
  TileSize = {1, 1}, BoxSize = {36, 36},
  SightRange = 5, ComputerReactionRange = 7, PersonReactionRange = 5,
  BasicDamage = 3, PiercingDamage = 6, Missile = "missile-axe",
  MaxAttackRange = 4,
  Priority = 55,
  Points = 60,
  Demand = 1,
  Corpse = {"unit-dead-body", 0},
  Type = "land",
  RightMouseAction = "attack",
  CanAttack = true,
  CanTargetLand = true, CanTargetSea = true, CanTargetAir = true,
  LandUnit = true,
  organic = true,
  SelectableByRectangle = true,
  Sounds = {
    "selected", "axethrower-selected",
    "acknowledge", "axethrower-acknowledge",
    "ready", "axethrower-ready",
    "help", "basic orc voices help 1",
    "dead", "basic orc voices dead",
    "attack", "axethrower-attack"} } )

DefineUnitType("unit-death-knight", { Name = "Death Knight",
  Files = {"tileset-summer", "orc/units/death_knight.png"},
  Size = {72, 72},
  Animations = "animations-death-knight", Icon = "icon-death-knight",
  Costs = {"time", 120, "gold", 1200},
  Speed = 8,
  HitPoints = 60,
  DrawLevel = 40,
  MaxMana = 255,
  TileSize = {1, 1}, BoxSize = {39, 39},
  SightRange = 9, ComputerReactionRange = 11, PersonReactionRange = 9,
  BasicDamage = 0, PiercingDamage = 9, Missile = "missile-touch-of-death",
  MaxAttackRange = 3,
  Priority = 70,
  Points = 100,
  Demand = 1,
  Type = "land",
  RightMouseAction = "attack",
  CanAttack = true,
  CanTargetLand = true, CanTargetSea = true, CanTargetAir = true,
  CanCastSpell = {
      "spell-death-coil",
      "spell-haste",
      "spell-raise-dead",
      "spell-whirlwind",
      "spell-unholy-armor",
      "spell-death-and-decay"},
  LandUnit = true,
  Coward = true,
  isundead = true,
  organic = true,
  SelectableByRectangle = true,
  Sounds = {
    "selected", "death-knight-selected",
    "acknowledge", "death-knight-acknowledge",
    "ready", "death-knight-ready",
    "help", "basic orc voices help 1",
    "dead", "basic orc voices dead",
    "attack", "death-knight-attack"} } )

DefineUnitType("unit-ogre-mage", { Name = "Ogre Mage",
  Use = "unit-ogre",
  Size = {72, 72},
  Animations = "animations-ogre", Icon = "icon-ogre-mage",
  Costs = {"time", 90, "gold", 800, "wood", 100},
  Speed = 13,
  HitPoints = 90,
  DrawLevel = 40,
  MaxMana = 255,
  TileSize = {1, 1}, BoxSize = {42, 42},
  SightRange = 5, ComputerReactionRange = 7, PersonReactionRange = 5,
  Armor = 4, BasicDamage = 8, PiercingDamage = 4, Missile = "missile-none",
  MaxAttackRange = 1,
  Priority = 65,
  Points = 110,
  Demand = 1,
  Corpse = {"unit-dead-body", 0},
  Type = "land",
  RightMouseAction = "attack",
  CanAttack = true,
  CanTargetLand = true,
  CanCastSpell = {"spell-eye-of-vision", "spell-runes", "spell-bloodlust"},
  LandUnit = true,
  organic = true,
  SelectableByRectangle = true,
  Sounds = {
    "selected", "ogre-mage-selected",
    "acknowledge", "ogre-mage-acknowledge",
    "ready", "ogre-mage-ready",
    "help", "basic orc voices help 1",
    "dead", "basic orc voices dead",
    "attack", "ogre-mage-attack"} } )

DefineUnitType("unit-goblin-sappers", { Name = "Goblin Sappers",
  Files = {"tileset-summer", "orc/units/goblin_sappers.png"},
  Size = {56, 56},
  Animations = "animations-goblin-sappers", Icon = "icon-goblin-sappers",
  Costs = {"time", 200, "gold", 700, "wood", 250},
  Speed = 11,
  HitPoints = 40,
  DrawLevel = 40,
  TileSize = {1, 1}, BoxSize = {37, 37},
  SightRange = 4, ComputerReactionRange = 4, PersonReactionRange = 2,
  BasicDamage = 4, PiercingDamage = 2, Missile = "missile-none",
  MaxAttackRange = 1,
  Priority = 55,
  Points = 100,
  Demand = 1,
  Type = "land",
  RightMouseAction = "spell-cast",
  CanCastSpell = {"spell-suicide-bomber"},
  CanAttack = true,
  CanTargetLand = true,
  LandUnit = true,
  volatile = true,
  organic = true,
  SelectableByRectangle = true,
  Sounds = {
    "selected", "goblin-sappers-selected",
    "acknowledge", "goblin-sappers-acknowledge",
    "ready", "goblin-sappers-ready",
    "help", "basic orc voices help 1",
    "dead", "explosion",
    "attack", "goblin-sappers-attack"} } )

DefineUnitType("unit-berserker", { Name = "Berserker",
  Use = "unit-axethrower",
  Size = {72, 72},
  Animations = "animations-axethrower", Icon = "icon-berserker",
  Costs = {"time", 70, "gold", 500, "wood", 50},
  Speed = 10,
  HitPoints = 50,
  DrawLevel = 40,
  TileSize = {1, 1}, BoxSize = {36, 36},
  SightRange = 6, ComputerReactionRange = 9, PersonReactionRange = 6,
  BasicDamage = 3, PiercingDamage = 6, Missile = "missile-axe",
  MaxAttackRange = 4,
  Priority = 57,
  Points = 70,
  Demand = 1,
  Corpse = {"unit-dead-body", 0},
  Type = "land",
  RightMouseAction = "attack",
  CanAttack = true,
  CanTargetLand = true, CanTargetSea = true, CanTargetAir = true,
  LandUnit = true,
  organic = true,
  SelectableByRectangle = true,
  Sounds = {
    "selected", "berserker-selected",
    "acknowledge", "berserker-acknowledge",
    "ready", "berserker-ready",
    "help", "basic orc voices help 1",
    "dead", "basic orc voices dead",
    "attack", "berserker-attack"} } )

DefineUnitType("unit-evil-knight", { Name = "Teron Gorefiend",
  Use = "unit-death-knight",
  Size = {72, 72},
  Animations = "animations-death-knight", Icon = "icon-evil-knight",
  Costs = {"time", 120, "gold", 1200},
  Speed = 8,
  HitPoints = 180,
  DrawLevel = 40,
  MaxMana = 255,
  TileSize = {1, 1}, BoxSize = {39, 39},
  SightRange = 9, ComputerReactionRange = 11, PersonReactionRange = 9,
  Armor = 2, BasicDamage = 0, PiercingDamage = 16, Missile = "missile-touch-of-death",
  MaxAttackRange = 4,
  Priority = 70,
  Points = 100,
  Demand = 1,
  Corpse = {"unit-dead-body", 0},
  Type = "land",
  RightMouseAction = "attack",
  CanAttack = true,
  CanTargetLand = true, CanTargetSea = true, CanTargetAir = true,
  LandUnit = true,
  Coward = true,
  isundead = true,
  organic = true,
  CanCastSpell = {
      "spell-death-coil",
      "spell-haste",
      "spell-raise-dead",
      "spell-whirlwind",
      "spell-unholy-armor",
      "spell-death-and-decay"},
  SelectableByRectangle = true,
  Sounds = {
    "selected", "teron-gorefiend-selected",
    "acknowledge", "teron-gorefiend-acknowledge",
    "ready", "teron-gorefiend-ready",
    "help", "basic orc voices help 1",
    "dead", "basic orc voices dead",
    "attack", "teron-gorefiend-attack"} } )

DefineUnitType("unit-fad-man", { Name = "Dentarg",
  Use = "unit-ogre",
  Size = {72, 72},
  Animations = "animations-ogre", Icon = "icon-fad-man",
  Costs = {"time", 90, "gold", 800, "wood", 100},
  Speed = 13,
  HitPoints = 300,
  DrawLevel = 40,
  MaxMana = 255,
  TileSize = {1, 1}, BoxSize = {42, 42},
  SightRange = 6, ComputerReactionRange = 6, PersonReactionRange = 4,
  Armor = 8, BasicDamage = 18, PiercingDamage = 6, Missile = "missile-none",
  MaxAttackRange = 1,
  Priority = 63,
  Points = 100,
  Demand = 1,
  Corpse = {"unit-dead-body", 0},
  Type = "land",
  RightMouseAction = "attack",
  CanAttack = true,
  CanTargetLand = true,
  CanCastSpell = {"spell-eye-of-vision", "spell-runes", "spell-bloodlust"},
  LandUnit = true,
  organic = true,
  SelectableByRectangle = true,
  Sounds = {
    "selected", "dentarg-selected",
    "acknowledge", "dentarg-acknowledge",
    "ready", "dentarg-ready",
    "help", "basic orc voices help 1",
    "dead", "basic orc voices dead",
    "attack", "dentarg-attack"} } )

DefineUnitType("unit-beast-cry", { Name = "Grom Hellscream",
  Use = "unit-grunt",
  Size = {72, 72},
  Animations = "animations-footman", Icon = "icon-beast-cry",
  Costs = {"time", 60, "gold", 600},
  Speed = 10,
  HitPoints = 240,
  DrawLevel = 40,
  TileSize = {1, 1}, BoxSize = {31, 31},
  SightRange = 5, ComputerReactionRange = 6, PersonReactionRange = 4,
  Armor = 8, BasicDamage = 16, PiercingDamage = 6, Missile = "missile-none",
  MaxAttackRange = 1,
  Priority = 60,
  Points = 50,
  Demand = 1,
  Corpse = {"unit-dead-body", 6},
  Type = "land",
  RightMouseAction = "attack",
  CanAttack = true,
  CanTargetLand = true,
  LandUnit = true,
  organic = true,
  SelectableByRectangle = true,
  Sounds = {
    "selected", "grom-hellscream-selected",
    "acknowledge", "grom-hellscream-acknowledge",
    "ready", "grom-hellscream-ready",
    "help", "basic orc voices help 1",
    "dead", "basic orc voices dead",
    "attack", "grom-hellscream-attack"} } )

DefineUnitType("unit-orc-oil-tanker", { Name = "Oil tanker",
  Files = {"tileset-summer", "orc/units/oil_tanker_empty.png"},
  Size = {72, 72},
  Animations = "animations-human-oil-tanker", Icon = "icon-orc-oil-tanker",
  Costs = {"time", 50, "gold", 400, "wood", 200},
  Speed = 10,
  HitPoints = 90,
  DrawLevel = 40,
  TileSize = {1, 1}, BoxSize = {63, 63},
  SightRange = 4,
  Armor = 10, BasicDamage = 0, PiercingDamage = 0, Missile = "missile-none",
  MaxAttackRange = 1,
  Priority = 50, AnnoyComputerFactor = 10,
  Points = 40,
  Demand = 1,
  Corpse = {"unit-dead-body", 12},
  Type = "naval",
  RightMouseAction = "harvest",
  SeaUnit = true, Coward = true,
  CanGatherResources = {
   {"file-when-empty", "orc/units/oil_tanker_empty.png",
    "file-when-loaded", "orc/units/oil_tanker_full.png",
    "resource-id", "oil",
    "resource-capacity", 100,
    "wait-at-resource", 100,
    "wait-at-depot", 100 }},
  SelectableByRectangle = true,
  Sounds = {
    "selected", "orc-oil-tanker-selected",
    "acknowledge", "orc-oil-tanker-acknowledge",
    "ready", "orc-oil-tanker-ready",
    "help", "basic orc voices help 1",
    "dead", "ship sinking",
    "attack", "orc-oil-tanker-attack"} } )

DefineUnitType("unit-orc-transport", { Name = "Transport",
  Files = {"tileset-summer", "orc/units/transport.png"},
  Size = {72, 72},
  Animations = "animations-human-transport", Icon = "icon-orc-transport",
  Costs = {"time", 70, "gold", 600, "wood", 200, "oil", 500},
  RepairHp = 4,
  RepairCosts = {"gold", 1, "wood", 1, "oil", 1},
  Speed = 10,
  HitPoints = 150,
  DrawLevel = 40,
  MaxOnBoard = 6,
  TileSize = {1, 1}, BoxSize = {63, 63},
  SightRange = 4,
  BasicDamage = 0, PiercingDamage = 0, Missile = "missile-none",
  MaxAttackRange = 1,
  Priority = 70, AnnoyComputerFactor = 15,
  Points = 50,
  Demand = 1,
  Corpse = {"unit-dead-body", 12},
  Type = "naval",
  RightMouseAction = "sail",
  SeaUnit = true,
  Transporter = true,
  SelectableByRectangle = true,
  Sounds = {
    "selected", "orc-transport-selected",
    "acknowledge", "orc-transport-acknowledge",
    "ready", "orc-transport-ready",
    "help", "basic orc voices help 1",
    "dead", "ship sinking",
    "attack", "orc-transport-attack"} } )

DefineUnitType("unit-orc-destroyer", { Name = "Troll Destroyer",
  Files = {"tileset-summer", "orc/units/troll_destroyer.png"},
  Size = {88, 88},
  Animations = "animations-elven-destroyer", Icon = "icon-orc-destroyer",
  Costs = {"time", 90, "gold", 700, "wood", 350, "oil", 700},
  Speed = 10,
  HitPoints = 100,
  DrawLevel = 40,
  TileSize = {1, 1}, BoxSize = {63, 63},
  SightRange = 8, ComputerReactionRange = 10, PersonReactionRange = 8,
  Armor = 10, BasicDamage = 35, PiercingDamage = 0, Missile = "missile-small-cannon",
  MaxAttackRange = 4,
  Priority = 65, AnnoyComputerFactor = 20,
  Points = 150,
  Demand = 1,
  Corpse = {"unit-dead-body", 12},
  Type = "naval",
  RightMouseAction = "attack",
  CanAttack = true,
  CanTargetLand = true, CanTargetSea = true, CanTargetAir = true,
  SeaUnit = true,
  SelectableByRectangle = true,
  Sounds = {
    "selected", "troll-destroyer-selected",
    "acknowledge", "troll-destroyer-acknowledge",
    "ready", "troll-destroyer-ready",
    "help", "basic orc voices help 1",
    "dead", "ship sinking",
    "attack", "troll-destroyer-attack"} } )

DefineUnitType("unit-ogre-juggernaught", { Name = "Ogre Juggernaught",
  Files = {"tileset-summer", "orc/units/ogre_juggernaught.png"},
  Size = {88, 88},
  Animations = "animations-battleship", Icon = "icon-ogre-juggernaught",
  Costs = {"time", 140, "gold", 1000, "wood", 500, "oil", 1000},
  Speed = 6,
  HitPoints = 150,
  DrawLevel = 40,
  TileSize = {1, 1}, BoxSize = {70, 70},
  SightRange = 8, ComputerReactionRange = 10, PersonReactionRange = 8,
  Armor = 15, BasicDamage = 130, PiercingDamage = 0, Missile = "missile-big-cannon",
  MaxAttackRange = 6,
  Priority = 63, AnnoyComputerFactor = 25,
  Points = 300,
  Demand = 1,
  Corpse = {"unit-dead-body", 12},
  Type = "naval",
  RightMouseAction = "attack",
  CanGroundAttack = true,
  CanAttack = true,
  CanTargetLand = true, CanTargetSea = true,
  SeaUnit = true,
  SelectableByRectangle = true,
  Sounds = {
    "selected", "ogre-juggernaught-selected",
    "acknowledge", "ogre-juggernaught-acknowledge",
    "ready", "ogre-juggernaught-ready",
    "help", "basic orc voices help 1",
    "dead", "ship sinking",
    "attack", "ogre-juggernaught-attack"} } )

DefineUnitType("unit-fire-breeze", { Name = "Deathwing",
  Files = {"tileset-summer", "orc/units/dragon.png"},
  Size = {88, 80},
  Animations = "animations-deathwing", Icon = "icon-fire-breeze",
  Costs = {"time", 250, "gold", 2500},
  Speed = 14,
  HitPoints = 800,
  DrawLevel = 60,
  TileSize = {1, 1}, BoxSize = {71, 71},
  SightRange = 9, ComputerReactionRange = 8, PersonReactionRange = 6,
  Armor = 10, BasicDamage = 10, PiercingDamage = 25, Missile = "missile-dragon-breath",
  MaxAttackRange = 5,
  Priority = 65,
  Points = 150,
  Demand = 1,
  Type = "fly",
  RightMouseAction = "attack",
  CanAttack = true,
  CanTargetLand = true, CanTargetSea = true, CanTargetAir = true,
  AirUnit = true,
  DetectCloak = true,
  organic = true,
  SelectableByRectangle = true,
  Sounds = {
    "selected", "deathwing-selected",
    "acknowledge", "deathwing-acknowledge",
    "ready", "deathwing-ready",
    "help", "basic orc voices help 1",
    "dead", "explosion",
    "attack", "deathwing-attack"} } )

DefineUnitType("unit-orc-submarine", { Name = "Giant Turtle",
  Files = {"tileset-summer", "orc/units/giant_turtle.png",
    "tileset-wasteland", "tilesets/wasteland/orc/units/giant_turtle.png",
    "tileset-swamp", "tilesets/swamp/orc/units/giant_turtle.png"},
  Size = {72, 72},
  Animations = "animations-gnomish-submarine", Icon = "icon-giant-turtle",
  Costs = {"time", 100, "gold", 800, "wood", 150, "oil", 900},
  Speed = 7,
  HitPoints = 60,
  DrawLevel = 30,
  TileSize = {1, 1}, BoxSize = {63, 63},
  SightRange = 5, ComputerReactionRange = 7, PersonReactionRange = 5,
  BasicDamage = 50, PiercingDamage = 0, Missile = "missile-turtle-missile",
  MaxAttackRange = 4,
  Priority = 60, AnnoyComputerFactor = 20,
  Points = 120,
  Demand = 1,
  Corpse = {"unit-dead-body", 12},
  Type = "naval",
  RightMouseAction = "attack",
  CanAttack = true,
  CanTargetSea = true,
  SeaUnit = true,
  PermanentCloak = true,
  DetectCloak = true,
  SelectableByRectangle = true,
  Sounds = {
    "selected", "giant-turtle-selected",
    "acknowledge", "giant-turtle-acknowledge",
    "ready", "giant-turtle-ready",
    "help", "basic orc voices help 1",
    "dead", "ship sinking",
    "attack", "giant-turtle-attack"} } )

DefineUnitType("unit-zeppelin", { Name = "Goblin Zeppelin",
  Files = {"tileset-summer", "orc/units/goblin_zeppelin.png"},
  Size = {72, 72},
  Animations = "animations-goblin-zeppelin", Icon = "icon-zeppelin",
  Costs = {"time", 65, "gold", 500, "wood", 100},
  Speed = 17,
  HitPoints = 150,
  DrawLevel = 60,
  TileSize = {1, 1}, BoxSize = {63, 63},
  SightRange = 9, ComputerReactionRange = 19, PersonReactionRange = 15,
  Armor = 2, BasicDamage = 0, PiercingDamage = 0, Missile = "missile-none",
  MaxAttackRange = 1,
  Priority = 40,
  Points = 40,
  Demand = 1,
  Type = "fly",
  RightMouseAction = "move",
  AirUnit = true, Coward = true,
  DetectCloak = true,
  SelectableByRectangle = true,
  Sounds = {
    "selected", "goblin-zeppelin-selected",
    "acknowledge", "goblin-zeppelin-acknowledge",
    "ready", "goblin-zeppelin-ready",
    "help", "basic orc voices help 1",
    "dead", "explosion",
    "attack", "goblin-zeppelin-attack"} } )

DefineUnitType("unit-dragon", { Name = "Dragon",
  Use = "unit-fire-breeze",
  Size = {88, 80},
  Animations = "animations-deathwing", Icon = "icon-dragon",
  Costs = {"time", 250, "gold", 2500},
  Speed = 14,
  HitPoints = 100,
  DrawLevel = 60,
  TileSize = {1, 1}, BoxSize = {71, 71},
  SightRange = 6, ComputerReactionRange = 8, PersonReactionRange = 6,
  Armor = 5, BasicDamage = 0, PiercingDamage = 16, Missile = "missile-dragon-breath",
  MaxAttackRange = 4,
  Priority = 65,
  Points = 150,
  Demand = 1,
  Type = "fly",
  RightMouseAction = "attack",
  CanAttack = true,
  CanTargetLand = true, CanTargetSea = true, CanTargetAir = true,
  AirUnit = true,
  DetectCloak = true,
  organic = true,
  SelectableByRectangle = true,
  Sounds = {
    "selected", "dragon-selected",
    "acknowledge", "dragon-acknowledge",
    "ready", "dragon-ready",
    "help", "basic orc voices help 1",
    "dead", "explosion",
    "attack", "dragon-attack"} } )

DefineUnitType("unit-eye-of-vision", { Name = "Eye of Kilrogg",
  Files = {"tileset-summer", "orc/units/eye_of_kilrogg.png"},
  Size = {32, 32},
  Animations = "animations-eye-of-vision", Icon = "icon-eye-of-kilrogg",
  Speed = 42,
  HitPoints = 100,
  DrawLevel = 60,
  TileSize = {1, 1}, BoxSize = {31, 31},
  SightRange = 3, ComputerReactionRange = 20, PersonReactionRange = 10,
  BasicDamage = 1, PiercingDamage = 0, Missile = "missile-none",
  MaxAttackRange = 1,
  Priority = 0,
  DecayRate = 3,
  Demand = 1,
  Type = "fly",
  RightMouseAction = "move",
  AirUnit = true,
  DetectCloak = true,
  SelectableByRectangle = true,
  Sounds = {
    "selected", "eye-of-kilrogg-selected",
    "acknowledge", "eye-of-kilrogg-acknowledge",
    "ready", "eye-of-kilrogg-ready",
    "help", "basic orc voices help 1",
    "dead", "eye-of-kilrogg-dead",
    "attack", "eye-of-kilrogg-attack"} } )

DefineUnitType("unit-quick-blade", { Name = "Korgath Bladefist",
  Use = "unit-grunt",
  Size = {72, 72},
  Animations = "animations-footman", Icon = "icon-quick-blade",
  Costs = {"time", 60, "gold", 600},
  Speed = 10,
  HitPoints = 240,
  DrawLevel = 40,
  TileSize = {1, 1}, BoxSize = {31, 31},
  SightRange = 5, ComputerReactionRange = 6, PersonReactionRange = 4,
  Armor = 8, BasicDamage = 16, PiercingDamage = 6, Missile = "missile-none",
  MaxAttackRange = 1,
  Priority = 60,
  Points = 50,
  Demand = 1,
  Corpse = {"unit-dead-body", 6},
  Type = "land",
  RightMouseAction = "attack",
  CanAttack = true,
  CanTargetLand = true,
  LandUnit = true,
  organic = true,
  SelectableByRectangle = true,
  Sounds = {
    "selected", "korgath-bladefist-selected",
    "acknowledge", "korgath-bladefist-acknowledge",
    "ready", "korgath-bladefist-ready",
    "help", "basic orc voices help 1",
    "dead", "basic orc voices dead",
    "attack", "korgath-bladefist-attack"} } )

DefineUnitType("unit-double-head", { Name = "Cho'gall",
  Use = "unit-ogre",
  Size = {72, 72},
  Animations = "animations-ogre", Icon = "icon-double-head",
  Costs = {"time", 100, "gold", 1100, "wood", 50},
  Speed = 13,
  HitPoints = 100,
  DrawLevel = 40,
  MaxMana = 255,
  TileSize = {1, 1}, BoxSize = {42, 42},
  SightRange = 5, ComputerReactionRange = 7, PersonReactionRange = 5,
  BasicDamage = 10, PiercingDamage = 5, Missile = "missile-none",
  MaxAttackRange = 1,
  Priority = 65,
  Points = 120,
  Demand = 1,
  Corpse = {"unit-dead-body", 0},
  Type = "land",
  RightMouseAction = "attack",
  CanAttack = true,
  CanTargetLand = true,
  CanCastSpell = {"spell-eye-of-vision", "spell-runes", "spell-bloodlust"},
  LandUnit = true,
  hero = true,
  organic = true,
  SelectableByRectangle = true,
  Sounds = {
    "selected", "cho-gall-selected",
    "acknowledge", "cho-gall-acknowledge",
    "ready", "cho-gall-ready",
    "help", "basic orc voices help 1",
    "dead", "basic orc voices dead",
    "attack", "cho-gall-attack"} } )

DefineUnitType("unit-ice-bringer", { Name = "Gul'dan",
  Use = "unit-death-knight",
  Size = {72, 72},
  Animations = "animations-death-knight", Icon = "icon-ice-bringer",
  Costs = {"time", 120, "gold", 1200},
  Speed = 8,
  HitPoints = 40,
  DrawLevel = 40,
  MaxMana = 255,
  TileSize = {1, 1}, BoxSize = {33, 33},
  SightRange = 8, ComputerReactionRange = 10, PersonReactionRange = 8,
  BasicDamage = 0, PiercingDamage = 3, Missile = "missile-touch-of-death",
  MaxAttackRange = 3,
  Priority = 70,
  Points = 120,
  Demand = 1,
  Type = "land",
  RightMouseAction = "attack",
  CanAttack = true,
  CanTargetLand = true, CanTargetSea = true, CanTargetAir = true,
  LandUnit = true,
  hero = true,
  CanCastSpell = {
      "spell-death-coil",
      "spell-haste",
      "spell-raise-dead",
      "spell-whirlwind",
      "spell-unholy-armor",
      "spell-death-and-decay"},
  isundead = true,
  organic = true,
  SelectableByRectangle = true,
  Sounds = {
    "selected", "gul-dan-selected",
    "acknowledge", "gul-dan-acknowledge",
    "ready", "gul-dan-ready",
    "help", "basic orc voices help 1",
    "dead", "basic orc voices dead",
    "attack", "gul-dan-attack"} } )

DefineUnitType("unit-sharp-axe", { Name = "Zuljin",
  Use = "unit-axethrower",
  Size = {72, 72},
  Animations = "animations-axethrower", Icon = "icon-sharp-axe",
  Costs = {"time", 70, "gold", 500, "wood", 50},
  Speed = 10,
  HitPoints = 40,
  DrawLevel = 40,
  TileSize = {1, 1}, BoxSize = {36, 36},
  SightRange = 6, ComputerReactionRange = 8, PersonReactionRange = 6,
  BasicDamage = 3, PiercingDamage = 6, Missile = "missile-axe",
  MaxAttackRange = 5,
  Priority = 55,
  Points = 120,
  Demand = 1,
  Corpse = {"unit-dead-body", 0},
  Type = "land",
  RightMouseAction = "attack",
  CanAttack = true,
  CanTargetLand = true, CanTargetSea = true, CanTargetAir = true,
  LandUnit = true,
  hero = true,
  organic = true,
  SelectableByRectangle = true,
  Sounds = {
    "selected", "zuljin-selected",
    "acknowledge", "zuljin-acknowledge",
    "ready", "zuljin-ready",
    "help", "basic orc voices help 1",
    "dead", "basic orc voices dead",
    "attack", "zuljin-attack"} } )

DefineUnitType("unit-skeleton", { Name = "Skeleton",
  Files = {"tileset-summer", "neutral/units/skeleton.png"},
  Size = {56, 56},
  Animations = "animations-skeleton", Icon = "icon-skeleton",
  Speed = 8,
  HitPoints = 40,
  DrawLevel = 40,
  TileSize = {1, 1}, BoxSize = {31, 31},
  SightRange = 3, ComputerReactionRange = 4, PersonReactionRange = 2,
  BasicDamage = 6, PiercingDamage = 3, Missile = "missile-none",
  MaxAttackRange = 1,
  Priority = 55,
  DecayRate = 100,
  Demand = 1,
  Type = "land",
  RightMouseAction = "attack",
  CanAttack = true,
  CanTargetLand = true,
  LandUnit = true,
  isundead = true,
  organic = true,
  SelectableByRectangle = true,
  Sounds = {
    "selected", "skeleton-selected",
    "acknowledge", "skeleton-acknowledge",
    "ready", "skeleton-ready",
    "help", "basic orc voices help 1",
    "dead", "basic orc voices dead",
    "attack", "skeleton-attack"} } )

DefineUnitType("unit-pig-farm", { Name = "Pig Farm",
  Files = {"tileset-summer", "tilesets/summer/orc/buildings/pig_farm.png",
    "tileset-winter", "tilesets/winter/orc/buildings/pig_farm.png",
    "tileset-wasteland", "tilesets/wasteland/orc/buildings/pig_farm.png",
    "tileset-swamp", "tilesets/swamp/orc/buildings/pig_farm.png"},
  Size = {64, 64},
  Animations = "animations-building", Icon = "icon-pig-farm",
  Costs = {"time", 100, "gold", 500, "wood", 250},
  RepairHp = 4,
  RepairCosts = {"gold", 1, "wood", 1},
  Construction = "construction-land",
  Speed = 0,
  HitPoints = 400,
  DrawLevel = 20,
  TileSize = {2, 2}, BoxSize = {63, 63},
  SightRange = 2,
  Armor = 20, BasicDamage = 0, PiercingDamage = 0, Missile = "missile-none",
  Priority = 20, AnnoyComputerFactor = 45,
  Points = 100,
  Supply = 4,
  Corpse = {"unit-destroyed-2x2-place", 0},
  ExplodeWhenKilled = "missile-explosion",
  Type = "land",
  Building = true, VisibleUnderFog = true, 
  Sounds = {
    "selected", "pig-farm-selected",
    "acknowledge", "pig-farm-acknowledge",
    "ready", "pig-farm-ready",
    "help", "basic orc voices help 2",
    "dead", "building destroyed",
    "attack", "pig-farm-attack"} } )

DefineUnitType("unit-orc-barracks", { Name = "Barracks",
  Files = {"tileset-summer", "tilesets/summer/orc/buildings/barracks.png",
    "tileset-winter", "tilesets/winter/orc/buildings/barracks.png",
    "tileset-swamp", "tilesets/swamp/orc/buildings/barracks.png"},
  Size = {96, 96},
  Animations = "animations-building", Icon = "icon-orc-barracks",
  Costs = {"time", 200, "gold", 700, "wood", 450},
  RepairHp = 4,
  RepairCosts = {"gold", 1, "wood", 1},
  Construction = "construction-land",
  Speed = 0,
  HitPoints = 800,
  DrawLevel = 20,
  TileSize = {3, 3}, BoxSize = {95, 95},
  SightRange = 1,
  Armor = 20, BasicDamage = 0, PiercingDamage = 0, Missile = "missile-none",
  Priority = 30, AnnoyComputerFactor = 35,
  Points = 160,
  Corpse = {"unit-destroyed-3x3-place", 0},
  ExplodeWhenKilled = "missile-explosion",
  Type = "land",
  Building = true, VisibleUnderFog = true, 
  Sounds = {
    "selected", "orc-barracks-selected",
    "acknowledge", "orc-barracks-acknowledge",
    "ready", "orc-barracks-ready",
    "help", "basic orc voices help 2",
    "dead", "building destroyed",
    "attack", "orc-barracks-attack"} } )

DefineUnitType("unit-altar-of-storms", { Name = "Altar of Storms",
  Files = {"tileset-summer", "tilesets/summer/orc/buildings/altar_of_storms.png",
    "tileset-winter", "tilesets/winter/orc/buildings/altar_of_storms.png",
    "tileset-swamp", "tilesets/swamp/orc/buildings/altar_of_storms.png"},
  Size = {96, 96},
  Animations = "animations-building", Icon = "icon-altar-of-storms",
  Costs = {"time", 175, "gold", 900, "wood", 500},
  RepairHp = 4,
  RepairCosts = {"gold", 1, "wood", 1},
  Construction = "construction-land",
  Speed = 0,
  HitPoints = 700,
  DrawLevel = 20,
  TileSize = {3, 3}, BoxSize = {95, 95},
  SightRange = 1,
  Armor = 20, BasicDamage = 0, PiercingDamage = 0, Missile = "missile-none",
  Priority = 15, AnnoyComputerFactor = 35,
  Points = 240,
  Corpse = {"unit-destroyed-3x3-place", 0},
  ExplodeWhenKilled = "missile-explosion",
  Type = "land",
  Building = true, VisibleUnderFog = true, 
  Sounds = {
    "selected", "altar-of-storms-selected",
    "acknowledge", "altar-of-storms-acknowledge",
    "ready", "altar-of-storms-ready",
    "help", "basic orc voices help 2",
    "dead", "building destroyed",
    "attack", "altar-of-storms-attack"} } )

DefineUnitType("unit-orc-watch-tower", { Name = "Watch Tower",
  Files = {"tileset-summer", "tilesets/summer/orc/buildings/watch_tower.png",
    "tileset-winter", "tilesets/winter/orc/buildings/watch_tower.png",
    "tileset-swamp", "tilesets/swamp/orc/buildings/watch_tower.png"},
  Size = {64, 64},
  Animations = "animations-building", Icon = "icon-orc-watch-tower",
  Costs = {"time", 60, "gold", 550, "wood", 200},
  RepairHp = 4,
  RepairCosts = {"gold", 1, "wood", 1},
  Construction = "construction-land",
  Speed = 0,
  HitPoints = 100,
  DrawLevel = 20,
  TileSize = {2, 2}, BoxSize = {63, 63},
  SightRange = 9,
  Armor = 20, BasicDamage = 0, PiercingDamage = 0, Missile = "missile-none",
  Priority = 55, AnnoyComputerFactor = 50,
  Points = 95,
  Corpse = {"unit-destroyed-2x2-place", 0},
  ExplodeWhenKilled = "missile-explosion",
  Type = "land",
  CanTargetLand = true, CanTargetSea = true, CanTargetAir = true,
  Building = true, VisibleUnderFog = true, 
  DetectCloak = true,
  Sounds = {
    "selected", "orc-watch-tower-selected",
    "acknowledge", "orc-watch-tower-acknowledge",
    "ready", "orc-watch-tower-ready",
    "help", "basic orc voices help 2",
    "dead", "building destroyed",
    "attack", "orc-watch-tower-attack"} } )

DefineUnitType("unit-ogre-mound", { Name = "Ogre Mound",
  Files = {"tileset-summer", "tilesets/summer/orc/buildings/ogre_mound.png",
    "tileset-winter", "tilesets/winter/orc/buildings/ogre_mound.png",
    "tileset-swamp", "tilesets/swamp/orc/buildings/ogre_mound.png"},
  Size = {96, 96},
  Animations = "animations-building", Icon = "icon-ogre-mound",
  Costs = {"time", 150, "gold", 1000, "wood", 300},
  RepairHp = 4,
  RepairCosts = {"gold", 1, "wood", 1},
  Construction = "construction-land",
  Speed = 0,
  HitPoints = 500,
  DrawLevel = 20,
  TileSize = {3, 3}, BoxSize = {95, 95},
  SightRange = 1,
  Armor = 20, BasicDamage = 0, PiercingDamage = 0, Missile = "missile-none",
  Priority = 15, AnnoyComputerFactor = 15,
  Points = 210,
  Corpse = {"unit-destroyed-3x3-place", 0},
  ExplodeWhenKilled = "missile-explosion",
  Type = "land",
  Building = true, VisibleUnderFog = true, 
  Sounds = {
    "selected", "ogre-mound-selected",
    "acknowledge", "ogre-mound-acknowledge",
    "ready", "ogre-mound-ready",
    "help", "basic orc voices help 2",
    "dead", "building destroyed",
    "attack", "ogre-mound-attack"} } )

DefineUnitType("unit-alchemist", { Name = "Goblin Alchemist",
  Files = {"tileset-summer", "tilesets/summer/orc/buildings/goblin_alchemist.png",
    "tileset-winter", "tilesets/winter/orc/buildings/goblin_alchemist.png",
    "tileset-swamp", "tilesets/swamp/orc/buildings/goblin_alchemist.png"},
  Size = {96, 96},
  Animations = "animations-building", Icon = "icon-alchemist",
  Costs = {"time", 150, "gold", 1000, "wood", 400},
  RepairHp = 4,
  RepairCosts = {"gold", 1, "wood", 1},
  Construction = "construction-land",
  Speed = 0,
  HitPoints = 500,
  DrawLevel = 20,
  TileSize = {3, 3}, BoxSize = {95, 95},
  SightRange = 1,
  Armor = 20, BasicDamage = 0, PiercingDamage = 0, Missile = "missile-none",
  Priority = 15, AnnoyComputerFactor = 20,
  Points = 230,
  Corpse = {"unit-destroyed-3x3-place", 0},
  ExplodeWhenKilled = "missile-explosion",
  Type = "land",
  Building = true, VisibleUnderFog = true, 
  Sounds = {
    "selected", "goblin-alchemist-selected",
    "acknowledge", "goblin-alchemist-acknowledge",
    "ready", "goblin-alchemist-ready",
    "help", "basic orc voices help 2",
    "dead", "building destroyed",
    "attack", "goblin-alchemist-attack"} } )

DefineUnitType("unit-dragon-roost", { Name = "Dragon Roost",
  Files = {"tileset-summer", "tilesets/summer/orc/buildings/dragon_roost.png",
    "tileset-winter", "tilesets/winter/orc/buildings/dragon_roost.png",
    "tileset-swamp", "tilesets/swamp/orc/buildings/dragon_roost.png"},
  Size = {96, 96},
  Animations = "animations-building", Icon = "icon-dragon-roost",
  Costs = {"time", 150, "gold", 1000, "wood", 400},
  RepairHp = 4,
  RepairCosts = {"gold", 1, "wood", 1},
  Construction = "construction-land",
  Speed = 0,
  HitPoints = 500,
  DrawLevel = 20,
  TileSize = {3, 3}, BoxSize = {95, 95},
  SightRange = 1,
  Armor = 20, BasicDamage = 0, PiercingDamage = 0, Missile = "missile-none",
  Priority = 15, AnnoyComputerFactor = 20,
  Points = 280,
  Corpse = {"unit-destroyed-3x3-place", 0},
  ExplodeWhenKilled = "missile-explosion",
  Type = "land",
  Building = true, VisibleUnderFog = true, 
  Sounds = {
    "selected", "dragon-roost-selected",
    "acknowledge", "dragon-roost-acknowledge",
    "ready", "dragon-roost-ready",
    "help", "basic orc voices help 2",
    "dead", "building destroyed",
    "attack", "dragon-roost-attack"} } )

DefineUnitType("unit-orc-shipyard", { Name = "Shipyard",
  Files = {"tileset-summer", "tilesets/summer/orc/buildings/shipyard.png",
    "tileset-winter", "tilesets/winter/orc/buildings/shipyard.png",
    "tileset-swamp", "tilesets/swamp/orc/buildings/shipyard.png"},
  Size = {96, 96},
  Animations = "animations-building", Icon = "icon-orc-shipyard",
  Costs = {"time", 200, "gold", 800, "wood", 450},
  RepairHp = 4,
  RepairCosts = {"gold", 1, "wood", 1},
  Construction = "construction-orc-shipyard",
  Speed = 0,
  HitPoints = 1100,
  DrawLevel = 20,
  TileSize = {3, 3}, BoxSize = {95, 95},
  SightRange = 1,
  Armor = 20, BasicDamage = 0, PiercingDamage = 0, Missile = "missile-none",
  Priority = 30, AnnoyComputerFactor = 20,
  Points = 170,
  Corpse = {"unit-destroyed-3x3-place", 3},
  ExplodeWhenKilled = "missile-explosion",
  Type = "land",
  Building = true, VisibleUnderFog = true, 
  ShoreBuilding = true,
  CanStore = {"oil"},
  Sounds = {
    "selected", "orc-shipyard-selected",
    "acknowledge", "orc-shipyard-acknowledge",
    "ready", "orc-shipyard-ready",
    "help", "basic orc voices help 2",
    "dead", "building destroyed",
    "attack", "orc-shipyard-attack"} } )

DefineUnitType("unit-great-hall", { Name = "Great Hall",
  Files = {"tileset-summer", "tilesets/summer/orc/buildings/great_hall.png",
    "tileset-winter", "tilesets/winter/orc/buildings/great_hall.png",
    "tileset-swamp", "tilesets/swamp/orc/buildings/great_hall.png"},
  Size = {128, 128},
  Animations = "animations-building", Icon = "icon-great-hall",
  Costs = {"time", 255, "gold", 1200, "wood", 800},
  RepairHp = 4,
  RepairCosts = {"gold", 1, "wood", 1},
  Construction = "construction-land",
  Speed = 0,
  HitPoints = 1200,
  DrawLevel = 20,
  TileSize = {4, 4}, BoxSize = {127, 127},
  SightRange = 1,
  Armor = 20, BasicDamage = 0, PiercingDamage = 0, Missile = "missile-none",
  Priority = 35, AnnoyComputerFactor = 45,
  Points = 200,
  Supply = 1,
  Corpse = {"unit-destroyed-4x4-place", 0},
  ExplodeWhenKilled = "missile-explosion",
  Type = "land",
  Building = true, VisibleUnderFog = true, 
  CanStore = {"gold", "wood"},
  Sounds = {
    "selected", "great-hall-selected",
    "acknowledge", "great-hall-acknowledge",
    "ready", "great-hall-ready",
    "help", "basic orc voices help 2",
    "dead", "building destroyed",
    "attack", "great-hall-attack"} } )

DefineUnitType("unit-troll-lumber-mill", { Name = "Troll Lumber Mill",
  Files = {"tileset-summer", "tilesets/summer/orc/buildings/troll_lumber_mill.png",
    "tileset-winter", "tilesets/winter/orc/buildings/troll_lumber_mill.png",
    "tileset-wasteland", "tilesets/wasteland/orc/buildings/troll_lumber_mill.png",
    "tileset-swamp", "tilesets/swamp/orc/buildings/troll_lumber_mill.png"},
  Size = {96, 96},
  Animations = "animations-building", Icon = "icon-troll-lumber-mill",
  Costs = {"time", 150, "gold", 600, "wood", 450},
  RepairHp = 4,
  RepairCosts = {"gold", 1, "wood", 1},
  ImproveProduction = {"wood", 25},
  Construction = "construction-land",
  Speed = 0,
  HitPoints = 600,
  DrawLevel = 20,
  TileSize = {3, 3}, BoxSize = {95, 95},
  SightRange = 1,
  Armor = 20, BasicDamage = 0, PiercingDamage = 0, Missile = "missile-none",
  Priority = 25, AnnoyComputerFactor = 15,
  Points = 150,
  Corpse = {"unit-destroyed-3x3-place", 0},
  ExplodeWhenKilled = "missile-explosion",
  Type = "land",
  Building = true, VisibleUnderFog = true, 
  CanStore = {"wood"},
  Sounds = {
    "selected", "troll-lumber-mill-selected",
    "acknowledge", "troll-lumber-mill-acknowledge",
    "ready", "troll-lumber-mill-ready",
    "help", "basic orc voices help 2",
    "dead", "building destroyed",
    "attack", "troll-lumber-mill-attack"} } )

DefineUnitType("unit-orc-foundry", { Name = "Foundry",
  Files = {"tileset-summer", "tilesets/summer/orc/buildings/foundry.png",
    "tileset-winter", "tilesets/winter/orc/buildings/foundry.png",
    "tileset-swamp", "tilesets/swamp/orc/buildings/foundry.png"},
  Size = {96, 96},
  Animations = "animations-building", Icon = "icon-orc-foundry",
  Costs = {"time", 175, "gold", 700, "wood", 400, "oil", 400},
  RepairHp = 4,
  RepairCosts = {"gold", 1, "wood", 1, "oil", 1},
  Construction = "construction-orc-foundry",
  Speed = 0,
  HitPoints = 750,
  DrawLevel = 20,
  TileSize = {3, 3}, BoxSize = {95, 95},
  SightRange = 1,
  Armor = 20, BasicDamage = 0, PiercingDamage = 0, Missile = "missile-none",
  Priority = 15, AnnoyComputerFactor = 20,
  Points = 200,
  Corpse = {"unit-destroyed-3x3-place", 3},
  ExplodeWhenKilled = "missile-explosion",
  Type = "land",
  Building = true, VisibleUnderFog = true, 
  ShoreBuilding = true,
  Sounds = {
    "selected", "orc-foundry-selected",
    "acknowledge", "orc-foundry-acknowledge",
    "ready", "orc-foundry-ready",
    "help", "basic orc voices help 2",
    "dead", "building destroyed",
    "attack", "orc-foundry-attack"} } )

DefineUnitType("unit-temple-of-the-damned", { Name = "Temple of the Damned",
  Files = {"tileset-summer", "tilesets/summer/orc/buildings/temple_of_the_damned.png",
    "tileset-winter", "tilesets/winter/orc/buildings/temple_of_the_damned.png",
    "tileset-swamp", "tilesets/swamp/orc/buildings/temple_of_the_damned.png"},
  Size = {96, 96},
  Animations = "animations-building", Icon = "icon-temple-of-the-damned",
  Costs = {"time", 125, "gold", 1000, "wood", 200},
  RepairHp = 4,
  RepairCosts = {"gold", 1, "wood", 1},
  Construction = "construction-land",
  Speed = 0,
  HitPoints = 500,
  DrawLevel = 20,
  TileSize = {3, 3}, BoxSize = {95, 95},
  SightRange = 1,
  Armor = 20, BasicDamage = 0, PiercingDamage = 0, Missile = "missile-none",
  Priority = 35, AnnoyComputerFactor = 20,
  Points = 240,
  Corpse = {"unit-destroyed-3x3-place", 0},
  ExplodeWhenKilled = "missile-explosion",
  Type = "land",
  Building = true, VisibleUnderFog = true, 
  Sounds = {
    "selected", "temple-of-the-damned-selected",
    "acknowledge", "temple-of-the-damned-acknowledge",
    "ready", "temple-of-the-damned-ready",
    "help", "basic orc voices help 2",
    "dead", "building destroyed",
    "attack", "temple-of-the-damned-attack"} } )

DefineUnitType("unit-orc-blacksmith", { Name = "Blacksmith",
  Files = {"tileset-summer", "tilesets/summer/orc/buildings/blacksmith.png",
    "tileset-winter", "tilesets/winter/orc/buildings/blacksmith.png",
    "tileset-swamp", "tilesets/swamp/orc/buildings/blacksmith.png"},
  Size = {96, 96},
  Animations = "animations-building", Icon = "icon-orc-blacksmith",
  Costs = {"time", 200, "gold", 800, "wood", 450, "oil", 100},
  RepairHp = 4,
  RepairCosts = {"gold", 1, "wood", 1, "oil", 1},
  Construction = "construction-land",
  Speed = 0,
  HitPoints = 775,
  DrawLevel = 20,
  TileSize = {3, 3}, BoxSize = {95, 95},
  SightRange = 1,
  Armor = 20, BasicDamage = 0, PiercingDamage = 0, Missile = "missile-none",
  Priority = 15, AnnoyComputerFactor = 20,
  Points = 170,
  Corpse = {"unit-destroyed-3x3-place", 0},
  ExplodeWhenKilled = "missile-explosion",
  Type = "land",
  Building = true, VisibleUnderFog = true, 
  Sounds = {
    "selected", "orc-blacksmith-selected",
    "acknowledge", "orc-blacksmith-acknowledge",
    "ready", "orc-blacksmith-ready",
    "help", "basic orc voices help 2",
    "dead", "building destroyed",
    "attack", "orc-blacksmith-attack"} } )

DefineUnitType("unit-orc-refinery", { Name = "Refinery",
  Files = {"tileset-summer", "tilesets/summer/orc/buildings/refinery.png",
    "tileset-winter", "tilesets/winter/orc/buildings/refinery.png",
    "tileset-swamp", "tilesets/swamp/orc/buildings/refinery.png"},
  Size = {96, 96},
  Animations = "animations-building", Icon = "icon-orc-refinery",
  Costs = {"time", 225, "gold", 800, "wood", 350, "oil", 200},
  RepairHp = 4,
  RepairCosts = {"gold", 1, "wood", 1, "oil", 1},
  ImproveProduction = {"oil", 25},
  Construction = "construction-orc-refinery",
  Speed = 0,
  HitPoints = 600,
  DrawLevel = 20,
  TileSize = {3, 3}, BoxSize = {95, 95},
  SightRange = 1,
  Armor = 20, BasicDamage = 0, PiercingDamage = 0, Missile = "missile-none",
  Priority = 25, AnnoyComputerFactor = 20,
  Points = 200,
  Corpse = {"unit-destroyed-3x3-place", 3},
  ExplodeWhenKilled = "missile-explosion",
  Type = "land",
  Building = true, VisibleUnderFog = true, 
  ShoreBuilding = true,
  CanStore = {"oil"},
  Sounds = {
    "selected", "orc-refinery-selected",
    "acknowledge", "orc-refinery-acknowledge",
    "ready", "orc-refinery-ready",
    "help", "basic orc voices help 2",
    "dead", "building destroyed",
    "attack", "orc-refinery-attack"} } )

DefineUnitType("unit-orc-oil-platform", { Name = "Oil Platform",
  Files = {"tileset-summer", "tilesets/summer/orc/buildings/oil_platform.png",
    "tileset-winter", "tilesets/winter/orc/buildings/oil_platform.png",
    "tileset-wasteland", "tilesets/wasteland/orc/buildings/oil_platform.png",
    "tileset-swamp", "tilesets/swamp/orc/buildings/oil_platform.png"},
  Size = {96, 96},
  Animations = "animations-building", Icon = "icon-orc-oil-platform",
  Costs = {"time", 200, "gold", 700, "wood", 450},
  Construction = "construction-orc-oil-well",
  Speed = 0,
  HitPoints = 650,
  DrawLevel = 20,
  TileSize = {3, 3}, BoxSize = {95, 95},
  SightRange = 1,
  Armor = 20, BasicDamage = 0, PiercingDamage = 0, Missile = "missile-none",
  Priority = 20, AnnoyComputerFactor = 20,
  Points = 160,
  Corpse = {"unit-destroyed-3x3-place", 3},
  ExplodeWhenKilled = "missile-explosion",
  Type = "naval",
  Building = true, VisibleUnderFog = true, 
  MustBuildOnTop = "unit-oil-patch",
  GivesResource = "oil", CanHarvest = true,
  Sounds = {
    "selected", "orc-oil-platform-selected",
    "acknowledge", "orc-oil-platform-acknowledge",
    "ready", "orc-oil-platform-ready",
    "help", "basic orc voices help 2",
    "dead", "building destroyed",
    "attack", "orc-oil-platform-attack"} } )

DefineUnitType("unit-stronghold", { Name = "Stronghold",
  Files = {"tileset-summer", "tilesets/summer/orc/buildings/stronghold.png",
    "tileset-winter", "tilesets/winter/orc/buildings/stronghold.png",
    "tileset-swamp", "tilesets/swamp/orc/buildings/stronghold.png"},
  Size = {128, 128},
  Animations = "animations-building", Icon = "icon-stronghold",
  Costs = {"time", 200, "gold", 2000, "wood", 1000, "oil", 200},
  RepairHp = 4,
  RepairCosts = {"gold", 1, "wood", 1, "oil", 1},
  ImproveProduction = {"gold", 10},
  Construction = "construction-land",
  Speed = 0,
  HitPoints = 1400,
  DrawLevel = 20,
  TileSize = {4, 4}, BoxSize = {127, 127},
  SightRange = 2,
  Armor = 20, BasicDamage = 0, PiercingDamage = 0, Missile = "missile-none",
  Priority = 37, AnnoyComputerFactor = 40,
  Points = 600,
  Supply = 1,
  Corpse = {"unit-destroyed-4x4-place", 0},
  ExplodeWhenKilled = "missile-explosion",
  Type = "land",
  Building = true, VisibleUnderFog = true, 
  CanStore = {"gold", "wood"},
  Sounds = {
    "selected", "stronghold-selected",
    "acknowledge", "stronghold-acknowledge",
    "ready", "stronghold-ready",
    "help", "basic orc voices help 2",
    "dead", "building destroyed",
    "attack", "stronghold-attack"} } )

DefineUnitType("unit-fortress", { Name = "Fortress",
  Files = {"tileset-summer", "tilesets/summer/orc/buildings/fortress.png",
    "tileset-winter", "tilesets/winter/orc/buildings/fortress.png",
    "tileset-swamp", "tilesets/swamp/orc/buildings/fortress.png"},
  Size = {128, 128},
  Animations = "animations-building", Icon = "icon-fortress",
  Costs = {"time", 200, "gold", 2500, "wood", 1200, "oil", 500},
  RepairHp = 4,
  RepairCosts = {"gold", 1, "wood", 1, "oil", 1},
  ImproveProduction = {"gold", 20},
  Construction = "construction-land",
  Speed = 0,
  HitPoints = 1600,
  DrawLevel = 20,
  TileSize = {4, 4}, BoxSize = {127, 127},
  SightRange = 6,
  Armor = 20, BasicDamage = 0, PiercingDamage = 0, Missile = "missile-none",
  Priority = 40, AnnoyComputerFactor = 50,
  Points = 1500,
  Supply = 1,
  Corpse = {"unit-destroyed-4x4-place", 0},
  ExplodeWhenKilled = "missile-explosion",
  Type = "land",
  Building = true, VisibleUnderFog = true, 
  CanStore = {"gold", "wood"},
  Sounds = {
    "selected", "fortress-selected",
    "acknowledge", "fortress-acknowledge",
    "ready", "fortress-ready",
    "help", "basic orc voices help 2",
    "dead", "building destroyed",
    "attack", "fortress-attack"} } )

DefineUnitType("unit-orc-start-location", { Name = "Start Location",
  Files = {"tileset-summer", "orc/o_startpoint.png"},
  Size = {32, 32},
  NumDirections = 1,
  Animations = "animations-building", Icon = "icon-cancel",
  Speed = 0,
  HitPoints = 0,
  DrawLevel = 0,
  TileSize = {1, 1}, BoxSize = {31, 31},
  SightRange = 0,
  BasicDamage = 0, PiercingDamage = 0, Missile = "missile-none",
  Priority = 0,
  Demand = 0,
  Type = "land",
  Sounds = {
    "selected", "orc-start-location-selected",
    "acknowledge", "orc-start-location-acknowledge",
    "ready", "orc-start-location-ready",
    "help", "basic orc voices help 2",
    "dead", "building destroyed",
    "attack", "orc-start-location-attack"} } )

DefineUnitType("unit-orc-guard-tower", { Name = "Guard Tower",
  Files = {"tileset-summer", "tilesets/summer/orc/buildings/guard_tower.png",
    "tileset-winter", "tilesets/winter/orc/buildings/guard_tower.png",
    "tileset-swamp", "tilesets/swamp/orc/buildings/guard_tower.png"},
  Size = {64, 64},
  Animations = "animations-human-guard-tower", Icon = "icon-orc-guard-tower",
  Costs = {"time", 140, "gold", 500, "wood", 150},
  RepairHp = 4,
  RepairCosts = {"gold", 1, "wood", 1},
  Construction = "construction-land",
  Speed = 0,
  HitPoints = 130,
  DrawLevel = 40,
  TileSize = {2, 2}, BoxSize = {63, 63},
  SightRange = 9, ComputerReactionRange = 6, PersonReactionRange = 6,
  Armor = 20, BasicDamage = 4, PiercingDamage = 12, Missile = "missile-arrow",
  MaxAttackRange = 6,
  Priority = 40, AnnoyComputerFactor = 50,
  Points = 200,
  Corpse = {"unit-destroyed-2x2-place", 0},
  ExplodeWhenKilled = "missile-explosion",
  Type = "land",
  CanAttack = true,
  CanTargetLand = true, CanTargetSea = true, CanTargetAir = true,
  Building = true, VisibleUnderFog = true, 
  DetectCloak = true,
  Sounds = {
    "selected", "orc-guard-tower-selected",
    "acknowledge", "orc-guard-tower-acknowledge",
    "ready", "orc-guard-tower-ready",
    "help", "basic orc voices help 2",
    "dead", "building destroyed",
    "attack", "orc-guard-tower-attack"} } )

DefineUnitType("unit-orc-cannon-tower", { Name = "Cannon Tower",
  Files = {"tileset-summer", "tilesets/summer/orc/buildings/cannon_tower.png",
    "tileset-winter", "tilesets/winter/orc/buildings/cannon_tower.png",
    "tileset-swamp", "tilesets/swamp/orc/buildings/cannon_tower.png"},
  Size = {64, 64},
  Animations = "animations-human-cannon-tower", Icon = "icon-orc-cannon-tower",
  Costs = {"time", 190, "gold", 1000, "wood", 300},
  RepairHp = 4,
  RepairCosts = {"gold", 1, "wood", 1},
  Construction = "construction-land",
  Speed = 0,
  HitPoints = 160,
  DrawLevel = 40,
  TileSize = {2, 2}, BoxSize = {63, 63},
  SightRange = 9, ComputerReactionRange = 7, PersonReactionRange = 7,
  Armor = 20, BasicDamage = 50, PiercingDamage = 0, Missile = "missile-small-cannon",
  MinAttackRange = 2, MaxAttackRange = 7,
  Priority = 40, AnnoyComputerFactor = 50,
  Points = 250,
  Corpse = {"unit-destroyed-2x2-place", 0},
  ExplodeWhenKilled = "missile-explosion",
  Type = "land",
  CanAttack = true,
  CanTargetLand = true, CanTargetSea = true,
  Building = true, VisibleUnderFog = true, 
  DetectCloak = true,
  Sounds = {
    "selected", "orc-cannon-tower-selected",
    "acknowledge", "orc-cannon-tower-acknowledge",
    "ready", "orc-cannon-tower-ready",
    "help", "basic orc voices help 2",
    "dead", "building destroyed",
    "attack", "orc-cannon-tower-attack"} } )

DefineUnitType("unit-orc-wall", { Name = "Wall",
  Use = "unit-human-wall",
  Size = {32, 32},
  Animations = "animations-building", Icon = "icon-orc-wall",
  Costs = {"time", 30, "gold", 20, "wood", 10},
  Construction = "construction-wall",
  Speed = 0,
  HitPoints = 40,
  DrawLevel = 39,
  TileSize = {1, 1}, BoxSize = {31, 31},
  SightRange = 1,
  Armor = 20, BasicDamage = 0, PiercingDamage = 0, Missile = "missile-none",
  Priority = 0, AnnoyComputerFactor = 45,
  Points = 1,
  Corpse = {"unit-destroyed-1x1-place", 0},
  ExplodeWhenKilled = "missile-explosion",
  Type = "land",
  Building = true, VisibleUnderFog = true, 
  Sounds = {
    "selected", "orc-wall-selected",
    "acknowledge", "orc-wall-acknowledge",
    "ready", "orc-wall-ready",
    "help", "basic orc voices help 2",
    "dead", "building destroyed",
    "attack", "orc-wall-attack"} } )

