#!/bin/sh
##       _________ __                 __                               
##      /   _____//  |_____________ _/  |______     ____  __ __  ______
##      \_____  \\   __\_  __ \__  \\   __\__  \   / ___\|  |  \/  ___/
##      /        \|  |  |  | \// __ \|  |  / __ \_/ /_/  >  |  /\___ \ 
##     /_______  /|__|  |__|  (____  /__| (____  /\___  /|____//____  >
##             \/                  \/          \//_____/            \/ 
##  ______________________                           ______________________
##			  T H E   W A R   B E G I N S
##	   Stratagus - A free fantasy real time strategy game engine
##
##	build.sh	-	The graphics and sound extractor.
##
##	(c) Copyright 1999-2002 by Lutz Sammer
##
##	Stratagus is free software; you can redistribute it and/or modify
##	it under the terms of the GNU General Public License as published
##	by the Free Software Foundation; only version 2 of the License.
##
##	Stratagus is distributed in the hope that it will be useful,
##	but WITHOUT ANY WARRANTY; without even the implied warranty of
##	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
##	GNU General Public License for more details.
##
##	$Id: build.sh,v 1.53 2004/02/20 19:51:22 nehalmistry Exp $
##

cd `dirname $0`

# parameters
#
# -z / -I : COMPRESS = gzip --force --best / bzip2 --force
# -p path : CDROM = /cdrom / /mnt/cdrom ..
# -o DIR = /usr/share/games/stratagus/warii
# -T path : BINPATH = /usr/lib/stratagus/tools
# -C CONTRIB = /usr/lib/stratagus/contrib
# -v : Extract also videos

#	compress parameters
GZIP="gzip --force --best"
BZIP2="bzip2 --force"

#       cdrom autodetection
CDROM="/tmp/WARCRAFT2_X"
USE_DOS=1

if [ -d "/Warcraft IIx CD" ]; then
	CDROM="/Warcraft IIx CD"
	USE_DOS=0
fi

###
### Change the next, to meet your requirements:
###

#
#       Choose your default compression or use -z or -I.
#
COMPRESS=$GZIP
#COMPRESS=$BZIP2

#
#       Here are my executeables or -T dir.
#
BINPATH="."

#
#       Here are the extra files contributed or -C dir.
#
CONTRIB="contrib"

#
#       Here is the destination for the generated files
#
DIR="data"

###
###	Below this point, you should only search bugs. :-)
###

while [ $# -gt 0 ]; do
	case "$1" in
		-p)	CDROM="$2"; shift ;;
		-o)	DIR="$2"; shift ;;

		-z)	COMPRESS="$GZIP" ;;
		-I)	COMPRESS="$BZIP2" ;;

		-T)	BINPATH="$2"; shift ;;

		-v)	VIDEO="-v"; shift ;;

		-m)	USE_DOS=0; shift ;;

		--help) $0 -h; exit 0;;
		-h)	cat << EOF
build.sh
 -z / -I : COMPRESS = gzip --force --best / bzip2 --force
 -p path : CDROM = /cdrom / /mnt/cdrom ..
 -o DIR = /usr/share/games/stratagus/warii
 -T path : BINPATH = /usr/lib/stratagus/tools
 -v : Also extract video
 -m : Extract from mac CD
EOF
			exit 0;;

		*)
			echo 2>&1 "Unknown option: $1"
			exit 1
	esac
	shift
done

if [ -d "$CDROM/data/" ]; then
	DATADIR="$CDROM/data/"
elif [ -d "$CDROM/DATA/" ]; then
	DATADIR="$CDROM/DATA/"
fi

if [ ! -f "$DATADIR/rezdat.war" ] && [ ! -f "$DATADIR/REZDAT.WAR" ] && [ ! -f "$DATADIR/War Resources" ]; then
    echo "error: '$DATADIR/rezdat.war' does not exist"
    echo "error: '$DATADIR/War Resources' does not exist"
    echo "Specify the location of the data files with the '-p' option"
    exit -1
fi

# Create the directory structure

[ -d $DIR ] || mkdir $DIR

# More is now done automatic

###############################################################################
##	Extract
###############################################################################

# ADD -e      To force that the archive is expansion compatible
# ADD -n      To force that the archive is not expansion compatible
if [ $USE_DOS = 1 ];then
WARTOOL="wartool.dos"
else
WARTOOL="wartool.mac"
fi

$BINPATH/$WARTOOL $VIDEO "$DATADIR" "$DIR"

###############################################################################
##	MISC
###############################################################################

#
##	Compress the sounds
#
find $DIR/sounds -type f -name "*.wav" -print -exec $COMPRESS {} \;

#
##	Compress the texts
#
find $DIR/campaigns -type f -name "*.txt" -print -exec $COMPRESS {} \;

#
##	Copy original puds into data directory
#
echo "Copying maps and compressing"
if [ -d "$DATADIR/../puds" ]; then
	PUDDIR="$DATADIR/../puds"
elif [ -d "$DATADIR/../PUDS" ]; then
	PUDDIR="$DATADIR/../PUDS"
fi

mkdir $DIR/puds
[ -d "$PUDDIR" ] && cp -r $PUDDIR/* $DIR/puds >/dev/null 2>&1
[ -f "$DATADIR/../alamo.pud" ] && cp -r $DATADIR/../*.pud $DIR/puds >/dev/null 2>&1
[ -f "$DATADIR/../ALAMO.PUD" ] && cp -r $DATADIR/../*.PUD $DIR/puds >/dev/null 2>&1

DIRS=`find $DIR/puds -type d -print`
for i in $DIRS;do
NAME=`echo $i | tr A-Z a-z`
	if [ "$i" != "$NAME" ]       # Rename only files not already lowercase.
	then
		mv $i $NAME
	fi
done

FILES=`find $DIR/puds -type f -print`
for i in $FILES;do
NAME=`echo $i | tr A-Z a-z`
	if [ "$i" != "$NAME" ]       # Rename only files not already lowercase.
	then
		mv $i $NAME
	fi
done

find $DIR/puds -type f -name "*.pud" -print -exec $COMPRESS {} \ >/dev/null 2>&1;

#
##	The default pud.
#
[ -f "$DIR/maps/multi/(2)mysterious-dragon-isle.pud.gz" ] \
	&& ln -sf "multi/(2)mysterious-dragon-isle.pud.gz" \
	    $DIR/maps/default.pud.gz
[ -f "$DIR/maps/multi/(2)mysterious-dragon-isle.pud.bz2" ] \
	&& ln -sf "multi/(2)mysterious-dragon-isle.pud.bz2" \
	    $DIR/maps/default.pud.bz2

#
##  Rename puds to maps for consistancy
#
cp -R $DIR/puds/. $DIR/maps
rm -rf $DIR/maps/my_puds $DIR/puds $DIR/maps/MY_PUDS

echo "WC2 data setup is now complete"
echo "NOTE: you do not need to run this script again"

exit 0
