#!/bin/sh

cd `dirname $0`

XYZZY="`mountvolume -lh`"

NEEDEDLINE="`echo \"$XYZZY\" | grep -i \"WAR\"`"

if [ "$NEEDEDLINE" = "" ] ; then
alert --stop "You do not appear to have the Warcraft ][ CD in your computer, please put it in the CD-ROM drive and run this program again."
exit
fi

if [ "`echo \"$NEEDEDLINE\" | cut -c 22-24`" = "IDE" ] ; then
SCSIORIDE="ide/atapi"
  if [ "`echo \"$NEEDEDLINE\" | cut -c 26-31`" = "master" ] ; then
    BUSID="`echo \"$NEEDEDLINE\" | cut -c 37`"
    DEVICEID="master"
  else
    BUSID="`echo \"$NEEDEDLINE\" | cut -c 36`"
    DEVICEID="slave"
  fi
else
  SCSIORIDE="scsi"
  BUSID="`echo \"$NEEDEDLINE\" | cut -c 31`"
  DEVICEID="`echo \"$NEEDEDLINE\" | cut -c 36`"
fi

CDDEVICE="/dev/disk/$SCSIORIDE/$BUSID/$DEVICEID/0/raw"

ISOK="`alert --empty \"WarCraft][ CD Data Install for FreeCraft on BeOS
---
This program will install the WarCraft ][ graphics, sounds and level from your CDROM into the Wargus data directory. Unfortunatly, during this process it is impossible to give a progress report, so just be patient, it may take a little while to complete, possibly up to 10 min if you have a slow CDROM drive.

Your CDROM Drive has been determined to be:
$CDDEVICE

If this is incorrect, you may still use the old install method.
\" \"Abort! Abort! Abort!\" \"It's All Good\"`"

if [ "$ISOK" = "Abort! Abort! Abort!" ] ; then
alert --warning "Fine, Be that way!" "OK! I will!"
exit
fi

mkdir /tmp/WARCRAFT2_X
mount -t iso9660 $CDDEVICE /tmp/WARCRAFT2_X

ARCHIVE="/tmp/WARCRAFT2_X"

if [ -d "$ARCHIVE/data/" ]; then
	DATADIR="$ARCHIVE/data/"
elif [ -d "$ARCHIVE/DATA/" ]; then
	DATADIR="$ARCHIVE/DATA/"
fi

if [ ! -f "$DATADIR/rezdat.war" ] && [ ! -f "$DATADIR/REZDAT.WAR" ] && [ ! -f "$DATADIR/War Resources" ]; then
    alert --stop "ERROR: Couldn't find $DATADIR/rezdat.war or $DATADIR/War Resources" "OK"
    exit -1
fi

USEVIDEO="`alert --empty \"Should I attempt to extract videos also?\" \"No\" \"Yes\"`"
if [ "$USEVIDEO" = "Yes" ];then
VIDEO=-v
else
VIDEO=
fi
./tools/build.sh $VIDEO

unmount /tmp/WARCRAFT2_X
rm -rf /tmp/WARCRAFT2_X

alert --info "WarCraft ][ Data install is complete, Have Fun!" "Aaaaaaww Yeah!"
exit 0
