// detect_and_synchronise.cpp
//
// detect mouse, figure out protocol (using PnP if available), and synchronise to it.

#define DEBUG 1
#include "wmouse.h"

void WMInputDevice::detect_and_synchronise(void)
{
  unsigned char buffer[256];
  int bytes_read = 0,
      total_read = 0,
      packet_start = 0,
      packet_length = 0,
      packets_read = 0;
  bool pnp = false;

  // keep reading bytes until we see something we recognise
  while(1/*something (not_detected?)*/) {
  bytes_read = 0;
  while(bytes_read == 0) {
    bytes_read = serial->Read((void *)&(buffer[total_read]), 1);
    total_read += bytes_read;
    if(total_read > 250) break;
    snooze(1000);
  }
    if(total_read >= 2) {
      if(bytes_read && (buffer[total_read - 2] & 0x40)
                    && (!(buffer[total_read - 1]) & 0x40)) {
        // this could be the start of a packet
        SERIAL_PRINT(("wmouse: might have found the start of a packet\n"));
        if(packet_start == 0) packet_start = total_read; // note that packet starts at buffer[packet_start - 1]
        else {
          if((packet_length != 0) && (packet_length != (total_read - packet_start))) {
            // previous `packet' was bogus
            SERIAL_PRINT(("wmouse: previous `packet' was bogus\n"));
            --packets_read;
          }
          packet_length = total_read - packet_start;
          packet_start = total_read;
          ++packets_read;
          if(packets_read >= 2) {
            detect_protocol(buffer, packet_start - 1, packet_length, packets_read);
            // break; if the protocol looks valid
          }
        }
        continue;  // don't risk PnP
      } /* if it looks like a packet */
    }
//    SERIAL_PRINT(("wmouse: checking for PnP\n"));
    if(bytes_read) {
      if(buffer[total_read - 1] == 0x08) {
        // looks like Plug 'n' Pray
        pnp = true;
        if(do_pnp(buffer, total_read) == B_OK) break;
      }
    }
  } /* while */
    
//      for (int i = 0; i < 4; ++i) { serial.Read((void *)&buffer, 1); }  // read 'Z' and dummy packet; throw them away
//      buffer = 0;
//      while((buffer & 0x40) != 0x40) { serial.Read((void *) &buffer, 1); SERIAL_PRINT((" b0x%02x", buffer)); }
//      for (int i = 0; i < 3; ++i) { serial.Read((void *) &buffer, 1); SERIAL_PRINT((" i0x%02x", buffer)); }
SERIAL_PRINT(("wmouse: exiting detect_and_synchronise()\n"));
}

// WMInputDevice::detect_protocol()
//
// bytes read are in buffer
// last_byte is the offset of the end of the last packet
// packet_length is the suspected packet length
// packets_received is the number of suspected packets of length packet_length received
void WMInputDevice::detect_protocol(unsigned char *buffer, int last_byte, int packet_length, int packets_read) {
  SERIAL_PRINT(("wmouse: detect_protocol()\n"));
    for(int i = 0; i < packets_read; ++i) {
    for(int j = 0; j < packet_length; ++j) {
      SERIAL_PRINT((" 0x%02x", buffer[last_byte - (packets_read - i) * packet_length + j]));
    }
  SERIAL_PRINT(("\n"));
  }
}

// WMInputDevice::do_pnp()
//
// At entry, we've just read 0x08 into buffer[pnp_start - 1].  We think it's the
// start of a Plug 'n' Pray block.
status_t WMInputDevice::do_pnp(unsigned char *buffer, int pnp_start) {
//  unsigned char byte_read = '\0';
  int pnp_bytes_read = 0,
      total_pnp_read = 0;

SERIAL_PRINT(("wmouse: attempting Plug 'n' Pray\n"));
  pnpinfo = (struct pnp_info *)malloc(sizeof(struct pnp_info));
  if(pnpinfo == NULL) return B_ERROR;

  // this should probably check each byte individually---this version
  // relies on the user not moving the mouse before this point
  while(buffer[pnp_start + total_pnp_read - 1] != 0x09) {
    pnp_bytes_read = serial->Read((void *)&(buffer[pnp_start + total_pnp_read]), 1);
//SERIAL_PRINT(("wmouse: PnP has read %d byte(s) (most recent was 0x%02x)\n", total_pnp_read + pnp_bytes_read, buffer[pnp_start + total_pnp_read]));
    total_pnp_read += pnp_bytes_read;
    if((pnp_start + total_pnp_read) > 250) return B_ERROR;
    snooze(1000);
  }
  
  // Right.  PnP info runs from buffer[pnp_start]
  //                         to buffer[pnp_start + total_pnp_read -1].
  pnpinfo->version.major = buffer[pnp_start + 0];
  pnpinfo->version.minor = buffer[pnp_start + 1];
SERIAL_PRINT(("wmouse: PnP version is 0x%02x.%02x\n", pnpinfo->version.major, pnpinfo->version.minor));
  sprintf(pnpinfo->product_id, "%8s", &(buffer[pnp_start + 2]));
  pnpinfo->product_id[7] = '\0';
  for(unsigned int i = 0; i < strlen(pnpinfo->product_id); ++i) pnpinfo->product_id[i] += 0x20;
  SERIAL_PRINT(("wmouse: PnP Unique Product identifier is %s\n", pnpinfo->product_id));

  pnpinfo->checksum = (buffer[pnp_start + total_pnp_read - pnp_bytes_read - 2] << 0)
                    | (buffer[pnp_start + total_pnp_read - pnp_bytes_read - 1] << 8);
  SERIAL_PRINT(("wmouse: PnP checksum is 0x%04x\n", pnpinfo->checksum));
  if(buffer[pnp_start + 9] == 0x3c) { // extended PnP block follows
    SERIAL_PRINT(("wmouse: inspecting extended PnP block\n"));
    char *driver_id = strchr(&(((char *)buffer)[pnp_start + 11]), 0x3c); // class name is at least one character long
    driver_id[0] = '\0';
    for(unsigned int i = 0; i < strlen((char *)&(buffer[pnp_start + 10])); ++i) buffer[pnp_start + 10 + i] += 0x20;
    strncpy(pnpinfo->class_name, &(((char *)buffer)[pnp_start + 10]), 16);
    SERIAL_PRINT(("wmouse: PnP class name is %s\n", pnpinfo->class_name));
    strncpy(pnpinfo->driver_id, ++driver_id, 8);
    pnpinfo->driver_id[7] = '\0';
    for(unsigned int i = 0; i < strlen(pnpinfo->driver_id); ++i) pnpinfo->driver_id[i] += 0x20;
    SERIAL_PRINT(("wmouse: PnP driver id is %s\n", pnpinfo->driver_id));
  }  /* extended PnP block */

  // so now do something with the PnP data, eh?

  SERIAL_PRINT(("wmouse: PnP finished\n"));
  return B_OK;
}  /* do_pnp() */
