// do_something_with_it.c
//

//#define DEBUG 1
#include "wmouse.h"

void WMInputDevice::process_byte(unsigned char buffer)
{
  static int which_byte = 0;

  SERIAL_PRINT((" 0x%02x", buffer));
  if ((which_byte == 0) && ((buffer & 0x40) != 0x40)) return;
  switch(which_byte) {
    case 0:
//      SERIAL_PRINT(("first byte is 0x%02x", buffer));
      state->buttons_old = state->buttons_new;
      state->dx = (int8)((buffer & 0x03) << 6);
      state->dy = (int8)((buffer & 0x0c) << 4);
      state->buttons_new = ((buffer & 0x20) ? current_mouse_map->left : 0)
                         | ((buffer & 0x10) ? current_mouse_map->right : 0);
      break;
    case 1:
//SERIAL_PRINT((" dx: %d;", state->dx));
      state->dx |= (int8)buffer;
//SERIAL_PRINT((" dx: %d;", state->dx));
      break;
    case 2:
//SERIAL_PRINT((" dy: %d;", state->dy));
      state->dy |= (int8)buffer;
//SERIAL_PRINT((" dy: %d;", state->dy));
      break;
    case 3:
      state->buttons_new |= ((buffer & 0x10) ? current_mouse_map->middle : 0)
                          | ((buffer & 0x20) ? B_QUATERNARY_MOUSE_BUTTON : 0);
      state->wheel_change = (buffer & 0x0f);
      // sign extend from 4 bits
      state->wheel_change -= ((state->wheel_change >= 8) ? 16 : 0);
SERIAL_PRINT((" b: %x, wc: %d", state->buttons_new, state->wheel_change));
      break;
  }
  ++which_byte;
  if (which_byte == 4) which_byte = 0;
}

void WMInputDevice::process_bytes(void *arg, unsigned char *buffer, int bytes_read)
{
  static int which_byte = 0;
  static unsigned char mouse_state[4];

  for (int i = 0; i < bytes_read; ++i) {
    mouse_state[which_byte] = buffer[i];
    ++which_byte;
//    SERIAL_PRINT(("which_byte: %d\n", which_byte));
    if (which_byte >= 4) {
      state->buttons_old = state->buttons_new;
      state->dx = (int8)((mouse_state[0] & 0x03) << 6);
      state->dy = (int8)((mouse_state[0] & 0x0c) << 4);
      state->buttons_new = ((mouse_state[0] & 0x20) ? current_mouse_map->left : 0)
                         | ((mouse_state[0] & 0x10) ? current_mouse_map->right : 0);
      state->dx |= (int8)mouse_state[1];
SERIAL_PRINT((" dx: %d;", state->dx));
      state->dy |= (int8)mouse_state[2];
SERIAL_PRINT((" dy: %d;", state->dy));
      state->buttons_new |= ((mouse_state[3] & 0x10) ? current_mouse_map->middle : 0)
                          | ((mouse_state[3] & 0x20) ? B_QUATERNARY_MOUSE_BUTTON : 0);
      state->wheel_change = (mouse_state[3] & 0x0f);
      // sign extend from 4 bits
      state->wheel_change -= ((state->wheel_change >= 8) ? 16 : 0);
SERIAL_PRINT((" b: %x, wc: %d", state->buttons_new, state->wheel_change));

      notify_changes(arg);
  SERIAL_PRINT((" 0x%02x 0x%02x 0x%02x 0x%02x\n",
          mouse_state[0], mouse_state[1], mouse_state[2], mouse_state[3]));
      which_byte -= 4;
    }
//  SERIAL_PRINT((" %d: 0x%02x 0x%02x 0x%02x 0x%02x (wb: %d)\n",
//          bytes_read, mouse_state[0], mouse_state[1], mouse_state[2], mouse_state[3], which_byte));
  }

  // we are synchronised at this point
  //  if ((which_byte == 0) && ((buffer & 0x40) != 0x40)) return;

  if (which_byte == 4) which_byte = 0;
}
