// send_key.cpp
//
// send a keypress (and release)

//#define DEBUG 1
#include <support/Debug.h>
#include <interface/InterfaceDefs.h>
#include "wmouse.h"

// The key_code and key values are as follows for the most likely keys:
// key_code			key
// -------------	----
// B_PAGE_UP		0x21
// B_PAGE_DOWN		0x36
// B_UP_ARROW		0x57
// B_DOWN_ARROW		0x62
// B_LEFT_ARROW		0x61
// B_RIGHT_ARROW	0x63
status_t WMInputDevice::send_key(void *arg, int8 key_code) {
  status_t err;
  key_info current_info;
  bigtime_t now;
  int32 key = 0L;
  BMessage *key_msg = 0L;
  BInputServerDevice *wmDevice = (BInputServerDevice *)arg;
  
  now = system_time();
  if(key_code == B_PAGE_UP) {  // change here
    SERIAL_PRINT(("wmouse: send_key(): PageUp\n"));
    key = 0x21;  // and here
    // to change keypresses
  }
  else if(key_code == B_PAGE_DOWN) {  // also change here
         SERIAL_PRINT(("wmouse: send_key(): PageDown\n"));
         key = 0x36;  // and here
         // to change keypresses
       }
       else SERIAL_PRINT(("wmouse: send_key(): not PageUp or PageDown\n"));

  if ((err = get_key_info(&current_info)) != B_OK) return err;
  
  key_msg = new BMessage(B_KEY_DOWN);
  key_msg->AddInt64("when", now);
  key_msg->AddInt32("modifiers", current_info.modifiers);
  key_msg->AddInt32("key", key);
  
  key_msg->AddData("states", B_UINT8_TYPE, &current_info.key_states[0], 16);
//  key_msg->AddInt8("states", current_info.key_states);

  key_msg->AddInt32("raw_char", (int32)key_code);
  key_msg->AddInt8("byte", key_code);
  key_msg->AddInt32("from_wheel", true);  // so that apps who want to handle
                                          // wheel events can ignore this event
  wmDevice->EnqueueMessage(key_msg);
  
  key_msg = new BMessage(B_KEY_UP);
  key_msg->AddInt64("when", now);
  key_msg->AddInt32("modifiers", current_info.modifiers);
  key_msg->AddInt32("key", key);

  key_msg->AddData("states", B_UINT8_TYPE, &current_info.key_states[0], 16);
//  key_msg->AddInt8("states", current_info.key_states);

  key_msg->AddInt32("raw_char", (int32)key_code);
  key_msg->AddInt8("byte", key_code);
  key_msg->AddInt32("from_wheel", true);
  wmDevice->EnqueueMessage(key_msg);
  
  return B_OK;
}
