/*
 * serial-tester.h
 *
 * header file for serial-tester
 */

//#include <Be.h>
// we need add-ons/input_server/InputServerDevice.h to stop the compiler
// from complaining that the base class BInputServerDevice has an
// incomplete type
#include <device/SerialPort.h>
#include <add-ons/input_server/InputServerDevice.h>
#include <List.h>
#include <OS.h>
#include <SupportDefs.h>
#include <interface/View.h>
#include <support/Debug.h>
#include <string.h>

#define LMB (1 << 0)
#define RMB (1 << 1)
#define MMB (1 << 2)
#define FMB (1 << 3)
#define B_QUATERNARY_MOUSE_BUTTON (B_TERTIARY_MOUSE_BUTTON << 1)

void do_something_with_it(unsigned char);
//int main(int, char *[]);
//
//class serial_application : public BApplication
//{
//  public:
//    serial_application(void);
//};

struct current_state
{
  int32 dx, dy;
  int32 buttons_old;
  int32 buttons_new;
  int32 wheel_change;
  int32 last_button_clicked;
  bigtime_t last_click_time;
  int32 clicks;
};

struct pnp_info
{
  struct {
    int major, minor;
  } version;
  char product_id[8];
  int16 checksum;
  char class_name[16];
  char driver_id[8];
  
};

// export this for the input_server
extern "C" _EXPORT BInputServerDevice *instantiate_input_device();

class WMInputDevice : public BInputServerDevice
{
  public:
    WMInputDevice();
    virtual ~WMInputDevice();

    virtual status_t InitCheck();
    virtual status_t SystemShuttingDown();

    virtual status_t Start(const char *device, void *cookie);
    virtual status_t Stop(const char *device, void *cookie);
    virtual status_t Control(const char *device,
                             void       *cookie,
                             uint32      command,
                             BMessage   *message);

  private:
    static BSerialPort *serial;
    static int32 do_it_serial(void *arg);
    static void notify_changes(void *);
    static void process_byte(unsigned char buffer);
    static void process_bytes(void *arg, unsigned char *buffer, int bytes_read);
    static void detect_and_synchronise(void);
    static void detect_protocol(unsigned char *, int, int, int);
    static status_t do_pnp(unsigned char *, int);
    static inline bigtime_t double_click_time(void);
    static void calculate_acceleration_table(int32 speed);
    static status_t send_key(void *arg, int8 key_code);
    static thread_id wm_thread;
    static bool wmActive;
    static struct current_state *state;
    static struct pnp_info *pnpinfo;
    static bigtime_t click_speed;
    static int32 mouse_speed;
    static mouse_map *current_mouse_map;
    static int32 *accelerated;
    static bool i_should_send_double_clicks_for_fmb_presses;
};

int32 do_it(void *);
