
//		Copyright © 1999		Matthew S. Chartier (mattc@ic.net)
//
//		This program is free software; you can redistribute it and/or modify
//		it under the terms of the GNU General Public License as published by
//		the Free Software Foundation; either version 1, or (at your option)
//		any later version.
//
//		This program is distributed in the hope that it will be useful,
//		but WITHOUT ANY WARRANTY; without even the implied warranty of
//		MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	See the
//		GNU General Public License for more details.
//
//		You should have received a copy of the GNU General Public License
//		along with this program; if not, write to the Free Software
//		Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
//


#ifndef _H_PARPORT
#define _H_PARPORT

#include <SupportDefs.h>
#include <KernelExport.h>

#ifdef __USERSPACE
#include "../../ioport/iolib.h"
#include <malloc.h>
#else
#include <KernelExport.h>
#include <ISA.h>

extern isa_module_info* GLB_bus;

#define read_io_8(x)			GLB_bus->read_io_8(x)
#define read_io_32(x)			GLB_bus->read_io_32(x)
#define write_io_8(x,y)			GLB_bus->write_io_8(x,y)
#define write_io_32(x,y)		GLB_bus->write_io_32(x,y)

#endif


/* structures */
struct parport
	{
	unsigned long	base;
	unsigned int	size;
	const char*		name;
	int				irq;
	int				dma;
	unsigned int	modes;
	sem_id			lock_sem;
	};	

struct pardevice
	{
	struct parport*	port;
	};	


/* definitions */

/* Change this to the appropriate parallel port in your configuration */
#define DEFAULT_IOPORT			0x378

#define ECONTROL				0x402
#define	CONFIGB					0x401
#define CONFIGA					0x400
#define	EPPDATA					0x4
#define EPPADDR					0x3
#define CONTROL					0x2
#define STATUS					0x1
#define DATA					0x0
#define PARPORT_MODE_PCSPP		0x0001
#define PARPORT_MODE_PCPS2		0x0002
#define PARPORT_MODE_PCEPP		0x0004
#define PARPORT_MODE_PCECP		0x0008
#define PARPORT_MODE_PCECPEPP	0x0010
#define PARPORT_MODE_PCECR		0x0020
#define PARPORT_MODE_PCECPPS2	0x0040



/* prototypes */

int 				parport_init(void);
struct parport* 	parport_getport(int index);
void 				parport_claimport(struct parport* port);
void 				parport_releaseport(struct parport* port);

/* --- */

void 				parport_pc_write_data(struct parport* pb,unsigned char d);
unsigned char 		parport_pc_read_data(struct parport* pb);
void 				parport_pc_write_control(struct parport* pb,unsigned char d);
unsigned char 		parport_pc_read_control(struct parport* pb);
void 				parport_pc_write_status(struct parport* pb,unsigned char d);
unsigned char 		parport_pc_read_status(struct parport* pb);
void 				parport_pc_write_econtrol(struct parport* pb,unsigned char d);
unsigned char 		parport_pc_read_econtrol(struct parport* pb);
void 				parport_pc_write_fifo(struct parport* pb,unsigned char d);
unsigned char 		parport_pc_read_fifo(struct parport* pb);
void 				parport_pc_write_epp(struct parport* pb,unsigned char d);
unsigned char 		parport_pc_read_epp(struct parport* pb);
int 				parport_pc_epp_clear_timeout(struct parport* pb);

void* 				allocMem(const char* name,unsigned long size);


#endif

