#	Makefile automatically created from project file
#	Don't forget to update if you change your header dependencies

#	Change this to set what compiler options you need
PREFIX = xpdfHeaders
CC = mwcc 
DEBUG = # -sym full
DEFINES = 
COPTS = $(DEFINES) -c -O5 -dialect cplus -prefix $(PREFIX) $(DEBUG)
PCOPTS = $(DEFINES)
LOPTS = -map $(TARGET).xMAP $(DEBUG)
COPYRES = copyres

#	This is the file to generate
TARGET = xpdf.be

#	This is the objects folder
OBJFOLDER = obj

#	main target
all:	$(OBJFOLDER) $(TARGET)

OBJ = \
	$(OBJFOLDER)/parseargs.o \
	$(OBJFOLDER)/GString.o \
	$(OBJFOLDER)/gmempp.o \
	$(OBJFOLDER)/gmem.o \
	$(OBJFOLDER)/gfile.o \
	$(OBJFOLDER)/BepdfApplication.o \
	$(OBJFOLDER)/PDFView.o \
	$(OBJFOLDER)/PDFWindow.o \
	$(OBJFOLDER)/BeOutputDev.o \
	$(OBJFOLDER)/HWindow.o \
	$(OBJFOLDER)/XRef.o \
	$(OBJFOLDER)/TextOutputDev.o \
	$(OBJFOLDER)/Stream.o \
	$(OBJFOLDER)/PSOutputDev.o \
	$(OBJFOLDER)/PDFDoc.o \
	$(OBJFOLDER)/Parser.o \
	$(OBJFOLDER)/Params.o \
	$(OBJFOLDER)/Page.o \
	$(OBJFOLDER)/OutputDev.o \
	$(OBJFOLDER)/Object.o \
	$(OBJFOLDER)/Link.o \
	$(OBJFOLDER)/Lexer.o \
	$(OBJFOLDER)/GfxState.o \
	$(OBJFOLDER)/GfxFont.o \
	$(OBJFOLDER)/Gfx.o \
	$(OBJFOLDER)/Error.o \
	$(OBJFOLDER)/Dict.o \
	$(OBJFOLDER)/Catalog.o \
	$(OBJFOLDER)/Array.o 

#	Include paths used
INC = -i- \
	-I/boot/home/projects/Hub\'s\ lib/ \
	-I/boot/home/projects/Hub\'s\ lib/ \
	-IBeXpdf/ \
	-I/boot/home/projects/Hub\'s\ lib/ \
	-Igoo/ \
	-Ixpdf/ \
	-I.

$(TARGET):	$(OBJ) BePDF.rsrc
	$(CC) $(LOPTS) -o $(TARGET) $(OBJ) /boot/develop/lib/ppc/start_dyn.o /boot/develop/lib/ppc/init_term_dyn.o /boot/develop/lib/ppc/glue-noinit.a
	$(COPYRES) BePDF.rsrc $(TARGET)

$(OBJFOLDER)/parseargs.o:	goo/parseargs.c \
	xpdfHeaders \
	goo/parseargs.h \
	goo/gtypes.h \
	$(PREFIX)
	$(CC) $(COPTS) -o $(OBJFOLDER)/parseargs.o $(INC) goo/parseargs.c

$(OBJFOLDER)/GString.o:	goo/GString.cc \
	xpdfHeaders \
	goo/GString.h \
	$(PREFIX)
	$(CC) $(COPTS) -o $(OBJFOLDER)/GString.o $(INC) goo/GString.cc

$(OBJFOLDER)/gmempp.o:	goo/gmempp.cc \
	xpdfHeaders \
	goo/gmem.h \
	$(PREFIX)
	$(CC) $(COPTS) -o $(OBJFOLDER)/gmempp.o $(INC) goo/gmempp.cc

$(OBJFOLDER)/gmem.o:	goo/gmem.c \
	xpdfHeaders \
	goo/gmem.h \
	$(PREFIX)
	$(CC) $(COPTS) -o $(OBJFOLDER)/gmem.o $(INC) goo/gmem.c

$(OBJFOLDER)/gfile.o:	goo/gfile.cc \
	xpdfHeaders \
	goo/gtypes.h \
	goo/gfile.h \
	goo/GString.h \
	$(PREFIX)
	$(CC) $(COPTS) -o $(OBJFOLDER)/gfile.o $(INC) goo/gfile.cc

$(OBJFOLDER)/BepdfApplication.o:	BeXpdf/BepdfApplication.cpp \
	xpdfHeaders \
	goo/gtypes.h \
	goo/gmem.h \
	xpdf/config.h \
	xpdf/XRef.h \
	xpdf/Stream.h \
	xpdf/Params.h \
	xpdf/Page.h \
	BeXpdf/PDFWindow.h \
	xpdf/PDFDoc.h \
	xpdf/OutputDev.h \
	xpdf/Object.h \
	xpdf/Link.h \
	/boot/home/projects/Hub\'s\ lib/HWindow.h \
	goo/GString.h \
	xpdf/Dict.h \
	xpdf/Catalog.h \
	BeXpdf/BepdfApplication.h \
	BeXpdf/BeOutputDev.h \
	xpdf/Array.h \
	$(PREFIX)
	$(CC) $(COPTS) -o $(OBJFOLDER)/BepdfApplication.o $(INC) BeXpdf/BepdfApplication.cpp

$(OBJFOLDER)/PDFView.o:	BeXpdf/PDFView.cpp \
	xpdfHeaders \
	BeXpdf/PDFView.h \
	$(PREFIX)
	$(CC) $(COPTS) -o $(OBJFOLDER)/PDFView.o $(INC) BeXpdf/PDFView.cpp

$(OBJFOLDER)/PDFWindow.o:	BeXpdf/PDFWindow.cpp \
	xpdfHeaders \
	goo/gtypes.h \
	goo/gmem.h \
	xpdf/XRef.h \
	xpdf/Stream.h \
	xpdf/Page.h \
	BeXpdf/PDFWindow.h \
	BeXpdf/PDFView.h \
	xpdf/PDFDoc.h \
	xpdf/OutputDev.h \
	xpdf/Object.h \
	xpdf/Link.h \
	/boot/home/projects/Hub\'s\ lib/HWindow.h \
	goo/GString.h \
	xpdf/Dict.h \
	xpdf/Catalog.h \
	BeXpdf/BepdfApplication.h \
	BeXpdf/BeOutputDev.h \
	xpdf/Array.h \
	$(PREFIX)
	$(CC) $(COPTS) -o $(OBJFOLDER)/PDFWindow.o $(INC) BeXpdf/PDFWindow.cpp

$(OBJFOLDER)/BeOutputDev.o:	BeXpdf/BeOutputDev.cpp \
	xpdfHeaders \
	goo/gtypes.h \
	goo/gmem.h \
	xpdf/Stream.h \
	xpdf/OutputDev.h \
	xpdf/Object.h \
	xpdf/GfxState.h \
	xpdf/GfxFont.h \
	goo/GString.h \
	xpdf/Dict.h \
	BeXpdf/BeOutputDev.h \
	xpdf/Array.h \
	$(PREFIX)
	$(CC) $(COPTS) -o $(OBJFOLDER)/BeOutputDev.o $(INC) BeXpdf/BeOutputDev.cpp

$(OBJFOLDER)/HWindow.o:	/boot/home/projects/Hub\'s\ lib/HWindow.cpp \
	xpdfHeaders \
	/boot/home/projects/Hub\'s\ lib/HWindow.h \
	$(PREFIX)
	$(CC) $(COPTS) -o $(OBJFOLDER)/HWindow.o $(INC) /boot/home/projects/Hub\'s\ lib/HWindow.cpp

$(OBJFOLDER)/XRef.o:	xpdf/XRef.cc \
	xpdfHeaders \
	goo/gtypes.h \
	goo/gmem.h \
	xpdf/XRef.h \
	xpdf/Stream.h \
	xpdf/Parser.h \
	xpdf/Object.h \
	xpdf/Lexer.h \
	goo/GString.h \
	xpdf/Error.h \
	xpdf/Dict.h \
	xpdf/Array.h \
	$(PREFIX)
	$(CC) $(COPTS) -o $(OBJFOLDER)/XRef.o $(INC) xpdf/XRef.cc

$(OBJFOLDER)/TextOutputDev.o:	xpdf/TextOutputDev.cc \
	xpdfHeaders \
	goo/gtypes.h \
	goo/gmem.h \
	xpdf/config.h \
	xpdf/TextOutputFontInfo.h \
	xpdf/TextOutputDev.h \
	xpdf/Stream.h \
	xpdf/OutputDev.h \
	xpdf/Object.h \
	xpdf/GfxState.h \
	xpdf/GfxFont.h \
	goo/GString.h \
	xpdf/Error.h \
	xpdf/Dict.h \
	xpdf/Array.h \
	$(PREFIX)
	$(CC) $(COPTS) -o $(OBJFOLDER)/TextOutputDev.o $(INC) xpdf/TextOutputDev.cc

$(OBJFOLDER)/Stream.o:	xpdf/Stream.cc \
	xpdfHeaders \
	goo/gtypes.h \
	goo/gmem.h \
	xpdf/config.h \
	xpdf/Stream.h \
	xpdf/Stream-CCITT.h \
	xpdf/Object.h \
	goo/GString.h \
	xpdf/Error.h \
	xpdf/Dict.h \
	xpdf/Array.h \
	$(PREFIX)
	$(CC) $(COPTS) -o $(OBJFOLDER)/Stream.o $(INC) xpdf/Stream.cc

$(OBJFOLDER)/PSOutputDev.o:	xpdf/PSOutputDev.cc \
	xpdfHeaders \
	goo/gtypes.h \
	goo/gmem.h \
	xpdf/config.h \
	xpdf/Stream.h \
	xpdf/Page.h \
	xpdf/PSOutputDev.h \
	xpdf/OutputDev.h \
	xpdf/Object.h \
	xpdf/GfxState.h \
	xpdf/GfxFont.h \
	goo/GString.h \
	xpdf/Error.h \
	xpdf/Dict.h \
	xpdf/Catalog.h \
	xpdf/Array.h \
	$(PREFIX)
	$(CC) $(COPTS) -o $(OBJFOLDER)/PSOutputDev.o $(INC) xpdf/PSOutputDev.cc

$(OBJFOLDER)/PDFDoc.o:	xpdf/PDFDoc.cc \
	xpdfHeaders \
	goo/gtypes.h \
	goo/gmem.h \
	xpdf/config.h \
	xpdf/XRef.h \
	xpdf/Stream.h \
	xpdf/Params.h \
	xpdf/Page.h \
	xpdf/PDFDoc.h \
	xpdf/OutputDev.h \
	xpdf/Object.h \
	xpdf/Link.h \
	goo/GString.h \
	xpdf/Error.h \
	xpdf/Dict.h \
	xpdf/Catalog.h \
	xpdf/Array.h \
	$(PREFIX)
	$(CC) $(COPTS) -o $(OBJFOLDER)/PDFDoc.o $(INC) xpdf/PDFDoc.cc

$(OBJFOLDER)/Parser.o:	xpdf/Parser.cc \
	xpdfHeaders \
	goo/gtypes.h \
	goo/gmem.h \
	xpdf/Stream.h \
	xpdf/Parser.h \
	xpdf/Object.h \
	xpdf/Lexer.h \
	goo/GString.h \
	xpdf/Error.h \
	xpdf/Dict.h \
	xpdf/Array.h \
	$(PREFIX)
	$(CC) $(COPTS) -o $(OBJFOLDER)/Parser.o $(INC) xpdf/Parser.cc

$(OBJFOLDER)/Params.o:	xpdf/Params.cc \
	xpdfHeaders \
	goo/gtypes.h \
	goo/gmem.h \
	goo/gfile.h \
	xpdf/Params.h \
	goo/GString.h \
	$(PREFIX)
	$(CC) $(COPTS) -o $(OBJFOLDER)/Params.o $(INC) xpdf/Params.cc

$(OBJFOLDER)/Page.o:	xpdf/Page.cc \
	xpdfHeaders \
	goo/gtypes.h \
	goo/gmem.h \
	xpdf/XRef.h \
	xpdf/Stream.h \
	xpdf/Params.h \
	xpdf/Page.h \
	xpdf/OutputDev.h \
	xpdf/Object.h \
	xpdf/Gfx.h \
	goo/GString.h \
	xpdf/Error.h \
	xpdf/Dict.h \
	xpdf/Array.h \
	$(PREFIX)
	$(CC) $(COPTS) -o $(OBJFOLDER)/Page.o $(INC) xpdf/Page.cc

$(OBJFOLDER)/OutputDev.o:	xpdf/OutputDev.cc \
	xpdfHeaders \
	goo/gtypes.h \
	goo/gmem.h \
	xpdf/Stream.h \
	xpdf/OutputDev.h \
	xpdf/Object.h \
	xpdf/GfxState.h \
	goo/GString.h \
	xpdf/Dict.h \
	xpdf/Array.h \
	$(PREFIX)
	$(CC) $(COPTS) -o $(OBJFOLDER)/OutputDev.o $(INC) xpdf/OutputDev.cc

$(OBJFOLDER)/Object.o:	xpdf/Object.cc \
	xpdfHeaders \
	goo/gtypes.h \
	goo/gmem.h \
	xpdf/XRef.h \
	xpdf/Stream.h \
	xpdf/Object.h \
	goo/GString.h \
	xpdf/Error.h \
	xpdf/Dict.h \
	xpdf/Array.h \
	$(PREFIX)
	$(CC) $(COPTS) -o $(OBJFOLDER)/Object.o $(INC) xpdf/Object.cc

$(OBJFOLDER)/Link.o:	xpdf/Link.cc \
	xpdfHeaders \
	goo/gtypes.h \
	goo/gmem.h \
	xpdf/Stream.h \
	xpdf/Object.h \
	xpdf/Link.h \
	goo/GString.h \
	xpdf/Error.h \
	xpdf/Dict.h \
	xpdf/Array.h \
	$(PREFIX)
	$(CC) $(COPTS) -o $(OBJFOLDER)/Link.o $(INC) xpdf/Link.cc

$(OBJFOLDER)/Lexer.o:	xpdf/Lexer.cc \
	xpdfHeaders \
	goo/gtypes.h \
	goo/gmem.h \
	xpdf/Stream.h \
	xpdf/Object.h \
	xpdf/Lexer.h \
	goo/GString.h \
	xpdf/Error.h \
	xpdf/Dict.h \
	xpdf/Array.h \
	$(PREFIX)
	$(CC) $(COPTS) -o $(OBJFOLDER)/Lexer.o $(INC) xpdf/Lexer.cc

$(OBJFOLDER)/GfxState.o:	xpdf/GfxState.cc \
	xpdfHeaders \
	goo/gtypes.h \
	goo/gmem.h \
	xpdf/Stream.h \
	xpdf/Object.h \
	xpdf/GfxState.h \
	goo/GString.h \
	xpdf/Dict.h \
	xpdf/Array.h \
	$(PREFIX)
	$(CC) $(COPTS) -o $(OBJFOLDER)/GfxState.o $(INC) xpdf/GfxState.cc

$(OBJFOLDER)/GfxFont.o:	xpdf/GfxFont.cc \
	xpdfHeaders \
	goo/gtypes.h \
	goo/gmem.h \
	goo/gfile.h \
	xpdf/config.h \
	xpdf/Stream.h \
	xpdf/Params.h \
	xpdf/Object.h \
	xpdf/GfxFont.h \
	goo/GString.h \
	xpdf/FontInfo.h \
	xpdf/Error.h \
	xpdf/Dict.h \
	xpdf/Array.h \
	$(PREFIX)
	$(CC) $(COPTS) -o $(OBJFOLDER)/GfxFont.o $(INC) xpdf/GfxFont.cc

$(OBJFOLDER)/Gfx.o:	xpdf/Gfx.cc \
	xpdfHeaders \
	goo/gtypes.h \
	goo/gmem.h \
	xpdf/Stream.h \
	xpdf/Parser.h \
	xpdf/Params.h \
	xpdf/OutputDev.h \
	xpdf/Object.h \
	xpdf/Lexer.h \
	xpdf/GfxState.h \
	xpdf/GfxFont.h \
	xpdf/Gfx.h \
	goo/GString.h \
	xpdf/Error.h \
	xpdf/Dict.h \
	xpdf/Array.h \
	$(PREFIX)
	$(CC) $(COPTS) -o $(OBJFOLDER)/Gfx.o $(INC) xpdf/Gfx.cc

$(OBJFOLDER)/Error.o:	xpdf/Error.cc \
	xpdfHeaders \
	goo/gtypes.h \
	xpdf/Params.h \
	xpdf/Error.h \
	$(PREFIX)
	$(CC) $(COPTS) -o $(OBJFOLDER)/Error.o $(INC) xpdf/Error.cc

$(OBJFOLDER)/Dict.o:	xpdf/Dict.cc \
	xpdfHeaders \
	goo/gtypes.h \
	goo/gmem.h \
	xpdf/XRef.h \
	xpdf/Stream.h \
	xpdf/Object.h \
	goo/GString.h \
	xpdf/Dict.h \
	xpdf/Array.h \
	$(PREFIX)
	$(CC) $(COPTS) -o $(OBJFOLDER)/Dict.o $(INC) xpdf/Dict.cc

$(OBJFOLDER)/Catalog.o:	xpdf/Catalog.cc \
	xpdfHeaders \
	goo/gtypes.h \
	goo/gmem.h \
	xpdf/Stream.h \
	xpdf/Page.h \
	xpdf/Object.h \
	xpdf/Link.h \
	goo/GString.h \
	xpdf/Error.h \
	xpdf/Dict.h \
	xpdf/Catalog.h \
	xpdf/Array.h \
	$(PREFIX)
	$(CC) $(COPTS) -o $(OBJFOLDER)/Catalog.o $(INC) xpdf/Catalog.cc

$(OBJFOLDER)/Array.o:	xpdf/Array.cc \
	xpdfHeaders \
	goo/gtypes.h \
	goo/gmem.h \
	xpdf/Stream.h \
	xpdf/Object.h \
	goo/GString.h \
	xpdf/Dict.h \
	xpdf/Array.h \
	$(PREFIX)
	$(CC) $(COPTS) -o $(OBJFOLDER)/Array.o $(INC) xpdf/Array.cc


#	Prefix rule
$(PREFIX):	$(PREFIX).pch++
	$(CC) $(PCOPTS) -precompile $(PREFIX) $(PREFIX).pch++

#	Create the folder
$(OBJFOLDER):
	mkdir $(OBJFOLDER)

clean:
	-rm -rf $(OBJFOLDER) $(TARGET) $(TARGET).xMAP $(TARGET).xSYM

