/*
	Copyright (c) 2002, Thomas Kurschel
	based on Screen Preferences Panel written for OpenBeOS by Rafael Romo


	Part of Radeon Screen Preferences
		
	Application object
*/

// Screen V0.9 build 1 by Rafael Romo for the OpenBeOS Preferences team.
// web.tiscalinet.it/rockman
// rockman@tiscalinet.it

#include <Application.h>
#include <Alert.h>

//#include <cstdio>
//#include <cstring>

#include "ScreenApplication.h"
#include "ScreenWindow.h"
#include "ScreenSettings.h"
#include "Constants.h"

ScreenApplication::ScreenApplication()
	: BApplication("application/x-vnd.RR-SCRN")
{
	fScreenWindow = new ScreenWindow(new ScreenSettings());
}

void ScreenApplication::AboutRequested()
{
	BAlert *AboutAlert = new BAlert("About", "Radeon Screen by Rafael Romo, partially rewritten by Thomas Kurschel\nThe OBOS place to configure your monitor",
	"Ok", NULL, NULL, 
	B_WIDTH_AS_USUAL, B_OFFSET_SPACING, B_INFO_ALERT);
	AboutAlert->SetShortcut(0, B_OK);
	AboutAlert->Go();
}


int main()
{
	ScreenApplication	MyApplication;
	
	MyApplication.Run();
	
	return(0);
}
