/*
Open Tracker License

Terms and Conditions

Copyright (c) 1991-2000, Be Incorporated. All rights reserved.

Permission is hereby granted, free of charge, to any person obtaining a copy of
this software and associated documentation files (the "Software"), to deal in
the Software without restriction, including without limitation the rights to
use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
of the Software, and to permit persons to whom the Software is furnished to do
so, subject to the following conditions:

The above copyright notice and this permission notice applies to all licensees
and shall be included in all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF TITLE, MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
BE INCORPORATED BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF, OR IN CONNECTION
WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

Except as contained in this notice, the name of Be Incorporated shall not be
used in advertising or otherwise to promote the sale, use or other dealings in
this Software without prior written authorization from Be Incorporated.

Tracker(TM), Be(R), BeOS(R), and BeIA(TM) are trademarks or registered trademarks
of Be Incorporated in the United States and other countries. Other brand product
names are registered trademarks or trademarks of their respective holders.
All rights reserved.
*/

//	application list
//	top level at window
//	in expanded mode horizontal and vertical

#ifndef EXPANDOMENUBAR_H
#define EXPANDOMENUBAR_H

#include <MenuBar.h>

class BBitmap;
class TBarView;
class TBarMenuTitle;
class TTeamMenuItem;

//#define DOUBLECLICKBRINGSTOFRONT

enum drag_and_drop_selection {
	kNoSelection,
	kBeMenuSelection,
	kAppMenuSelection,
	kAnyMenuSelection
};

class TExpandoMenuBar : public BMenuBar {
public:
	TExpandoMenuBar(TBarView *bar, BRect frame, const char *name, bool vertical,
		bool drawLabel = true);
	
	virtual void AttachedToWindow();
	virtual void DetachedFromWindow();
	virtual void MessageReceived(BMessage *message);
	virtual void MouseDown(BPoint where);
	virtual void MouseMoved(BPoint where, uint32 code, const BMessage *);
	
	virtual void Draw(BRect update);
	void DrawBackground(BRect update);
	
	bool InBeMenu(BPoint) const;
	TTeamMenuItem *ItemAtPoint(BPoint loc);
	void SetItemStates(bool favorwhich);
	
	void CheckItemSizes(int32 delta);
	
	menu_layout MenuLayout() const;
	
	void CheckForSizeOverrun();
	
private:
	void AddTeam(BList *team, BBitmap *icon, char *name, char *signature);
	void AddTeam(team_id team, const char *signature);
	void RemoveTeam(team_id team, bool partial);
	
	void Hilite(drag_and_drop_selection which);
	
	bool fVertical;
	bool fOverflow;
	bool fDrawLabel;
	bool fIsScrolling;
	
	TBarView *fBarView;
	int32 fFirstApp;
	
	TBarMenuTitle *fBeMenuItem;
	TTeamMenuItem *fSeparatorItem;
	
#ifdef DOUBLECLICKBRINGSTOFRONT
	int32 fLastClickItem;
	bigtime_t fLastClickTime;
#endif
};

#endif /* EXPANDOMENUBAR_H */

