/*
Open Tracker License

Terms and Conditions

Copyright (c) 1991-2000, Be Incorporated. All rights reserved.

Permission is hereby granted, free of charge, to any person obtaining a copy of
this software and associated documentation files (the "Software"), to deal in
the Software without restriction, including without limitation the rights to
use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
of the Software, and to permit persons to whom the Software is furnished to do
so, subject to the following conditions:

The above copyright notice and this permission notice applies to all licensees
and shall be included in all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF TITLE, MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
BE INCORPORATED BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF, OR IN CONNECTION
WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

Except as contained in this notice, the name of Be Incorporated shall not be
used in advertising or otherwise to promote the sale, use or other dealings in
this Software without prior written authorization from Be Incorporated.

Tracker(TM), Be(R), BeOS(R), and BeIA(TM) are trademarks or registered trademarks
of Be Incorporated in the United States and other countries. Other brand product
names are registered trademarks or trademarks of their respective holders.
All rights reserved.
*/

#ifndef __BITS__
#define __BITS__


#include <Locker.h>
#include <Resources.h>
#include <Mime.h>
#include <image.h>

class BBitmap;

namespace BPrivate {

enum {
	kResAppIcon = 1000,
	kResFileIcon = 1001,
	kResFolderIcon = 1,
	kResTrashIcon = 1003,
	kResTrashFullIcon = 1004,
	kResQueryIcon = 2,
	kResQueryTemplateIcon = 4,
	kResPrinterIcon = 1007,
	kResBarberPoleBitmap = 1038,
	kResFloppyIcon = 1011,
	kResHardDiskIcon = 3,
	kResCDIcon = 1013,
	kResBeBoxIcon = 1014,
	kResBookmarkIcon = 1015,
	kResPersonIcon = 1016,
	kResBrokenLinkIcon = 1017,
	kResDeskIcon = 1018,
	kResHomeDirIcon = 1019,
	kResBeosFolderIcon = 1020,
	kResBootVolumeIcon = 1021,
	kResFontDirIcon = 1022,
	kResAppsDirIcon = 1023,
	kResPrefsDirIcon = 1024,
	kResMailDirIcon = 1025,
	kResQueryDirIcon = 1026,
	kResSpoolFileIcon = 1027,
	kResGenericPrinterIcon = 1028,
	kResDevelopDirIcon = 1029,
	kResDownloadDirIcon = 1030,
	kResPersonDirIcon = 1031,
	kResUtilDirIcon = 1032,
	kResConfigDirIcon = 1033,
	kResMoveStatusBitmap = 1039,
	kResCopyStatusBitmap = 1040,
	kResTrashStatusBitmap = 1041
};


class BImageResources
{
	// convenience class for accessing 
public:
	BImageResources(void *memAddr);
	~BImageResources();
	
	BResources *ViewResources();
	const BResources *ViewResources() const;
	
	status_t FinishResources(BResources *) const;
	
	const void *LoadResource(type_code type, int32 id,
		size_t *outSize) const;
	const void *LoadResource(type_code type, const char *name,
		size_t *outSize) const;
		// load a resource from the Tracker executable, just like the
		// corresponding functions in BResources.  These methods are
		// thread-safe.
	
	status_t GetIconResource(int32 id, icon_size size, BBitmap *dest) const;
		// this is a wrapper around LoadResource(), for retrieving
		// B_LARGE_ICON and B_MINI_ICON ('ICON' and 'MICN' respectively)
		// resources.  this does sanity checking on the found data,
		// and if all is okay blasts it into the 'dest' bitmap.

 	status_t GetBitmapResource(type_code type, int32 id, BBitmap **out) const;
 		// this is a wrapper around LoadResource(), for retrieving
 		// arbitrary bitmaps.  the resource with the given type and
 		// id is looked up, and a BBitmap created from it and returned
 		// in <out>.  currently it can only create bitmaps from data
 		// that is an archived bitmap object.

private:
	image_id find_image(void *memAddr) const;
	
	mutable BLocker fLock;
	BResources fResources;
};

 		

extern _IMPEXP_TRACKER BImageResources* GetTrackerResources();

} // namespace BPrivate

using namespace BPrivate;

#endif
