/*
	
	Nt.cpp
	
	Nt une application qui met le BeOS à l'heure via
	les serveur de Temps disponible sur le net.
	(c)oderight 1997, 1999 par Tsk aka Hirlimann Ludovic
	softkid@multimania.com
 *		This program is free software; you can redistribute it and/or
 *		modify it under the terms of the GNU General Public License
 *		as published by the Free Software Foundation; either version
 *		2 of the License, or (at your option) any later version.

*/
/* historique :
	09/03/1998 changé le texte de l'about box 
	7/17/2000 Mr. Ludovic was kind enough to transfer ownership of Ntp to me, so I'll be updating it from now on. I left
		the comments in French, so I suggest using http://babelfish.altavista.com/ for translating them. When I get a chance
		I'll put in the English translations as well, but Mr. Ludovic's code was pretty straight-forward for the most part.
		I would have written it differently of course, but at this time I don't feel it necessary to do a major rewrite.
		Perhaps in the future I'll save his network code and ditch the rest. Stay tuned. ;)
			Seth Flaxman - seth@abisoft.com - www.abisoft.com
*/
#include <NetKit.h>
#include <StorageKit.h>
#include <string.h>
#include "NtWindow.h"
#include "NtView.h"
#include "Nt.h"
#include "ntpmagic.h"

#undef LUDODEBUG	 // mettre à 1 pour avoir les sorties sur le terminal.

int main()
{	
	NtApplication *myApplication;

	myApplication = new NtApplication();
	myApplication->Run();
	
	delete(myApplication);
	return(0);
}
void NtApplication::ReadyToRun(void)
{
	BRect			aRect;
	BPath			chemin;
	char			*leser;
	unsigned char	taille;
	
	if(islinedriven)
		PostMessage(B_QUIT_REQUESTED);
	else
	{
		if (find_directory(B_COMMON_SETTINGS_DIRECTORY,&chemin)==B_NO_ERROR)
		{
			chemin.Append(DOSSIER_PREF);
			//chemin.Append("/");
			// chercher le dossier hms ...
			if (chemin.SetTo(chemin.Path(),FICHIER_PREF)==B_OK)
			{	
				#ifdef LUDODEBUG
				printf("%s\n",chemin.Path());
				#endif
				pref= new BFile();
				printf("%s\n", chemin.Path());
				if(pref->SetTo(chemin.Path(),B_READ_WRITE)!=B_OK)
				{
					//Alert("Can't Open the preference File!","");
					delete pref;
					pref=NULL;
				}				
			}
			else
			{
				pref=NULL;
				#ifdef LUDODEBUG
				Alert("Can't Find the preference File!","");
				#endif
			}
		}
		/* bien on commence par rechercher les preférences et
		mettre le BFile qui va bien à la valeur qui va bien */
		#ifdef LUDODEBUG
		printf("pref==%d\n",pref);
		#endif
		// set up a rectangle and instantiate a new window

		aRect.Set(0, 0, be_plain_font->StringWidth("Server Address:") * 3.5, 160);
		aView = new NtView(aRect, "Networktime");

		aRect.Set(100, 80, be_plain_font->StringWidth("Server Address:") * 3.5 + 100, 240);
		aWindow = new NtWindow(aRect, aView);

		if(pref==NULL)
			leser=NULL;
		else
		{
		/* lire l'adresse dans les préférences */
			pref->Seek(0,SEEK_SET);	/*début du fichier */
			pref->Read(&taille,sizeof(unsigned char));
			#ifdef LUDODEBUG
			printf("Taille== %d\n",taille);
			#endif
			leser=new char[taille+1];
			leser[taille]=0;
			pref->Read(leser,taille); /* hop lecture de l'adresse du serveur */
		}	
		if(leser == NULL)	
			aWindow->Init("bigben.cac.washington.edu");
		else
			aWindow->Init(leser);
	
		// set up a rectangle and instantiate a new view
		// view rect should be same size as window rect but with left top at (0, 0)
	
		// add view to window
		aWindow->AddChild(aView);
	
		// make window visible
		aWindow->Show();
	}
}

void NtApplication::Alert(char *letyped, char *info)
{
	char *temp;
	// added for v 0.9
	temp=new char[strlen(letyped)+strlen(info)+1];
	strcpy(temp,letyped);
	strcat(temp,info);
	BAlert *the_alert = new BAlert("",letyped, "OK",NULL,NULL,B_WIDTH_AS_USUAL,B_STOP_ALERT);
	the_alert->Go();
	
}

NtApplication::NtApplication()
		  		  : BApplication(APP_SIGN)
{
	
	#ifdef LUDODEBUG
	printf("création du socket\n");
	#endif
	
	islinedriven= false;	// vrai ssi ligne de commande
	lecrochet = socket(AF_INET,SOCK_DGRAM,0);
	//printf("Errno == %d\n",h_errno);
	if(lecrochet<0)
	{
		//1999-02-10 no need to LUDODEBUG this so You can always know what's going ON
		//#ifdef LUDODEBUG
		printf("Erreur Creating socket : %d\n",h_errno);
		//#endif
		/*
		on quitte */
		be_app->PostMessage(B_QUIT_REQUESTED);
	}
//	/* Initialiser le port de reception via Bind()*/
//
//	// taken in the unix-socket-faq
//	memset((char*)&client,0,sizeof(client));
//	client.sin_family=AF_INET;
//	client.sin_addr.s_addr=htonl(INADDR_ANY);
//	client.sin_port=htons(NTP_PORT);
//	if(bind(lecrochet,(struct sockaddr *) &client, sizeof(client))<0)
//	{
//		#ifdef LUDODEBUG
//		printf("Erreur à Bind()n");
//		#endif
//		be_app->PostMessage(B_QUIT_REQUESTED);
//	}	

}
/* Gestion de la sauvegarde
*/
void NtApplication::MessageReceived(BMessage *message)
{
	switch(message->what)
	{
		case ACTION_MESSAGE:
			/* Il y a un peu d'Overload notament au niveau
			des messages, mais c'est + BeLike. Et puis ainsi
			je controle mieux ...
			*/
			{	
				Mettrea(aWindow->Donneserveur()); // je pourrais mettre un thread ?
				break;
			}
		case SAVE_PREFS :
			{
				Saveprefs();
				break;	// a voir Ultérieurement
			}
		default:
			BApplication::MessageReceived(message);
			break;
	}
}
void NtApplication::ArgvReceived(int32 argc,char **argv)
{
	// compter le nombre d'argument 
	// mettre a l'heure et quitter
	if (argc >2)
	{
		printf("Usage :\n NetworkTime server_to_fetch_time_from\n");
		PostMessage(B_QUIT_REQUESTED);
	}
	else
	{
			//creation du socket puis mise à l'heure du systeme
			if(argc==2)
			{
			islinedriven=true;	
			if (!strcmp(argv[1],"-help"))
			{
				printf("Usage :\n NetworkTime server_to_fetch_time_from\n");	
				PostMessage(B_QUIT_REQUESTED);
			}
			else
				Mettrea(argv[1]);		
			}
	}
 
}
void NtApplication::Mettrea(char	*tmp)
{	
	hostent	*infoserveur;	// caractéristique du serveur
	struct sockaddr_in	d;
	//long	tim;
	paquet	mess,recu;
	int	i,j, ret;
	
	//1999-02-10
	fd_set  elcroch;
	struct timeval timeout;
	
	timeout.tv_sec=2;
	timeout.tv_usec=0;
	// timeout for recefrom set to 2.0 seconds
	
	FD_ZERO(&elcroch);
	FD_SET(lecrochet,&elcroch);
	
	/* Ici je me connecte sur le serveur
		Et j'envoi les requetes necessaires
	*/
		
	/* nom de site du serveur ntp qui à une
	longueur maximum de 64 char
	*/
	//tmp = new char[MAXHOSTNAMELEN];	
	//tmp=strdup(aWindow->Donneserveur());
	
	#ifdef LUDODEBUG
	printf("Nom du serveur %s \n",tmp);
	printf("gethostbyname()\n");
	#endif
	
	if(!islinedriven) //pas de fenetre quand ligne de commande
	{
	aWindow->Reset();
	
	// 16081997: Attention Gérer les Erreurs Réseaux ...
	// ie comment gerer Host Introuvable ????
	aWindow->Gauche("Connecting to server");
	}
	infoserveur = gethostbyname(tmp);
	if(infoserveur != NULL)	// le serveur existe
		{
			/* on régle les parametres de la connexion
			*/
			if(!islinedriven)
			{
			aWindow->Progres(25.0);
			}
			d.sin_family = AF_INET;
			d.sin_port = htons(NTP_PORT);
			d.sin_addr.s_addr = *(unsigned long*)infoserveur->h_addr_list[0];
		
			
			/* Rédaction du message à envoyer au serveur
				Directement pompée de ntapdate.
			*/
			mess.li_vn_mode=PKT_LI_VN_MODE(LEAP_NOTINSYNC,3,MODE_CLIENT);
			mess.stratum=1;
			mess.precision=NTPDATE_PRECISION;
			mess.rootdelay=htonl(NTPDATE_DISTANCE);
			mess.rootdispersion=htonl(NTPDATE_DISP);
			mess.refID=htonl(NTPDATE_REFID);
			mess.org1=0;
			mess.org2=0;
			mess.reftime1=0;
			mess.reftime2=0;
			mess.rec1=0;
			mess.rec2=0;
			mess.xm2=0;
			/* BeOS compte le temps depuis le 1er Janvier 1970 00:00 alors
			que sur le Net le temps se compte depuis le 1er Janvier 1900 00:00
			d'ou cette petite magouille
			*/
			mess.xm1=htonl(real_time_clock()+(long)DIFF_NTP_BeOS);//BeOS compte a partir
															// du 1er Janvier 1970
			/* on envoi le message au serveur ntp
			*/
			#ifdef LUDODEBUG
			printf("DIFF_NTP_BeOS == %x ",(uint32)DIFF_NTP_BeOS);
			printf("Time == %x\n",mess.xm1);
			mess.xm1=(mess.xm1+(uint32)DIFF_NTP_BeOS);
			printf("Add =%x\n",mess.xm1);
			printf("sendto\n");
			
			#endif
			if(!islinedriven)
			 aWindow->Gauche("Sending Request");
			 //1999-02-11
			 // ajout du test sur le send.
			if((i=sendto(lecrochet,(char*)&mess,TAILLE_PAQUET,0,(struct sockaddr *)&d, sizeof(d)))<0)
			{
			  if(!islinedriven)
			   	printf("Can't send Request to server\n");
			  else
			   Alert("Can't send Request to server\n","");		
			}
			else // sendto
			{
			 // Ok maintenant il n'y a plus qu'a attendre
			 if(!islinedriven)
			  aWindow->Progres(25.0);
			 #ifdef LUDODEBUG
			 printf("%d octets envoyes\n",i);
			 //printf("%d message erreur\n",errno);
			 #endif
			 /* Test grandeur Nature ici:
			 	ben ca plante la BeBox ???
			 */
			 //BON LIRE LA DOC POUR RECEIVE ..... C'est LA que ca merde
			 // NOTE : REECRIRE COMPLETEMENT CETTE PARTIE !!!!!
			 // PRISE EN COMPTE QUE L'ON ENVOIE QUATRE REQUETE ... + tard :)
			 // reception : Un thread ... !!!! (comme ca on peut emetre et
			 // recevoir SIMULTANEMENT !!!) De toute Façon le thread est
			 // necessaire lorsqu'il y a plusieurs requetes ....
			 // mais je le ferais dans la version 0.2
		     //	delete []msg;
			 j=sizeof(struct sockaddr_in); // J'ai bien fait de relire la Doc
			 #ifdef LUDODEBUG
			 printf("Attention Receive :\n");
			 #endif
			 if(!islinedriven)
			  aWindow->Gauche("Waiting for Reply");
			 
			 // 1999-02-08 mettre un select avec Timeout ICI .....
			 if((ret=select(lecrochet+1,&elcroch,NULL,NULL,&timeout))>0)
			 {
			  i=recvfrom(lecrochet,(char *)&recu,sizeof(recu),0,(struct sockaddr *)&d,&j);
			  if(!islinedriven)
			  { 
			    aWindow->Progres(25.0);
			    aWindow->Gauche("Updating Clock");
			  }
			  set_real_time_clock(ntohl(recu.xm1)-(uint32)DIFF_SERVER); // et voila ;;;
			 // attention set-real-time_clock marchais mieux
			
			 //tim=ntohl(recu.xm1)-(long)DIFF_NTP_BeOS;
            //	stime(&tim);
			  #ifdef LUDODEBUG
			  printf("recu %d octets du serveur\n",i);
			  printf("Ben le resultat de mon get : %x\n",recu.xm1);
			  #endif
			  //printf(msg);
			  if(!islinedriven)
			   aWindow->Progres(25.0);
			  }
			  else // celui du select
			  {
			  	if (ret == 0)
			  		if(islinedriven)
			  		 printf("Timeout, no anwser from the server\n");
			  		else // islinedriven
			  		 Alert("Timeout, no anwser from the server\n","");
			  }
			  if(!islinedriven)
			    aWindow->Gauche("Done");
		}
	}
	else
	{
		if(islinedriven== true)
		printf("Erreur at Gethostbyname()\n");
		else
		Alert("Erreur at Gethostbyname()\n","");
	}
	 // Ici gestion du fait que le serveur est inconnu ??
		/* Si je delete pas ce petit crétin ben je plante mon appli complete */
//	delete []tmp; // ne pas oublier :)
	//delete []msg;
	/* La Fermeture du socket se fait lors de la destruction
		de l'application (ie B_ABOUT_REQUESTED)
	*/
	//printf("fermeture du socket\n");
	//closesocket(lecrochet);
	#ifdef LUDODEBUG
	printf("Fin de Mettrea\n");
	#endif	
}

/* Bon pour se faire mousser un peu
*/
void NtApplication::AboutRequested(void)
{
	BAlert *the_alert = new BAlert("","Ntp Client \nFreeware\n(c)1997,1999 Hirlimann Ludovic\nsoftkid@multimania.com\nhttp://www.multimania.com/softkid\nModified on 7/10/2000 by Seth Flaxman\nseth@abisoft.com\nhttp://www.abisoft.com/", "OK");
	the_alert->Go();
}

/* Sauvegarde des preférences */
void NtApplication::Saveprefs(void)
{
	BPath	sentier;
	BDirectory rep;
	BDirectory	rep2;
	char	*add;
	unsigned char taille;
	/* verifier que le fichier n'est pas déja ouvert 
	 puis si besoin est l'ouvrir sinon il faut tjs le remplir */
	if(pref==NULL)
	{
		/* cas où il faut créer le fichier */
		find_directory(B_COMMON_SETTINGS_DIRECTORY,&sentier);
		printf("sentier.Path()= %s\n",sentier.Path());
		sentier.Append(DOSSIER_PREF);
		//sentier.Append("/");
		printf(sentier.Path());
		rep.SetTo(sentier.Path());
		if(rep.CreateDirectory(sentier.Path(), &rep2)!=B_OK)
			printf("Creation du repertoire a achoué\n");	
		printf("%s\n", sentier.Path());
		//sentier.Unset();
//		sentier.SetTo(&rep);
		
//		sentier.Append(FICHIER_PREF);
		pref= new BFile();
		#ifdef LUDODEBUG
		printf(sentier.Path());
		#endif
		if(rep2.CreateFile(FICHIER_PREF,pref)!=B_NO_ERROR)
			printf("CreateFile a echoue\n");
		//pref=new BFile(&rep,FICHIER_PREF,B_READ_WRITE);
		#ifdef LUDODEBUG
		printf("le fichier n'existe pas \n");
		#endif
	}
	else
	{
		/* le fichier existe */
		pref->Seek(0,SEEK_SET);
	}
	/* maintenant on recupère la taille de la chaîne qui
	contient l'adresse de notre serveur */
	add=aWindow->Donneserveur();
	#ifdef LUDODEBUG
	printf(add);
	#endif
	taille=(unsigned char)strlen(add);
	pref->Write(&taille,sizeof(taille));
	pref->Write(add,taille);
}