#  Copyright 1999 by Donn Cave, Seattle, Washington, USA.
#  All rights reserved.  Permission to copy, modify and distribute this
#  material is hereby granted, without fee, provided that the above
#  copyright notice appear in all copies.
#
#        Scrolling list.
#
import string

from BListItem import BListItem
from BListView import BListView
import BMessage
from BMenu import BMenu
from BMenuBar import BMenuBar
from BMessenger import BMessenger
from BMenuItem import BMenuItem
from BScrollView import BScrollView
from BStringView import BStringView
from BWindow import BWindow

from errpt import LastChanceLooper

import configure
from core import core
from fprompt import FPrompt
from queue import CallQueue

from InterfaceKit import B_FANCY_BORDER,B_NO_BORDER,B_PLAIN_BORDER,B_NAVIGABLE,B_WILL_DRAW,B_NOT_RESIZABLE,B_NOT_ZOOMABLE,B_TITLED_WINDOW,B_FOLLOW_ALL,B_FOLLOW_LEFT,B_FOLLOW_TOP
from AppKit import B_QUIT_REQUESTED

#
#  Draw text lines in BListView, with column aligned fields.
#
class TabItem(BListItem):
	nocolor = (230, 230, 230, 0)
	slecolor = (0, 200, 230, 0)
	drawcolor = (0, 0, 0, 0)
	def __init__(self, fields):
		self.fields = fields
		BListItem.__init__(self)
	def colorpick(self, slct):
		if slct:
			bg = self.slecolor
		else:
			bg = self.nocolor
		return self.drawcolor, bg
	def DrawItem(self, owner, frame, complete):
		slct = self.IsSelected()
		foreground, background = self.colorpick(slct)
		if complete or not background is self.nocolor:
			owner.SetHighColor(background)
			owner.FillRect(frame)
		owner.SetLowColor(background)
		owner.SetHighColor(foreground)
		x = frame[0] + 4.0
		y = frame[3] - 2.0
		for i in range(len(self.fields.value)):
			if self.fields.width[i]:
				owner.MovePenTo(x, y)
				s = self.fields.value[i]
				if not s:
					s = ''
				w = self.fields.width[i]
				wx = w - 8.0
				sl = len(s)
				wl = owner.StringWidth(s)
				if wl > wx:
					d = int(wx/wl * sl)
					if d >= sl:
						s = s[:-1]
					else:
						s = s[:d]
				owner.DrawString(s)
				x = x + w

#  List of selectable items.
#
class ListView(BListView):
	def __init__(self, list, rect, name, top, itemdraw, msg):
		l, t, r, b = rect
		BListView.__init__(self, (l, t + top, r, b), name, 1, B_FOLLOW_ALL)
		self.list = list
		self.itemdraw = itemdraw
		f = self.GetFont()
		h = f.GetHeight()
		h = h[0] + h[1] + h[2]
		h = float(int(h + 0.5)) + 1.0
		ww = 100.0
		wh = 4.0
		for i in list:
			item = self.itemdraw(i)
			self.AddItem(item)
			wh = wh + h
		self.listlen = len(list)
		if wh > 400.0:
			wh = 400.0
		elif wh < 40.0:
			wh = 40.0  # Guess at minimum for thumbs
		ww = 16.0
		if len(list) > 0:
			for i in list[0].width:
				ww = ww + i
		else:
			ww = 200.0
		self.ResizeTo(ww, wh)
		self.SetInvocationMessage(msg)
		low = self.itemdraw.nocolor
		self.SetViewColor(low)
		self.SetLowColor(low)
	def insert(self, list):
		for i in range(len(list)):
			d = list[i]
			item = self.itemdraw(d)
			self.AddItem(item, i)
	def extend(self):
		for i in range(self.listlen, len(self.list)):
			item = self.list[i]
			item = self.itemdraw(item)
			self.AddItem(item, i)
		self.listlen = len(self.list)
	def jump(self, index):
		self.Select(index)
		self.ScrollToSelection()

#  List Window.
#
#  Attributes used from other modules:
#    damage, fail, update, run.
#
class ScrollWindow(CallQueue, LastChanceLooper, BWindow):
	wzx0 = 80.0
	wzy0 = 60.0
	wzlistxy = 0.0
	wzitemdraw = TabItem
	def wzinit(self, name, list):
		frame = configure.getframe(name)
		if frame:
			l, t, r, b = frame
		else:
			l = ScrollWindow.wzx0
			t = ScrollWindow.wzy0
			ScrollWindow.wzx0 = l + 10.0
			ScrollWindow.wzy0 = t + 10.0
		r = l + 100.0
		b = t + 100.0
		frame = (l, t, r, b)
		BWindow.__init__(self, frame, name, B_TITLED_WINDOW,
			B_NOT_ZOOMABLE)
		self.__name = name
		self.wzscrollview = None
		self.wzlistview = None
		if list:
			self.__pre = None
			self.wzupdate(list)
		else:
			l, t, r, b = self.Bounds()
			self.__pre = BStringView((l, t, r, b), 'temp',
				'retrieving')
			self.AddChild(self.__pre)
		#  qzinit will block until thread runs!
		self.Show()
		self.qzinit(BWindow)
	def wzupdate(self, list):
		if not self.__pre is None:
			self.RemoveChild(self.__pre)
		if not self.wzscrollview is None:
			self.RemoveChild(self.wzscrollview)
		self.wzmkviews(list)
		self.wzresizetoview()
		self.wzsetviews()
	def wzextend(self):
		if self.wzlistview:
			self.wzlistview.extend()
	def wzinsert(self, list):
		self.wzlistview.insert(list)
	def wzdamage(self, i):
		if self.wzlistview:
			self.wzlistview.InvalidateItem(i)
	def wzfail(self, msg):
		self.__pre.SetText(msg)
	def wzmkviews(self, list):
		self.wzlistview = ListView(list, self.Bounds(), 'ListView',
				self.wzlistxy, self.wzitemdraw,
				self.qzsetfnmsg('wzpick'))
		self.wzscrollview = BScrollView('ScrollView',
			self.wzlistview,
			B_FOLLOW_ALL, B_WILL_DRAW, 0, 1, B_PLAIN_BORDER)
	def wzsetviews(self):
		self.AddChild(self.wzscrollview)
		#  PgUp/Dn don't work scrollbars until BListView has focus.
		self.wzlistview.MakeFocus(1)
	def wzresize(self):
		l, t, r, b = self.wzscrollview.Bounds()
		self.ResizeTo(r - 2.0, b - 2.0)
	def wzpick(self, msg):
		try:
			i = msg.FindInt32('index')
		except BMessage.error:
			#  Alas, BListView apparently will invoke on
			#  non-item on view margin.
			pass
		else:
			if i >= 0:
				if self.mzvisit(i, None):
					self.wzdamage(i)
	def wzjump(self, index):
		self.wzselectindex = index
		self.wzlistview.jump(index)
	def QuitRequested(self):
		configure.saveframe(self.__name, self.Frame())
		self.exit()
		return 1
	def exit():
		pass

class Mob:
	def __init__(self, name, fn, shortcut, always = 0):
		self.name = name
		self.fn = fn
		self.shortcut = shortcut
		self.always = always

#  More or less abstract class, to be subclassed in a more application
#  specific context that makes menus meaningful.
#
class MenuScrollWindow(ScrollWindow):
	wzlistxy = 20.0
	wzmenus = ()
	__fmenus = [('Find', 'wzfind', 'F', 1), ('Next', 'wzfind', 'G', 0)]
	def wzmkviews(self, list):
		ScrollWindow.wzmkviews(self, list)
		l, t, r, b = self.wzscrollview.Bounds()
		self.wzmenubar = BMenuBar((0.0, 0.0, r, self.wzlistxy), 'bar')
		self.wzaddmenus(self.wzmenubar)
		msg = self.qzsetfnmsg('wzselect')
		self.wzlistview.SetSelectionMessage(msg)
	def wzsetviews(self):
		l, t, r, b = self.wzscrollview.Bounds()
		self.AddChild(self.wzmenubar)
		ScrollWindow.wzsetviews(self)
	def wzaddmenus(self, bar):
		self.wzonselect = []
		self.wzmkmobs()
		self.wzmitemkey = {}
		for mname, mitems in self.wzmenus:
			menu = BMenu(mname)
			for id in mitems:
				msg = self.qzsetfnmsg(id.fn)
				if id.shortcut:
					item = BMenuItem(id.name, msg, id.shortcut)
					self.wzmitemkey[id.shortcut] = (item, msg)
				else:
					item = BMenuItem(id.name, msg)
				id.item = item
				menu.AddItem(item)
				#  Need more useful way to decide to enable.
				if not id.always:
					self.wzonselect.append(item)
					item.SetEnabled(0)
			bar.AddItem(menu)
	def wzselect(self, msg):
		try:
			self.wzselectindex = msg.FindInt32('index')
		except:
			#  Alas, one can select a non-item in BListView
			pass
		else:
			for i in self.wzonselect:
				i.SetEnabled(1)
			self.wzonselect = []
	def wzfind(self, msg):
		try:
			findstr = msg.FindString('pattern')
		except BMessage.error:
			findstr = None
			self.wzprompt = FPrompt(self, 'Search String')
			return
		findstr = string.lower(findstr)
		g, msg = self.wzmitemkey['G']
		try:
			msg.ReplaceString('pattern', findstr)
		except BMessage.error:
			msg.AddString('pattern', findstr)
		try:
			start = self.wzselectindex + 1
		except AttributeError:
			start = 0
		for i in range(start, len(self.wzlistview.list)):
			el = self.wzlistview.list[i]
			for x in el.value:
				if x:
					lx = string.lower(x)
					if string.find(lx, findstr) >= 0:
						self.wzlistview.jump(i)
						g.SetEnabled(1)
						return
		g.SetEnabled(0)
	def wzenablemenuitem(self, fn, val):
		for mn, mi in self.wzmenus:
			for id in mi:
				if id.fn == fn:
					id.item.SetEnabled(val)
					return
	def wzresizetoview(self):
		l, t, r, b = self.wzscrollview.Bounds()
		self.ResizeTo(r - 2.0, b + self.wzlistxy - 2.0)
	def wzmkmobs(self):
		#  Take class scope menu tags and create instance objects
		#  in current instance scope.
		#
		ml = []
		for mname, mitems in self.wzmenus:
			mil = []
			for mitem in mitems:
				m = apply(Mob, mitem)
				mil.append(m)
			ml.append((mname, mil))
		mil = []
		for mn, mf, short, always in MenuScrollWindow.__fmenus:
			m = Mob(mn, mf, short, always)
			mil.append(m)
		ml.append(('Search', mil))
		self.wzmenus = ml
