#  Copyright 1999 by Donn Cave, Seattle, Washington, USA.
#  All rights reserved.  Permission to copy, modify and distribute this
#  material is hereby granted, without fee, provided that the above
#  copyright notice appear in all copies.

import sys
import string
import os
import time

import rfc822
import struct

import BNode

from SupportKit import B_TIME_TYPE, B_STRING_TYPE, B_INT32_TYPE
from StorageKit import B_MIME_STRING_TYPE

akeys = [
	(B_MIME_STRING_TYPE, 'BEOS:TYPE', 'text/x-email\000'),
	(B_TIME_TYPE, 'MAIL:when', 'Date'),
	(B_STRING_TYPE, 'MAIL:priority', 'Priority'),
	(B_STRING_TYPE, 'MAIL:mime', 'MIME-Version'),
	(B_INT32_TYPE, 'MAIL:header_length', ''),
	(B_INT32_TYPE, 'MAIL:content_length', ''),
	(B_STRING_TYPE, 'MAIL:status', 'Status'),
	(B_STRING_TYPE, 'MAIL:from', 'From'),
	(B_STRING_TYPE, 'MAIL:name', 'From'),
	(B_STRING_TYPE, 'MAIL:to', 'To'),
	(B_STRING_TYPE, 'MAIL:cc', 'Cc'),
	(B_STRING_TYPE, 'MAIL:reply', 'In-Reply-To'),
	(B_STRING_TYPE, 'MAIL:subject', 'Subject')
]

def mkmail(msg, file):
	node = BNode.BNode(file)
	msgsize = node.GetStat()[6]
	for atype, name, htag in akeys:
		val = None
		if name == 'BEOS:TYPE':
			val = htag
		elif name == 'MAIL:content_length':
			val = msgsize - int(msg.startofbody)
		elif name == 'MAIL:header_length':
			val = int(msg.startofbody)
		elif name == 'MAIL:when':
			val = msg.getdate(htag)
			if val:
				val = time.mktime(val)
		elif name == 'MAIL:status':
			val = msg.getheader(htag)
			if not val:
				val = 'New\000'
			elif val[:1] == 'O':
				val = 'Read\000'
		elif name == 'MAIL:name':
			val, x = msg.getaddr(htag)
		else:
			val = msg.getheader(htag)

		if val is None:
			continue

		if atype == B_STRING_TYPE and val[-1:] != '\000':
			val = val + '\000'
		elif atype == B_INT32_TYPE or atype == B_TIME_TYPE:
			val = struct.pack('!i', val)

		node.WriteAttr(name, atype, 0, val)
