#  Copyright 1999 by Donn Cave, Seattle, Washington, USA.
#  All rights reserved.  Permission to copy, modify and distribute this
#  material is hereby granted, without fee, provided that the above
#  copyright notice appear in all copies.
#
#     (IMAP) Mail Folder cache
#

import cPickle
import posix
import posixpath
import sys

import configure

class MailCache:
	def __init__(self, cf, foldername):
		self.name = foldername
		try:
			mailcache = cf.mailcache
		except AttributeError:
			mailcache = '/boot/home/config/settings/pynr/' + cf.name
		if not posixpath.isdir(mailcache):
			# (probaby ought to be prepared to make whole path)
			posix.mkdir(mailcache)
		self.cachefile = '%s/%s' % (mailcache, foldername)
		self.found = {}
		try:
			fp = open(self.cachefile, 'r')
		except IOError:
			self.folderid = None
			self.uids = {}
		else:
			self.folderid = cPickle.load(fp)
			self.uids = cPickle.load(fp)
			fp.close()
	def verify(self, folderid):
		if self.folderid != folderid:
			self.folderid = folderid
			self.uids = {}
	def findmsg(self, uid, id, flags, msg):
		v = self.uids.get(uid)
		if v is None:
			return 0
		self.found[uid] = v
		msg.fromcache(id, flags, v)
		return 1
	def cachemsg(self, uid, msg):
		self.found[uid] = msg.cache()
	def dump(self):
		old = self.uids.keys()
		old.sort()
		self.uids = self.found
		new = self.uids.keys()
		new.sort()
		if new == old:
			return
		if self.folderid is None:
			return
		try:
			fp = open(self.cachefile, 'w')
		except IOError, val:
			print >> sys.stderr, 'cache file', self.cachefile, val
			return
		else:
			cPickle.dump(self.folderid, fp, 1)
			cPickle.dump(self.uids, fp, 1)
			fp.close()
