#  Copyright 1999 by Donn Cave, Seattle, Washington, USA.
#  All rights reserved.  Permission to copy, modify and distribute this
#  material is hereby granted, without fee, provided that the above
#  copyright notice appear in all copies.
#
#    Electronic mail messages.
#
import string
import sys

class Envelope:
	def __init__(self, text):
                # Some date
                # Subject
                # From/ReplyTo/Sender
                # From/ReplyTo/Sender
                # From/ReplyTo/Sender
                # Recipient
                # ?
                # ?
                # ?
                # Message-ID
		print 'envelope text', repr(text)
		# hm, I'm going to parse this mess and then just
		# put it together and give it to rfc822 to parse again?

import configure
from note import Note

class MailNote(Note):
	htags = ('From', 'Date', 'Subject')
	tags = ('ID', 'Flags') + htags
	width = (40.0, 30.0, 180.0, 100.0, 250.0)
	stdheaders = ('From', 'To', 'Date', 'Subject', 'Cc')
	def __init__(self):
		Note.__init__(self)
		self.value = ('(none)',) * len(self.htags)
	def fromscan(self, id, flags, text):
		self.id = id
		self.fromstring(text)
		# self.flags = flags
		self.flag = ''
		for f in flags:
			self.flag = self.flag + f[0]
		vl = [id, self.flag]
		self.hd = {}
		for h in self.htags:
			v = self.getheader(h)
			vl.append(v)
			self.hd[h] = v
		spam = self.getheader('X-Spam')
		if spam:
			k = spam.split(None, 2)[0]
			if k.endswith(';'):
				self.isaspam = k[:-1]
			else:
				self.isaspam = 'invalid: ' + spam
		self.value = tuple(vl)
	def fromcache(self, id, flags, value):
		self.id = id
		self.flag = ''
		for f in flags:
			self.flag = self.flag + f[0]
		if len(value) == 4:
			# print 'long', value
			self.isaspam = value[3]
			value = value[:3]
		else:
			# print 'short', value
			self.isaspam = 'short cache'
		self.value = (id, self.flag) + value
		self.hd = {}
		for i in range(len(self.htags)):
			h = self.htags[i]
			v = value[i]
			self.hd[h] = v
	def cache(self):
		c = self.value[2:] + (self.isaspam,)
		# print 'caching', c
		return c
#	def fromscanenv(self, id, flags, text):
#		self.id = id
#		self.fromstring(text)
#		# self.flags = flags
#		self.flag = ''
#		for f in flags:
#			self.flag = self.flag + f[0]
#		vl = [id, self.flag]
#		self.hd = {}
#		for h in self.htags:
#			v = self.getheader(h)
#			vl.append(v)
#			self.hd[h] = v
#		self.value = tuple(vl)
	def replyheaders(self):
		hl = []

		hl.append('To: %s' % self.getheader('From'))

		me = (configure.cf.realname,
			configure.cf.returnaddress)
		me = self.formataddress((me,))
		hl.append('From: %s' % me)

		#
		#  Cc is made of "To" + "Cc" where != me.
		#
		tl = self.rfc822.getaddrlist('Cc') +\
			 self.rfc822.getaddrlist('To')
		Cc = []
		try:
			ali = configure.cf.addresses
		except AttributeError:
			ali = (configure.cf.returnaddress,)
		for name, addr in tl:
			if addr:
				ar = addr
				if ar[:1] == '<':
					ar = ar[1:-1]
				for me in ali:
					if ar == me:
						break
				else:
					Cc.append((name, addr))
		if Cc:
			Cc = self.formataddress(Cc)
			hl.append('Cc: %s' % Cc)

		hl.append('X-Mailer: BeOS-PyNR V1')

		for h in ('Subject',):
			v = self.getheader(h)
			if v:
				if string.lower(v[:4]) == 're: ':
					hl.append('%s: %s' % (h, v))
				else:
					hl.append('%s: Re: %s' % (h, v))
		return hl
