#  Copyright 1999 by Donn Cave, Seattle, Washington, USA.
#  All rights reserved.  Permission to copy, modify and distribute this
#  material is hereby granted, without fee, provided that the above
#  copyright notice appear in all copies.
#
#  Message, RFC822 header plus body.
#  Base for NewsNote, MailNote
#
import binascii
import mimetools
import os
import quopri
import rfc822
import smtp
import string
from StringIO import StringIO
import tempfile

from support import convert_to_utf8, convert_from_utf8
import SupportKit
from AppKit import B_REFS_RECEIVED
from SupportKit import B_ALREADY_RUNNING

import configure
# from core import core
import mailattr

from BAlert import BAlert
from BEntry import BEntry
from BMessage import BMessage
from BMimeType import BMimeType
import BRoster
from BMessenger import BMessenger

class SaveFileName:
	evil = '#$&*()={}\\|;<>?\'"'
	ugly = '~!@%^+[]:, '
	def __init__(self):
		self.count = 0
		self.pid = 0
		scum = self.evil + self.ugly
		good = '_' * len(scum)
		self.cleantable = string.maketrans(scum, good)
	def mkname(self, when):
		if self.count == 0:
			self.pid = os.getpid()
		self.count = self.count + 1
		return 'email_%d_%06d_%d' % (when, self.pid, self.count)
	def cleanfn(self, fn, suf):
		fnd = string.split(fn, '.')
		if len(fnd) > 1:
			fn = string.join(fnd[:-1], '')
		fn = string.translate(fn, self.cleantable)
		return fn + suf

unique = SaveFileName()


#
#  Multipart message part behaves like message unto itself.
#
class Part(mimetools.Message):
	def __init__(self, fp, boundary):
		mimetools.Message.__init__(self, fp)
		self.boundary = boundary
	def file(self):
		stuff = self.getheader('Content-Disposition')
		fneq = 'filename="'
		if stuff:
			x = string.find(stuff, fneq)
			if x < 0:
				return None
		else:
			return None
		stuff = stuff[x + len(fneq):]
		x = string.find(stuff, '"')
		if x < 0:
			return None
		stuff = stuff[:x]
		stuff = string.split(stuff, '/')[-1]
		return stuff
	def show(self):
		mime = BMimeType(self.type)
		if not mime.IsInstalled():
			return 0
		try:
			sig = mime.GetPreferredApp()
		except:
			return 0
		try:
			msg = mime.GetFileExtensions()
		except:
			return 0
		suf = msg.FindString('extensions')
		t = self.body()
		fn = self.file()
		if fn:
			fn = unique.cleanfn(fn, suf)
		else:
			fn = 'spud.' + suf
		fn = '/tmp/' + fn
		fp = open(fn, 'w')
		fp.write(t)
		fp.close()
		entry = BEntry(fn)
		entry = entry.GetRef()
		msg = BMessage(B_REFS_RECEIVED)
		msg.AddRef('refs', entry)
		try:
			BRoster.be_roster.Launch(sig, msg)
			return
		except BRoster.error, v:
			if v.args[0] == B_ALREADY_RUNNING:
				pass
			else:
				raise
		mr = BMessenger(sig)
		mr.SendMessage(msg)
	def body(self):
		li = []
		encoding = self.getencoding()
		self.rewindbody()
		boundary = '--' + self.boundary
		i = 1
		while 1:
			l = self.fp.readline()
			if not l or l[:len(boundary)] == boundary:
				break
			li.append(l)
		if encoding == 'base64':
			for j in range(len(li)):
				li[j] = binascii.a2b_base64(li[j])
			s = string.join(li, '')
		elif encoding == 'quoted-printable':
			ipt = StringIO(string.join(li, ''))
			opt = StringIO()
			quopri.decode(ipt, opt)
			opt.seek(0)
			s = opt.read()
		else:
			s = string.join(li, '')
		li = string.split(s, '\r\n')
		return string.join(li, '\n')

def formataddr((name, addr)):
	if not name.startswith('"') and name.find(' ') >= 0 or name.find('.') >= 0:
		name = '"' + name + '"'
	return '%s <%s>' % (name, addr)

class Note:
	addrtags = ('From', 'To')
	isaspam = 'uninitialized'
	def __init__(self):
		self.hd = {}
		self.mtype = 'text/plain'
		self.actual = 0
		self.when = 0
		self.file_cs = getattr(configure.cf, 'ics_dfl', 'iso-8859-1')
		self.file_cs = string.lower(self.file_cs)
		self.file_cs_conversion = 0
	def getheader(self, h):
		v = self.hd.get(h)
		if not v:
			v = self.rfc822.getheader(h)
			#
			#  Headers are UTF-8, or ISO-8859-1?  I guess the
			#  latter, normally, but you decide.
			#
			if not v:
				return v
			if self.file_cs != 'utf-8':
				v = convert_to_utf8(self.file_cs_conversion, v)
		return v

	def formataddress(self, addr):
		return string.join(map(formataddr, addr), ', ')

	def fromfile(self, filename = None):
		self.actual = 1
		if filename is None:
			filename = self.filename
		else:
			self.filename = filename
		st = os.stat(filename)
		self.when = st[7]
		self.size = st[6]
		# self.BFile = BFile(filename, 0)
		self.file = open(filename, 'r')
		self.rfc822 = mimetools.Message(self.file)

		#  Check for explicit character set.
		for p in self.rfc822.getplist():
			if p[:8] == 'charset=':
				cs = p[8:]
				#  Could be quoted, upper case.
				if cs[:1] == '"':
					cs = cs[1:-1]
				self.file_cs = string.lower(cs)
				self.set_cs_conversion(self.file_cs)
				# core('report', self.__class__.__name__, 0,
				# 	'charset %s, conversion %s' % (self.file_cs, self.file_cs_conversion))
				break
		else:
			# core('report', self.__class__.__name__, 0,
			# 	'charset defaults to %s' % (self.file_cs,))
			pass
	def set_cs_conversion(self, cs):
		if cs[:9] == 'iso-8859-':
			cx = string.split(cs, '-')
			self.file_cs_conversion = getattr(SupportKit,
					'B_ISO%s_CONVERSION' % cx[2], 0)
	def qqhdr(self, original):
		#
		#  Quoted printable for =?charset?Q?str?=
		#  Throw away charset.
		#
		if not original:
			return original
		v = string.split(original, '?')
		x = None
		while 1:
			#  Skip along split string looking for the pattern.
			#  Process the string part, rejoin any preceding
			#  ...?... pieces and the decoded string, delete
			#  up to this point in the split list and start over.
			for i in range(2, len(v) - 2):
				if v[i] == 'Q' and v[i - 2][-1:] == '=' and v[i + 2][:1] == '=':
					# v[i-2]  ...='
					# v[i-1]  charset
					# v[i-0]  Q
					# v[i+1]  str
					# v[i+2]  '=...
					self.set_cs_conversion(string.lower(v[i - 1]))
					ipt = StringIO(v[i + 1])
					opt = StringIO()
					quopri.decode(ipt, opt)
					opt.seek(0)
					x = opt.read()
					if i > 2:
						v0 = string.join(v[:i - 1], '?')
					else:
						v0 = v[0]
					v0 = v0[:-1] + x + v[i + 2][1:]
					del v[1:i + 3]
					v[0] = v0
					break
			else:
				break
		if x:
			v = string.join(v, '?')
			return v
		else:
			return original
	def close(self):
		self.actual = 0
		self.file_cs = getattr(configure.cf, 'ics_dfl', 'iso-8859-1')
		self.rfc822 = None
		self.file = None
		self.dismiss()
	def fromstream(self, file):
		self.filename = None
		self.actual = 1
		self.file = file
		self.rfc822 = mimetools.Message(self.file)
		if hasattr(self, 'iiwzdamage'):
			self.iiwzdamage()
	def fromstrings(self, text):
		filename = tempfile.mktemp()
		self.tempfile = filename
		fp = open(filename, 'w')
		for t in text:
			fp.write(t)
			fp.write('\n')
		fp.close()
		self.fromfile(filename)

	def fromstring(self, text):
		self.rfc822 = rfc822.Message(StringIO(text))
		for h in ('from', 'subject'):
			v = self.rfc822.getheader(h)
			x = self.qqhdr(v)
			if not (x is v):
				self.rfc822[h] = x
		for h in self.htags:
			if h in self.addrtags:
				self.hd[h] = self.rfc822.getaddrlist(h)
			else:
				self.hd[h] = self.rfc822.getheader(h)
	def rewrite(self, stuff):
		if self.filename:
			fp = open(self.filename, 'w')
		else:
			filename = tempfile.mktemp()
			fp = open(filename, 'w')
			os.unlink(filename)
		for h in self.rfc822.headers:
			fp.write(h[:-2] + '\n')
		fp.write('\n')
		fp.write(stuff)
		if self.filename:
			fp.close()
			self.fromfile()
		else:
			fp.seek(0, 0)
			self.fromstream(fp)
	def body(self):
		self.rfc822.rewindbody()
		#  This is dubious with a big article!
		v = self.file.read(1024 * 1024)
		if self.file_cs != 'utf-8':
			v = convert_to_utf8(self.file_cs_conversion, v)
		return v
	def contents(self):
		if self.rfc822.maintype == 'multipart':
			self.rfc822.rewindbody()
			boundary = self.rfc822.getparam('boundary')
			boundary0 = '--' + boundary + '\n'
			boundaryn = '--' + boundary + '--\n'
			bl = []
			# Throw away segment 0, always empty.
			# Have seen multipart/mixed, multipart/signed
			while 1:
				ln = self.file.readline()
				if not ln:
					break
				if ln == boundary0:
					m = Part(self.file, boundary)
					bl.append(m)
				elif ln == boundaryn:
					break
			if bl:
				return bl
			#  If boundary is damaged, better to return the
			#  whole mess undigested than an empty part list.
		return (self,)
	def makereply(self, filename):
		send_cs = getattr(configure.cf, 'ocs_dfl', 'iso-8859-1')
		send_cs = string.lower(send_cs)
		if self.file_cs[:9] == 'iso-8859-' and send_cs == 'utf-8':
			cv = convert_to_utf8
		elif self.file_cs == 'utf-8' and send_cs[:9] == 'iso-8859-':
			cv = convert_from_utf8
		else:
			cv = None
		fp = open(filename, 'w')
		t = string.join(self.replyheaders(), '\n')
		if cv:
			t = cv(0, t)
		fp.write(t)
		fp.write('\n\n')
		t = 'Quoth %s:\n' % (self.hd['From'],)
		if send_cs != 'utf-8':
			#  hd['From'] is in display character set, i.e., UTF-8.
			t = convert_from_utf8(self.file_cs_conversion, t)
		fp.write(t)
		if hasattr(configure.cf, 'quote'):
			quote = configure.cf.quote
		else:
			quote = '> '
		bq = quote
		while bq[-1:] == ' ':
			bq = bq[:-1]
		bq = bq + '\n'
		llb = ''
		self.rfc822.rewindbody()
		while 1:
			flb = self.file.read(16384)
			lb = string.split(llb + flb, '\n')
			for li in lb[:-1]:
				if li:
					t = '%s%s\n' % (quote, li)
				else:
					t = bq
				if cv:
					t = cv(0, t)
				fp.write(t)
			if lb:
				llb = lb[-1]
			if not flb:
				break
		fp.close()
		#  XXX
		new = self.__class__()
		new.fromfile(filename)
		return new
	def savename(self):
		self.unique_name = unique.mkname(self.when)
		return self.unique_name
	def savetofile(self, name):
		fp = open(name, 'w')
		self.file.seek(0, 0)
		while 1:
			s = self.file.read(65535)
			if not s:
				break
			fp.write(s)
		fp.close()
		if name == self.unique_name:
			mailattr.mkmail(self.rfc822, file)
	def mail(self):
		e = smtp.sendreply(self)
		if e:
			alert = BAlert('SMTP Error', e, 'OK?', None, None, 2, 4)
			alert.Go()
	def post(self):
		pass
		#  core "post" function, uses filename
	def dismiss(self):
		try:
			if hasattr(self, 'tempfile'):
				os.unlink(self.tempfile)
		except AttributeError:
			pass
		except os.error:
			pass
	def __repr__(self):
		#  Display representation.
		hd = self.hd.get('Subject')
		if hd is None:
			hd = 'hd {no subject}'
		else:
			hd = 'hd {Subject: %s ...}' % (hd[:8],)
		try:
			rf = 'rfc822 fd %d' % self.rfc822.fp.fileno()
		except AttributeError:
			rf = 'no rfc822'
		try:
			fn = 'filename %s' % (self.filename,)
		except AttributeError:
			fn = 'no filename'
		return '%s, %s, %s' % (hd, rf, fn)
	# def __del__(self):
	# 	if hasattr(self, 'filename'):
	# 		print self.filename, 'gone'
