/*
	CMameView_8Bit.cc
	The BeMAME Team
	Created: 07/15/99 11:13:30
*/

#include "CMameView_8Bit.h"
#include <Bitmap.h>

CMameView_8Bit::CMameView_8Bit(
	BRect			inFrame) : CMameView(inFrame)
{
	SetViewColor(B_TRANSPARENT_COLOR);
	mBitmap = new BBitmap(inFrame, B_COLOR_8_BIT);
	mRefreshSemID = create_sem(0, "RefreshSem");
	resume_thread(mRefreshTHID = spawn_thread(RefreshEntry, "RefreshThread", B_DISPLAY_PRIORITY, this));
}

CMameView_8Bit::~CMameView_8Bit()
{
	delete_sem(mRefreshSemID);
	delete mBitmap;
}

void
CMameView_8Bit::Draw(
	BRect		 inRect)
{
	DrawBitmapAsync(mBitmap, BPoint(0, 0));
}

void
CMameView_8Bit::SetPenAtIdx(
	int32			inIdx,
	uint8			inRed,
	uint8			inGreen,
	uint8			inBlue)
{
}

int32
CMameView_8Bit::RefreshEntry(
	void		*inObj)
{
	CMameView_8Bit	*theObj = (CMameView_8Bit *)inObj;
	
	theObj->RefreshLoop();
	
	return 0;
}

void
CMameView_8Bit::RefreshLoop()
{
	while (acquire_sem(mRefreshSemID) == B_OK) {
		if (!sQuit) {
			LockLooper();
			DrawBitmapAsync(mBitmap, BPoint(0, 0));
			UnlockLooper();
		}
	}
}

void
CMameView_8Bit::Refresh()
{
	release_sem(mRefreshSemID);
}

