/*
	CMameScreen.h
	The BeMAME Team
*/

#ifndef CMAMESCREEN_H
#define CMAMESCREEN_H

#include <WindowScreen.h>
#include "CMameDisplay.h"

class CMameScreen : public BWindowScreen, public CMameDisplay {
public:
					CMameScreen(
						status_t		*outRet,
						BRect			inFrame,
						int				inColorDepth);
	virtual			~CMameScreen();
						
	virtual	void	ShutDown();

	virtual void	SetPenAtIdx(
						int32			inIdx,
						uint8			inRed,
						uint8			inGreen,
						uint8			inBlue);
	virtual void	SetPalette();
	virtual void	Update8BitDirect(
						uint8			*inSource,
						int32			inLineNumber,
						int32			inScreenWidth,
						int32			inVisibleWidth,
						bool			inDouble);
	virtual void	Update8BitDirectWScan(
						uint8			*inSource,
						int32			inLineNumber,
						int32			inScreenWidth,
						int32			inVisibleWidth);
    
	// global util funcs
	void			PixDblBlit8Bit(
						const void		*inSrcBitmap,
						int32			inSrcRowBytes,
						int32			inSrcWidth,
						int32			inSrcHeight,
						void			*outDstBitmap,
						int32			outDstRowBytes);
	void			PixDblBlit8BitWScan(
						const void		*inSrcBitmap,
						int32			inSrcRowBytes,
						int32			inSrcWidth,
						int32			inSrcHeight,
						void			*outDstBitmap,
						int32			outDstRowBytes);
private:

	void				ScreenConnected(
							bool		inConnected);
	bool				QuitRequested();
  
    BRect		mRequestedSize;
    rgb_color	mPalette[256];
	uint8		*mFrameBuf;
	uchar		*mDelta;
	int16		mLineLength; 
	int			mRequestedDepth;
    bool		mConnected;
};


#endif
