#ifndef __Converter_h__
#define __Converter_h__

#include <KernelKit.h>

class Converter
{
public:
				Converter(int32 buf_size=32768);
				~Converter();
	void		SetInStream(int32 speed, bool stereo=TRUE) { in_speed= (speed*SpeedAdj)/1000; in_stereo= stereo; CalcStepAndSpatie(); }
	void		SetOutStream(int32 speed, bool stereo=TRUE);
	void		Write(char *buf, int32 size/*, int32 data=0*/, bool EightBits= false);	// in bytes
	bool		Read(char *buf, int32 size);	// in bytes
	void		Discard();
//	void		Done(bool val) { done = val; }
//	void		fillData(int32);
//	int32		Data();
	
	bool		InStereo() { return in_stereo; }
	bool		OutStereo() { return out_stereo; }
	void		SetSpeedAdjustment(bool On) { SpeedAdjOn= On; if (!On) SpeedAdj= 1000; }
	void		SetNoGaps(bool no_gaps) { NoGaps= no_gaps; }
private:
	void		CalcStepAndSpatie();

	sem_id		full;
	sem_id		mutex;	
	
	int32		buf_size;
	int32		write_index;	
	int32		read_index;
	int32		bytes_in_buf;
	
	int32		in_speed;
	bool		in_stereo;
	int32		out_speed;
	bool		out_stereo;
	
//	bool		done;
	bool		waiting_for;

	char		*buffer;
	float		step;
	
	long SpeedAdj;  // In promille!
	int SpeedAdjCorr;
	bool LastWasToMuch;
	bool SpeedAdjOn, NoGaps;
};
#endif
