
#include "driver.h"
#include "dirty.h"

/* from video.c (required for 15.75KHz Arcade Monitor Modes) */
extern int half_yres;
extern int unchained;

extern char *dirty_old;
extern char *dirty_new;

extern struct osd_bitmap *scrbitmap;
extern int gfx_display_lines;
extern int gfx_width;
extern int gfx_height;
extern int skiplines;
extern int skipcolumns;

// From video.c
extern int vector_game;
extern int stretch;

void blitscreen_dirty1_vga(void)
{
	int required_width;
	int i;

	if (vector_game) {
		required_width = /*(stretch) ?*/ gfx_width /*: gfx_width/2*/;
	} else {
		if (Machine->orientation & ORIENTATION_SWAP_XY) {
			required_width = Machine->drv->screen_height;
		} else {
			required_width = Machine->drv->screen_width;
		//required_width = Machine->drv->visible_area.max_x - Machine->drv->visible_area.min_x + 1;
		}
	}
	
	beos_update_screen_8direct(
			scrbitmap->line[skiplines] + skipcolumns,
			gfx_display_lines - 1,
			required_width + 16,
			0);
}

void blitscreen_dirty1_vga_stretch(void)
{
	int required_width;
	int i;

	if (vector_game) {
		required_width = (stretch) ? gfx_width : gfx_width/2;
	} else {
		if (Machine->orientation & ORIENTATION_SWAP_XY) {
			required_width = Machine->drv->screen_height;
		} else {
			required_width = Machine->drv->screen_width;
		//required_width = Machine->drv->visible_area.max_x - Machine->drv->visible_area.min_x + 1;
		}
	}
	
	beos_update_screen_8direct(
			scrbitmap->line[skiplines] + skipcolumns,
			gfx_display_lines - 1,
			required_width + 16,
			1);
}


void blitscreen_dirty1_vga_scanlines(void)
{
	int required_width;
	int i;

	if (vector_game) {
		required_width = /*(stretch) ?*/ gfx_width /*: gfx_width/2*/;
	} else {
		if (Machine->orientation & ORIENTATION_SWAP_XY) {
			required_width = Machine->drv->screen_height;
		} else {
			required_width = Machine->drv->screen_width;
		//required_width = Machine->drv->visible_area.max_x - Machine->drv->visible_area.min_x + 1;
		}
	}
	
	beos_update_screen_8direct_scanlines(
			scrbitmap->line[skiplines] + skipcolumns,
			gfx_display_lines - 1,
			required_width + 16);
}


void blitscreen_dirty0_vga(void)
{
	int required_width;
	int i;

	if (vector_game) {
		required_width = /*(stretch) ?*/ gfx_width /*: gfx_width/2*/;
	} else {
		if (Machine->orientation & ORIENTATION_SWAP_XY) {
			required_width = Machine->drv->screen_height;
		} else {
			required_width = Machine->drv->screen_width;
		//required_width = Machine->drv->visible_area.max_x - Machine->drv->visible_area.min_x + 1;
		}
	}
	
	beos_update_screen_8direct(
			scrbitmap->line[skiplines] + skipcolumns,
			gfx_display_lines - 1,
			required_width + 16,
			0);
}


void blitscreen_dirty0_vga_stretch(void)
{
	int required_width;
	int i;

	if (vector_game) {
		required_width = (stretch) ? gfx_width : gfx_width/2;
	} else {
		if (Machine->orientation & ORIENTATION_SWAP_XY) {
			required_width = Machine->drv->screen_height;
		} else {
			required_width = Machine->drv->screen_width;
		//required_width = Machine->drv->visible_area.max_x - Machine->drv->visible_area.min_x + 1;
		}
	}
	
	beos_update_screen_8direct(
			scrbitmap->line[skiplines] + skipcolumns,
			gfx_display_lines - 1,
			required_width + 16);
}


void blitscreen_dirty0_vga_scanlines(void)
{
	int required_width;
	int i;

	if (vector_game) {
		required_width = (stretch) ? gfx_width : gfx_width/2;
	} else {
		if (Machine->orientation & ORIENTATION_SWAP_XY) {
			required_width = Machine->drv->screen_height;
		} else {
			required_width = Machine->drv->screen_width;
		//required_width = Machine->drv->visible_area.max_x - Machine->drv->visible_area.min_x + 1;
		}
	}
	
	beos_update_screen_8direct_scanlines(
			scrbitmap->line[skiplines] + skipcolumns,
			gfx_display_lines - 1,
			required_width + 16,
			1);
}

