/*
	CConfig.h
	The BeMAME Team
	Created: 08/13/99 08:27:39
*/

#ifndef CCONFIG_H
#define CCONFIG_H

#include <Message.h>

class CConfig {
public:
					CConfig();

	int32			GetBool(
						const char			*inGameName,
						const char			*inOption,
						const char			*inShortcut,
						int32				inDefault,
						bool				inParseCmdLine = false);
	int32			GetInt(
						const char			*inGameName,
						const char			*inOption,
						const char			*inShortcut,
						int32				inDefault,
						bool				inParseCmdLine = false);
	float			GetFloat(
						const char			*inGameName,
						const char			*inOption,
						const char			*inShortcut,
						float				inDefault,
						bool				inParseCmdLine = false);
	char *			GetString(
						const char			*inGameName,
						const char			*inOption,
						const char			*inShortcut,
						char				*inDefault,
						char				*outString,
						int32				inStringLen,
						bool				inParseCmdLine = false);
	void			SetBool(
						const char			*inGameName,
						const char			*inOption,
						int32				inVal);
	void			SetInt(
						const char			*inGameName,
						const char			*inOption,
						int32				inVal);
	void			SetFloat(
						const char			*inGameName,
						const char			*inOption,
						float				inVal);
	void			SetString(
						const char			*inGameName,
						const char			*inOption,
						char				*inString);
						
	ssize_t			ReadPref(
						const char *		inAttrName,
						type_code			inType,
						off_t				inOffset,
						void				*outBuf,
						size_t				inLen);
	ssize_t			WritePref(
						const char *		inAttrName,
						type_code			inType,
						off_t				inOffset,
						const void			*inBuf,
						size_t				inLen);
						
	void			ParseCmdLine(
						int32				inArgC,
						char				**inArgV,
						int32				inGameIdx);
	void			GetROMSamplePath(
						int32				inArgC,
						char				**inArgV,
						int32				inGameIdx);

private:
	status_t		FindEntry(
						BEntry *			outEntry);
	bool			ReadInt32(
						const char			*inGameName,
						const char			*inOptionName,
						int32				*ioInt32);
	void			WriteInt32(
						const char			*inGameName,
						const char			*inOptionName,
						int32				inInt32);
	bool			ReadFloat(
						const char			*inGameName,
						const char			*inOptionName,
						float				*ioFloat);
	void			WriteFloat(
						const char			*inGameName,
						const char			*inOptionName,
						float				inFloat);
	bool			ReadString(
						const char			*inGameName,
						const char			*inOptionName,
						int32				inStringLen,
						char				*ioString);
	void			WriteString(
						const char			*inGameName,
						const char			*inOptionName,
						char				*inString);
	void			ConfirmMessage(
						const char			*inGameName);
	void			ResetMessage(
						const char			*inGameName);
	void			WriteMessage();
	status_t		ReadMessage(
						const char			*inGameName);

	BMessage	mConfigMsg;
	int			mArgc;
	char 		**mArgv;
};

extern CConfig		gConfig;

#endif
