
#include "BeosSound.h"

#include "driver.h"
#include <time.h>

static BeosMameSound BeosPlayer;


// To be able to include c++ code I had to declare this part and make this file to an .cc file:
extern "C" {
	int beos_init_sound(void);
	void beos_shutdown_sound(void);

	int No_FM = 1; // Used in obj/sndhrdw/psgintf.o function: YM2203_sh_start
	
	int NoSound; 			// Used in obj/beos/config.o function: parse_cmdline
	int NoAdjust, NoGaps;	// Used in obj/beos/config.o function: parse_cmdline
	int usestereo;
}

int beos_init_sound(void)
{
	if (!NoSound) {
		BeosPlayer.On(NoAdjust, NoGaps);
	} 
	else {
		Machine->sample_rate= 0;
		BeosPlayer.Off();
	}
	return 0;
}

void beos_shutdown_sound(void)
{
	Machine->sample_rate= 0;
	BeosPlayer.Off();
}

void osd_play_sample(int channel,signed char *data,int len,int freq,int volume,int loop)
{
	if (BeosPlayer.IsOn()) {
		BeosPlayer.Play8BitsSample (channel, data, len, freq, volume, loop);	}
}

void osd_play_sample_16(int channel,signed short *data,int len,int freq,int volume,int loop)
{
	if (BeosPlayer.IsOn()) {
		BeosPlayer.Play16BitsSample (channel, data, len, freq, volume, loop); }
}

void osd_play_streamed_sample(int channel,signed char *data,int len,int freq,int volume,int pan)
{ 
	if (BeosPlayer.IsOn()) {
		BeosPlayer.Play8BitsStream (channel, data, len, freq, volume); }
}

void osd_play_streamed_sample_16(int channel,signed short *data,int len,int freq,int volume,int pan)
{ 
	if (BeosPlayer.IsOn()) {
		BeosPlayer.Play16BitsStream (channel, data, len, freq, volume); }
}

void osd_set_sample_freq(int channel,int freq)
{
	if (BeosPlayer.IsOn())
		BeosPlayer.AdjustSampleFrequency (channel, freq);
}

void osd_set_sample_volume(int channel,int volume)
{
	if (BeosPlayer.IsOn())
		BeosPlayer.AdjustSampleVolume (channel, volume);
}

void osd_stop_sample(int channel)
{
	if (BeosPlayer.IsOn())
		BeosPlayer.StopSample (channel);
}

void osd_restart_sample(int channel)
{
	if (BeosPlayer.IsOn())
		BeosPlayer.RestartSample (channel);
}

int osd_get_sample_status(int channel)
{
	return BeosPlayer.GetSampleStatus(channel);
}

/* attenuation in dB */
void osd_set_mastervolume(int _attenuation)
{
	BeosPlayer.SetMasterVolume(_attenuation);
}

int osd_get_mastervolume(void)
{
	return BeosPlayer.GetMasterVolume();
}

void osd_sound_enable(int enable_it)
{
	if (enable_it)
		BeosPlayer.On(NoAdjust, NoGaps);
	else {
		BeosPlayer.Off();
	}
}

void osd_opl_control(int chip,int reg)
{
	//printf ("osd_opl_control()\n");
}

void osd_opl_write(int chip,int data)
{
	//printf ("osd_ym3812_write()\n");
}



