/*
 *
 * $Id: Screen.h,v 1.8 1996/10/09 23:19:10 james Exp $
 *
 * Copyright (c) James Fidell 1994, 1995, 1996.
 *
 * Permission to use, copy, modify, distribute, and sell this software
 * and its documentation for any purpose is hereby granted without fee,
 * provided that the above copyright notice appear in all copies and
 * that both that copyright notice and this permission notice appear in
 * supporting documentation, and that the name of the copyright holder
 * not be used in advertising or publicity pertaining to distribution
 * of the software without specific, written prior permission. The
 * copyright holder makes no representations about the suitability of
 * this software for any purpose. It is provided "as is" without express
 * or implied warranty.
 *
 * THE COPYRIGHT HOLDER DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS
 * SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND
 * FITNESS, IN NO EVENT SHALL THE COPYRIGHT HOLDER BE LIABLE FOR ANY
 * SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER
 * RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF
 * CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN
 * CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 *
 */

/*
 * Modification History
 *
 * $Log: Screen.h,v $
 * Revision 1.8  1996/10/09 23:19:10  james
 * Added support for using the MIT X11 Shared Memory Extensions.
 *
 * Revision 1.7  1996/10/09 22:06:56  james
 * Overhaul of the bitmapped screen handling code with particular respect to
 * colour maps.
 *
 * Revision 1.6  1996/10/08 00:04:33  james
 * Added InfoWindow to show LED status.  Also required addition of the
 * SHIFTLOCK_SOUND_HACK to prevent the Shift Lock LED being light up
 * whenever the sound buffer is full, which means that far too much
 * time can be spent re-drawing the LED.
 *
 * Revision 1.5  1996/09/24 23:05:43  james
 * Update copyright dates.
 *
 * Revision 1.4  1996/09/23 16:09:52  james
 * Initial implementation of bitmap MODEs -- including modification of
 * screen handling to use different windows for teletext and bitmapped
 * modes and corrections/improvements to colour- and cursor-handling
 * code.
 *
 * Revision 1.3  1996/09/21 23:16:13  james
 * Loading of new X fonts for double height.  Unloading of all fonts.
 *
 * Revision 1.2  1996/09/21 22:13:50  james
 * Replaced "unsigned char" representation of 1 byte with "byteval".
 *
 * Revision 1.1  1996/09/21 17:20:40  james
 * Source files moved to src directory.
 *
 * Revision 1.1.1.1  1996/09/21 13:52:48  james
 * Xbeeb v0.1 initial release
 *
 *
 */


#ifndef	SCREEN_H
#define	SCREEN_H

extern	void			InitialiseScreen ( void );
extern	void			ShutdownScreen ( void );
extern	void			CheckEvents ( void );
extern	void			ScreenAddressStartHi ( byteval );
extern	void			ScreenAddressStartLo ( byteval );
extern	void			RecalculateScreenInfo ( void );

extern	unsigned char	ScreenMemoryChanged;
extern	unsigned char	ScreenImageChanged;

// Jon
#if 0
//#ifdef	_XLIB_H_

extern	GC				TtextTextGC;
extern	GC				TtextMosaicGC;

extern	GC				BitmapGC [ 16 ];
extern	GC				CopyAreaGC;

extern	Font			TtextText;
extern	Font			TtextTextDblU;
extern	Font			TtextTextDblL;
extern	Font			TtextContiguousMosaic;
extern	Font			TtextContiguousMosaicDblU;
extern	Font			TtextContiguousMosaicDblL;
extern	Font			TtextSeparateMosaic;
extern	Font			TtextSeparateMosaicDblU;
extern	Font			TtextSeparateMosaicDblL;

extern	Display			*dpy;
extern	Window			TeletextScreen;
extern	Window			BitmapScreen;
extern	Window			InfoWindow;
extern	Pixmap			BitmapPixmap;
extern	GC				CursorGC, InfoWindowGC;
extern	Colormap		DefCmap;
extern	unsigned long	InfoWindowRed, InfoWindowWhite, InfoWindowBlack;

#endif	// 0


#ifdef	MITSHM

extern	unsigned char	UseSharedXimage;
extern	unsigned char	UseSharedPixmap;
extern	char			*ImageData;
extern	int				BytesPerImageLine;
//extern	XImage			*BitmapImage;

#endif	/* MITSHM */
//#endif	/* _XLIB_H_ */


extern	unsigned long	Cells [ 16 ];
extern	unsigned long	Masks [ 4 ];
extern	unsigned long	ColourBits;
extern	int				RgbValues [ 8 ][ 3 ];

extern	byteval			ScreenLengthIndex;

#define	Black			Cells [ 0 ]
#define	Red				Cells [ 1 ]
#define	Green			Cells [ 2 ]
#define	Yellow			Cells [ 3 ]
#define	Blue			Cells [ 4 ]
#define	Magenta			Cells [ 5 ]
#define	Cyan			Cells [ 6 ]
#define	White			Cells [ 7 ]
#define	BlackWhite		Cells [ 8 ]
#define	RedCyan			Cells [ 9 ]
#define	GreenMagenta	Cells [ 10 ]
#define	YellowBlue		Cells [ 11 ]
#define	BlueYellow		Cells [ 12 ]
#define	MagentaGreen	Cells [ 13 ]
#define	CyanRed			Cells [ 14 ]
#define	WhiteBlack		Cells [ 15 ]

#endif	/* SCREEN_H */
