/*
	LMCommand.cpp
	12 October 2000
	This code is part of Ryan Lockhart's Lexmark 5xxx and 7xxx driver for BeOS.
	It is distributed with no warranty of any kind, in hope that it may be useful
	to someone.
*/

#include "LMCommand.h"
#include <malloc.h>
#include <stdio.h>

#define COL_LEN 28

LMCommand::LMCommand()
{
	swipe = NULL;
	outbits = NULL;
}

int32
LMCommand::SetData(byte * bits, int16 width, int16 start)
{
	int i;
	int j;
	int k;
	byte b;
	byte * temp;
	int32 target;
	int32 result = LMC_NO_DATA;
	
	if (swipe)
		delete swipe;
	if (outbits)
		free(outbits);
		
	width += SEP;
	outbits = (byte *)calloc(COL_LEN * width, sizeof(byte));
	if (!outbits)
		return LMC_ERROR;
		
	len = SWIPE_LEN + (COL_LEN * width);
	swipe = new LMSwipe(len, width, start, start + width - 1);
	
	temp = outbits;
	
	for (i=0; i<width; i++)
	{
		b = 0x20;
		memcpy(temp, &b, 1);
		temp++;
		b = 0x00;
		memcpy(temp, &b, 1);
		temp++;
		
		for (k=0; k<13; k++)
		{
			if (i >= SEP)
			{
				i -= SEP;
				target = (16 * k) * ((width-SEP)/8) + (int)floor((double)i / 8.0);
				
				
				for (j=0; j<8; j+=2)
				{
					temp[0] = temp[0] | ((bits[target + j * ((width-SEP)/8)] & (0x01 << (7 - (i % 8)))) >> (7 - (i % 8)) << (7 - (j % 8))); 
				}
		
				for (j=8; j<16; j+=2)
				{
					temp[1] = temp[1] | ((bits[target + j * ((width-SEP)/8)] & (0x01 << (7 - (i % 8)))) >> (7 - (i % 8)) << (7 - (j % 8))); 
				}
				i += SEP;
			}
			
			if (i < width - SEP)
			{
				target = (16 * k) * ((width-SEP)/8) + (int)floor((double)i / 8.0);
			
				for (j=1; j<8; j+=2)
				{
					temp[0] = temp[0] | ((bits[target + j * ((width-SEP)/8)] & (0x01 << (7 - (i % 8)))) >> (7 - (i % 8)) << (7 - (j % 8)));
				}
			
				for (j=9; j<16; j+=2)
				{
					temp[1] = temp[1] | ((bits[target + j * ((width-SEP)/8)] & (0x01 << (7 - (i % 8)))) >> (7 - (i % 8)) << (7 - (j % 8))); 
				}
			}
			
			if (temp[0] != 0 && temp[1] != 0)
				result = LMC_OK;
				
			temp +=2;
			
		}
	}
	
	return result;
}
 
LMCommand::~LMCommand()
{
	if (swipe)
		delete swipe;
	if (outbits)
		free(outbits);
}


status_t
LMCommand::Write(BDataIO * file)
{
	if ( (swipe->Write(file) == B_OK) && (file->Write(outbits, len - SWIPE_LEN) > 0) )
		return B_OK;
	else
		return B_ERROR;
}
