/*
	LMInit.cpp
	12 October 2000
	This code is part of Ryan Lockhart's Lexmark 5xxx and 7xxx driver for BeOS.
	It is distributed with no warranty of any kind, in hope that it may be useful
	to someone.
*/

#include "LMInit.h"

#define LX7_INIT1 0x1b,0x2a,0x6d,0x00,0x40,0x10,0x03,0x10,0x11 
#define LX7_INIT4 0x1b,0x2a,0x07,0x73,0x30 
#define LX7_INIT5 0x1b,0x2a,0x07,0x63
#define LX7_INIT6 0x1b,0x2a,0x6d,0x00,0x42,0x00,0x00

static byte init_bytes[INIT_LEN]={LX7_INIT1, LX7_INIT4, LX7_INIT5, LX7_INIT6};

LMInit::LMInit()
{
}

LMInit::~LMInit()
{
}

status_t
LMInit::Write(BDataIO * file)
{
	if (file->Write(init_bytes, INIT_LEN) > 0)
		return B_OK;
	else
		return B_ERROR;
}

	