/*
	LMJobSetupView.cpp
	12 October 2000
	This code is part of Ryan Lockhart's Lexmark 5xxx and 7xxx driver for BeOS.
	It is distributed with no warranty of any kind, in hope that it may be useful
	to someone.
*/

#include "LMJobSetupView.h"
#include <stdlib.h>
#include <stdio.h>

#define P_TOP 10
#define P_LEFT 10
#define P_HEIGHT 130
#define P_WIDTH 100

#define PB_TOP 20
#define PB_LEFT 10
#define PB_WIDTH 80
#define PB_HEIGHT 12

#define PT_LEFT 20
#define PT_WIDTH 70

#define C_TOP 10
#define C_LEFT 120
#define C_WIDTH 170
#define C_HEIGHT 80

#define CT_TOP 30
#define CT_LEFT 30
#define CT_WIDTH 70
#define CT_HEIGHT 12

#define B_TOP 100
#define B_WIDTH 80
#define B_LEFT 120
#define B_HEIGHT 40

#define ML_Y_PAD 10

LMJobSetupView::LMJobSetupView(BMessage * msg) 
: BView(BRect(0,0,JOB_SETUP_WIDTH, JOB_SETUP_HEIGHT), "Job Setup View", B_FOLLOW_ALL, B_WILL_DRAW)
{
	this->msg = msg;
}

void
LMJobSetupView::AttachedToWindow()
{
	BTextView * t;
	int i;
	char text[256];
	
	SetViewColor(ui_color(B_PANEL_BACKGROUND_COLOR));
	
	pagebox = new BBox(BRect(P_LEFT, P_TOP, P_LEFT + P_WIDTH, P_TOP + P_HEIGHT),
						"Pages");
	pagebox->SetLabel("Pages");
	AddChild(pagebox);
	
    all = new BRadioButton(BRect(PB_LEFT, PB_TOP, PB_LEFT + PB_WIDTH,
								PB_TOP + PB_HEIGHT), "all",
								"All", new BMessage(M_ALL));
	all->SetValue(1);
	
	pagebox->AddChild(all);
	
	range = new BRadioButton(BRect(PB_LEFT, PB_TOP + ML_Y_PAD + PB_HEIGHT,
								PB_LEFT + PB_WIDTH,
								PB_TOP + ML_Y_PAD + 2 * PB_HEIGHT), "range",
								"Range", new BMessage(M_RANGE));
	
	pagebox->AddChild(range);
	
	start = new BTextControl(BRect(PT_LEFT, PB_TOP + 2 * (ML_Y_PAD + PB_HEIGHT),
							PT_LEFT + PT_WIDTH,
							PB_TOP + PB_HEIGHT + 2 * (ML_Y_PAD + PB_HEIGHT)),
							"start", "Start:", "1", NULL);
							
	t = (BTextView *)start->ChildAt(0);
	for (i=0; i<256; i++)
		t->DisallowChar(i);
	for (i=48; i<58; i++)
		t->AllowChar(i);
	
	start->SetEnabled(false);
	pagebox->AddChild(start);
	
	end = new BTextControl(BRect(PT_LEFT, PB_TOP + 3 * (ML_Y_PAD + PB_HEIGHT),
							PT_LEFT + PT_WIDTH,
							PB_TOP + PB_HEIGHT + 3 * (ML_Y_PAD + PB_HEIGHT)),
							"end", "End:", "1", NULL);
							
	t = (BTextView *) end->ChildAt(0);
	for (i=0; i<256; i++)
		t->DisallowChar(i);
	for (i=48; i<58; i++)
		t->AllowChar(i);
		
	end->SetEnabled(false);
	pagebox->AddChild(end);
	
	cancel = new BButton(BRect(B_LEFT, B_TOP, B_LEFT + B_WIDTH, B_TOP + B_HEIGHT),
						"cancel", "Cancel", new BMessage(M_CANCEL));
						
	AddChild(cancel);
	
	ok = new BButton(BRect(B_LEFT + ML_Y_PAD + B_WIDTH, B_TOP,
					B_LEFT + B_WIDTH + B_WIDTH + ML_Y_PAD,
					B_TOP + B_HEIGHT),
					"ok", "OK", new BMessage(M_OK));
	ok->MakeDefault(true);
	
	AddChild(ok);
	
	copybox = new BBox(BRect(C_LEFT, C_TOP, C_LEFT + C_WIDTH, C_TOP + C_HEIGHT),
						"Copies");
	copybox->SetLabel("Number of Copies");
	AddChild(copybox);
	
	copies = new BTextControl(BRect(CT_LEFT, CT_TOP,
							CT_LEFT + CT_WIDTH,
							CT_TOP + CT_HEIGHT),
							"copies", "", "1", NULL);
							
	t = (BTextView *) copies->ChildAt(0);
	for (i=0; i<256; i++)
		t->DisallowChar(i);
	for (i=48; i<58; i++)
		t->AllowChar(i);
		
	copybox->AddChild(copies);
	
	if (msg)
	{
		if (msg->HasInt32("copies"))
		{
			sprintf(text, "%ld", msg->FindInt32("copies"));
			copies->SetText(text);
		}
	}
}

LMJobSetupView::~LMJobSetupView()
{
}

void
LMJobSetupView::UpdateJobData(BMessage * msg)
{
	int32 first, last;
	
	if (!msg)
		return;
		
	if (msg->HasInt32("copies"))
		msg->ReplaceInt32("copies", atoi(copies->Text()));
	else
		msg->AddInt32("copies", atoi(copies->Text()));
	
	if (range->Value() == 0)
	{
		first = 1;
		last = -1;
	}
	else
	{
		first = atoi(start->Text());
		last = atoi(end->Text());
	}
			
	if (msg->HasInt32("first_page"))
		msg->ReplaceInt32("first_page", first);
	else
		msg->AddInt32("first_page", first);
		
	if (msg->HasInt32("last_page"))
		msg->ReplaceInt32("last_page", last);
	else
		msg->AddInt32("last_page", last);
}
	

void
LMJobSetupView::EnableRange(bool enable)
{
	start->SetEnabled(enable);
	end->SetEnabled(enable);
}