/*
	LMPageEject.cpp
	12 October 2000
	This code is part of Ryan Lockhart's Lexmark 5xxx and 7xxx driver for BeOS.
	It is distributed with no warranty of any kind, in hope that it may be useful
	to someone.
*/

#include "LMPageEject.h"

#define LX7_PAGE_EJECT 0x1b, 0x2a, 0x07, 0x65

static byte eject_bytes[EJECT_LEN] = {LX7_PAGE_EJECT};

LMPageEject::LMPageEject()
{
}

LMPageEject::~LMPageEject()
{
}

status_t
LMPageEject::Write(BDataIO * file)
{
	if (file->Write(eject_bytes, EJECT_LEN) > 0)
		return B_OK;
	else
		return B_ERROR;
}
