#include "BitmapWindow.h"
#include "BitmapView.h"


BitmapWindow::BitmapWindow(const char * name, BBitmap * bitmap)
	: BWindow(BRect(0,0,600,600), name,
	B_DOCUMENT_WINDOW_LOOK, B_MODAL_APP_WINDOW_FEEL,
	B_ASYNCHRONOUS_CONTROLS)
{
	exit_sem 	= create_sem(0, "BitmapWindow");
	result 		= B_OK;
	
	BRect	r 	= Bounds();
	r.right 	-= B_V_SCROLL_BAR_WIDTH;
	r.bottom 	-= B_H_SCROLL_BAR_HEIGHT;
	
	BitmapView *	bv 	= new BitmapView(r, bitmap);
	BScrollView *	sv 	= new BScrollView("bitmap_scroll", bv,
										B_FOLLOW_ALL_SIDES, B_WILL_DRAW, true, true);
	AddChild(sv);
}


BitmapWindow::~BitmapWindow()
{
	delete_sem(exit_sem);
}




bool BitmapWindow::QuitRequested()
{
	release_sem(exit_sem);
	return true;
}

status_t BitmapWindow::Go()
{
	MoveTo(60,60);
	Show();
	acquire_sem(exit_sem);
	Lock();
	Quit();

	return result;
}

