#include <InterfaceKit.h>

#include "JobSetupWindow.h"



JobSetupWindow::JobSetupWindow(BMessage * msg)
	: BWindow(BRect(0,0,320,160), "Job Setup", B_TITLED_WINDOW_LOOK,
 			B_MODAL_APP_WINDOW_FEEL, B_NOT_RESIZABLE | B_NOT_MINIMIZABLE |
 			B_NOT_ZOOMABLE)
{
	setup_msg	= msg;
	exit_sem 	= create_sem(0, "JobSetup");
	result 		= B_ERROR;
	
	// ---- Ok, build a default job setup user interface
	BRect		r;
	BBox * 		panel;
	BButton * 	button;
	float		x, y, w, h;
	
	r = Bounds();

	// add a *dialog* background
	panel = new BBox(r, "top_panel", B_FOLLOW_ALL, 
					B_WILL_DRAW | B_FRAME_EVENTS | B_NAVIGABLE_JUMP,
					B_PLAIN_BORDER);

	x = r.top + 8;
	y = r.left + 8;
	
	// add a "copies" input field
	BTextControl * tc;
	tc = new BTextControl(BRect(x, y, x+100, y+20), "copies", "Copies:", "1", NULL);
	tc->ResizeToPreferred();
	tc->GetPreferredSize(&w, &h);
	
	panel->AddChild(tc);
	
	y += h + 16;
	
	// add a "pages" radio toggle
	BStringView * sv;
	sv = new BStringView(BRect(x, y, x+100, y+20), "pages", "Pages:");
	sv->ResizeToPreferred();
	sv->GetPreferredSize(&w, &h);

	panel->AddChild(sv);

	x += w + 8;
	
	BRadioButton * rb;
	rb = new BRadioButton(BRect(x, y, x+100, y+20), "all_pages", "All", NULL);
	rb->ResizeToPreferred();
	rb->GetPreferredSize(&w, &h);
	rb->SetValue(true);

	panel->AddChild(rb);

	x += w + 8;

	rb = new BRadioButton(BRect(x, y, x+100, y+20), "from_pages", "From:", NULL);
	rb->ResizeToPreferred();
	rb->GetPreferredSize(&w, &h);
	rb->SetValue(false);
	panel->AddChild(rb);
	x += w + 8;
	
	// add a "OK" button, and make it default
	button 	= new BButton(r, NULL, "OK", new BMessage(OK_MSG), B_FOLLOW_RIGHT | B_FOLLOW_BOTTOM);
	button->ResizeToPreferred();
	button->GetPreferredSize(&w, &h);
	x = r.right - w - 8;
	y = r.bottom - h - 8;
	button->MoveTo(x, y);
	panel->AddChild(button);
	button->MakeDefault(true);

	// add a "Cancel button	
	button 	= new BButton(r, NULL, "Cancel", new BMessage(CANCEL_MSG), B_FOLLOW_RIGHT | B_FOLLOW_BOTTOM);
	button->GetPreferredSize(&w, &h);
	button->ResizeToPreferred();
	button->MoveTo(x - w - 8, y);
	panel->AddChild(button);

	// add a separator line...
	BBox * line = new BBox(BRect(r.left, y - 9, r.right, y - 8), NULL,
						 B_FOLLOW_LEFT_RIGHT | B_FOLLOW_BOTTOM );
	panel->AddChild(line);

	// Finally, add our panel to window
	AddChild(panel);
}



JobSetupWindow::~JobSetupWindow()
{
	delete_sem(exit_sem);
}



bool JobSetupWindow::QuitRequested()
{
	release_sem(exit_sem);
	return true;
}


void JobSetupWindow::MessageReceived(BMessage * msg)
{
	switch (msg->what)
		{
		case OK_MSG:
			result = B_OK;
			release_sem(exit_sem);
			break;
		
		case CANCEL_MSG:
			result = B_ERROR;
			release_sem(exit_sem);
			break;
		
		default:
			inherited::MessageReceived(msg);
			break;
		};
}
			

status_t JobSetupWindow::Go()
{
	MoveTo(300,300);
	Show();
	acquire_sem(exit_sem);
	Lock();
	Quit();

	return result;
}

